/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.views;

import com.google.common.collect.Sets;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.libcompviews.ResourceChangeListener;
import info.scce.dime.libcompviews.nodes.TreeNode;
import info.scce.dime.libcompviews.pages.UICompPage;
import info.scce.dime.libcompviews.provider.UICompTreeProvider;
import info.scce.dime.libcompviews.utils.LibCompUtils;
import info.scce.dime.libcompviews.views.LibCompView;
import info.scce.dime.process.process.Process;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class UICompView
extends LibCompView<UICompPage> {
    public static final String ID = "info.scce.dime.libcompviews.views.UI";
    private IAction createFileAction;
    private IAction showFolderStructViewAction;
    private IAction showCategoryViewAction;
    private IAction filterAllowedTypesAction;
    private IAction showReferencedInViewAction;

    public UICompView() {
        HashMap<String, HashSet> obsDefinition = new HashMap<String, HashSet>();
        obsDefinition.put("process", Sets.newHashSet((Object[])new ResourceChangeListener.ListenerEvents[]{ResourceChangeListener.ListenerEvents.REMOVED, ResourceChangeListener.ListenerEvents.ADDED, ResourceChangeListener.ListenerEvents.CONTENT_CHANGE}));
        obsDefinition.put("gui", Sets.newHashSet((Object[])new ResourceChangeListener.ListenerEvents[]{ResourceChangeListener.ListenerEvents.REMOVED, ResourceChangeListener.ListenerEvents.ADDED, ResourceChangeListener.ListenerEvents.CONTENT_CHANGE}));
        obsDefinition.put("dad", Sets.newHashSet((Object[])new ResourceChangeListener.ListenerEvents[]{ResourceChangeListener.ListenerEvents.REMOVED, ResourceChangeListener.ListenerEvents.ADDED, ResourceChangeListener.ListenerEvents.CONTENT_CHANGE}));
        obsDefinition.put("sibs", Sets.newHashSet((Object[])new ResourceChangeListener.ListenerEvents[]{ResourceChangeListener.ListenerEvents.REMOVED, ResourceChangeListener.ListenerEvents.ADDED, ResourceChangeListener.ListenerEvents.CONTENT_CHANGE}));
        this.obsDefinition = obsDefinition;
        this.genericParameterClass = UICompPage.class;
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        MenuManager filterSubmenu = new MenuManager("Filters");
        filterSubmenu.add(this.filterAllowedTypesAction);
        MenuManager viewSubmenu = new MenuManager("Display Mode");
        viewSubmenu.add(this.showFolderStructViewAction);
        viewSubmenu.add(this.showCategoryViewAction);
        manager.add((IContributionItem)filterSubmenu);
        manager.add((IContributionItem)viewSubmenu);
        manager.add((IContributionItem)new Separator());
        manager.add(this.showReferencedInViewAction);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add(this.openModelAction);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.reloadAction);
        manager.add(this.expandAllAction);
        manager.add(this.collapseAllAction);
        manager.add(this.linkWithEditorAction);
        manager.add((IContributionItem)new Separator());
    }

    @Override
    protected void makeActions() {
        super.makeActions();
        this.createFileAction = new Action(){

            public void run() {
            }
        };
        this.createFileAction.setText("Create process model");
        this.createFileAction.setToolTipText("Create process model");
        this.createFileAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.iconCreateFile));
        this.showFolderStructViewAction = new Action(){

            public void run() {
                ((UICompPage)UICompView.this.activePage).getDataProvider().setActiveView(UICompTreeProvider.ViewType.FOLDERSTRUCT);
                LibCompUtils.runBusy(new Runnable(){

                    @Override
                    public void run() {
                        ((UICompPage)(this).UICompView.this.activePage).reload();
                        UICompView.this.reloadViewState();
                    }
                });
            }
        };
        this.showFolderStructViewAction.setText("by Folder Structure");
        this.showFolderStructViewAction.setToolTipText("show folder structure view");
        this.showFolderStructViewAction.setChecked(true);
        this.showCategoryViewAction = new Action(){

            public void run() {
                ((UICompPage)UICompView.this.activePage).getDataProvider().setActiveView(UICompTreeProvider.ViewType.CATEGORY);
                LibCompUtils.runBusy(new Runnable(){

                    @Override
                    public void run() {
                        ((UICompPage)(this).UICompView.this.activePage).reload();
                        UICompView.this.reloadViewState();
                    }
                });
            }
        };
        this.showCategoryViewAction.setText("by Category");
        this.showCategoryViewAction.setToolTipText("show category view");
        this.showCategoryViewAction.setChecked(false);
        this.showReferencedInViewAction = new Action(){

            public void run() {
                boolean temp = ((UICompPage)UICompView.this.activePage).getDataProvider().isShowReferencedInInfo();
                ((UICompPage)UICompView.this.activePage).getDataProvider().setShowReferencedInInfo(!temp);
                LibCompUtils.runBusy(new Runnable(){

                    @Override
                    public void run() {
                        ((UICompPage)(this).UICompView.this.activePage).reload();
                        UICompView.this.reloadViewState();
                    }
                });
            }
        };
        this.showReferencedInViewAction.setText("Show referenced info");
        this.showReferencedInViewAction.setToolTipText("Show referenced info");
        this.showReferencedInViewAction.setChecked(false);
        this.filterAllowedTypesAction = new Action(){

            public void run() {
                if (!((UICompPage)UICompView.this.activePage).isShowOnlyAllowedTypes()) {
                    ((UICompPage)UICompView.this.activePage).getTreeViewer().addFilter((ViewerFilter)((UICompPage)UICompView.this.activePage).getModelTypeFilter());
                    ((UICompPage)UICompView.this.activePage).setShowOnlyAllowedTypes(true);
                } else {
                    ((UICompPage)UICompView.this.activePage).getTreeViewer().removeFilter((ViewerFilter)((UICompPage)UICompView.this.activePage).getModelTypeFilter());
                    ((UICompPage)UICompView.this.activePage).setShowOnlyAllowedTypes(false);
                }
                UICompView.this.reloadViewState();
            }
        };
        this.filterAllowedTypesAction.setText("filter allowed types");
        this.filterAllowedTypesAction.setToolTipText("filter allowed types");
        this.filterAllowedTypesAction.setChecked(false);
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = UICompView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof TreeNode) {
                    ((UICompPage)UICompView.this.activePage).storeTreeState();
                    Object data = ((TreeNode)obj).getData();
                    if (data instanceof Process) {
                        ((UICompPage)UICompView.this.activePage).openAndHighlight(data);
                    } else if (data instanceof GUI) {
                        ((UICompPage)UICompView.this.activePage).openAndHighlight(data);
                    } else if (data instanceof DAD) {
                        ((UICompPage)UICompView.this.activePage).openAndHighlight(data);
                    } else {
                        ((UICompPage)UICompView.this.activePage).toggleExpand(obj);
                        ((UICompPage)UICompView.this.activePage).storeTreeState();
                    }
                }
            }
        };
    }

    @Override
    protected void reloadViewState() {
        this.filterAllowedTypesAction.setChecked(((UICompPage)this.activePage).isShowOnlyAllowedTypes());
        this.showCategoryViewAction.setChecked(false);
        this.showFolderStructViewAction.setChecked(false);
        switch (((UICompPage)this.activePage).getDataProvider().getActiveView()) {
            case CATEGORY: {
                this.showCategoryViewAction.setChecked(true);
                break;
            }
            case FOLDERSTRUCT: {
                this.showFolderStructViewAction.setChecked(true);
                break;
            }
        }
        this.showReferencedInViewAction.setChecked(((UICompPage)this.activePage).getDataProvider().isShowReferencedInInfo());
        ((UICompPage)this.activePage).getTreeViewer().refresh();
    }

    @Override
    protected void editorChanged() {
        ((UICompPage)this.activePage).calculateModelTypesToHide((IResource)this.activeFile);
        super.editorChanged();
        ((UICompPage)this.activePage).getTreeViewer().refresh();
        ((UICompPage)this.activePage).restoreTreeState();
    }
}

