/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.views;

import info.scce.dime.libcompviews.ResourceChangeListener;
import info.scce.dime.libcompviews.pages.LibCompPage;
import info.scce.dime.libcompviews.utils.LibCompUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class LibCompView<T extends LibCompPage>
extends ViewPart
implements IPartListener2 {
    protected Class<T> genericParameterClass;
    protected Map<String, Set<ResourceChangeListener.ListenerEvents>> obsDefinition;
    private Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
    private Composite parent;
    protected T activePage;
    protected TreeViewer viewer;
    protected IFile activeFile;
    private HashMap<String, T> pageMap = new HashMap();
    protected IAction doubleClickAction;
    protected IAction expandAllAction;
    protected IAction collapseAllAction;
    protected IAction linkWithEditorAction;
    protected IAction reloadAction;
    protected IAction openModelAction;
    protected Image iconRefresh;
    protected Image iconCreateFile;
    protected Image iconCollapseAll;
    protected Image iconExpandAll;
    protected Image iconLinkWithEditor;
    private ResourceChangeListener resourceChangeListener;

    public IFile getActiveFile() {
        return this.activeFile;
    }

    public T getActivePage() {
        return this.activePage;
    }

    public HashMap<String, T> getPageMap() {
        return this.pageMap;
    }

    private T createPage(Class<T> clazz, Composite c, ViewPart vp, IProject project) throws InstantiationException, IllegalAccessException, IOException {
        LibCompPage page = (LibCompPage)clazz.newInstance();
        page.initPage(c, vp, project);
        return (T)page;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.parent.setLayout((Layout)new GridLayout(1, true));
        this.parent.setLayoutData((Object)new GridData(4, 4, true, true));
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener2)this);
        this.resourceChangeListener = new ResourceChangeListener(this, this.obsDefinition);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        try {
            this.loadIcons();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.makeActions();
        this.contributeToActionBars();
        this.loadPageByEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor());
    }

    private void initControls() {
        this.viewer = ((LibCompPage)this.activePage).getTreeViewer();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "libcompview.viewer");
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LibCompView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void loadIcons() throws IOException {
        this.iconRefresh = new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/refresh.gif"), (boolean)true));
        this.iconCreateFile = new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/create_file.gif"), (boolean)true));
        this.iconCollapseAll = new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/collapseall.png"), (boolean)true));
        this.iconExpandAll = new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/expandall.gif"), (boolean)true));
        this.iconLinkWithEditor = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_SYNCED");
    }

    protected abstract void fillLocalPullDown(IMenuManager var1);

    protected abstract void fillContextMenu(IMenuManager var1);

    protected abstract void fillLocalToolBar(IToolBarManager var1);

    protected void makeActions() {
        this.reloadAction = new Action(){

            public void run() {
                if (LibCompView.this.activePage != null) {
                    ((LibCompPage)LibCompView.this.activePage).reload();
                }
                LibCompView.this.refreshView();
            }
        };
        this.reloadAction.setText("Reload");
        this.reloadAction.setToolTipText("Reload");
        this.reloadAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.iconRefresh));
        this.linkWithEditorAction = new Action(){

            public void run() {
                if (LibCompView.this.activePage != null) {
                    ((LibCompPage)LibCompView.this.activePage).selectTreeItem(LibCompView.this.getActiveFile());
                }
            }
        };
        this.linkWithEditorAction.setText("Link with editor");
        this.linkWithEditorAction.setToolTipText("Link with editor");
        this.linkWithEditorAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.iconLinkWithEditor));
        this.openModelAction = new Action(){

            public void run() {
                ISelection selection = LibCompView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ((LibCompPage)LibCompView.this.activePage).openAndHighlight(obj);
            }
        };
        this.openModelAction.setText("open model");
        this.openModelAction.setToolTipText("open model");
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = LibCompView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ((LibCompPage)LibCompView.this.activePage).toggleExpand(obj);
                ((LibCompPage)LibCompView.this.activePage).storeTreeState();
            }
        };
        this.expandAllAction = new Action(){

            public void run() {
                if (LibCompView.this.activePage != null) {
                    ((LibCompPage)LibCompView.this.activePage).getTreeViewer().expandAll();
                    ((LibCompPage)LibCompView.this.activePage).storeTreeState();
                }
            }
        };
        this.expandAllAction.setText("Expand all");
        this.expandAllAction.setToolTipText("Expand all");
        this.expandAllAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.iconExpandAll));
        this.collapseAllAction = new Action(){

            public void run() {
                if (LibCompView.this.activePage != null) {
                    ((LibCompPage)LibCompView.this.activePage).getTreeViewer().collapseAll();
                    ((LibCompPage)LibCompView.this.activePage).storeTreeState();
                }
            }
        };
        this.collapseAllAction.setText("Collapse all");
        this.collapseAllAction.setToolTipText("Collapse all");
        this.collapseAllAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.iconCollapseAll));
    }

    protected abstract void reloadViewState();

    protected void setActivePage(T activePage) {
        this.activePage = activePage;
    }

    protected void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void hookDoubleClickAction() {
        ((LibCompPage)this.activePage).getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LibCompView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
    }

    public void refreshView() {
        if (!this.parent.isDisposed()) {
            this.parent.layout(true, true);
            this.parent.redraw();
            this.parent.update();
        }
    }

    protected void editorChanged() {
        this.refreshView();
    }

    protected void activePageChanged() {
        this.reloadViewState();
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (partRef instanceof EditorReference) {
            this.loadPageByEditor(((EditorReference)partRef).getEditor(true));
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void loadPageByEditor(IEditorPart editor) {
        if (editor == null) {
            return;
        }
        IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            System.err.println("[LibCompView] WARN: Failed to load editor page. Input file is null for: " + editor);
            return;
        }
        this.activeFile = file;
        if (this.parent.isDisposed()) {
            return;
        }
        if (this.activePage == null || !file.getProject().getName().equals(((LibCompPage)this.activePage).getProject().getName())) {
            Control[] controlArray = this.parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setVisible(false);
                if (child.getLayoutData() instanceof GridData) {
                    ((GridData)child.getLayoutData()).exclude = true;
                }
                ++n2;
            }
            if (!this.pageMap.keySet().contains(file.getProject().getName())) {
                try {
                    T newPage = this.createPage(this.genericParameterClass, this.parent, this, file.getProject());
                    this.pageMap.put(file.getProject().getName(), newPage);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.setActivePage((LibCompPage)this.pageMap.get(file.getProject().getName()));
            ((LibCompPage)this.activePage).getFrameComposite().setVisible(true);
            ((GridData)((LibCompPage)this.activePage).getFrameComposite().getLayoutData()).exclude = false;
            this.initControls();
            this.activePageChanged();
        }
        this.editorChanged();
    }

    public void dispose() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener((IPartListener2)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        super.dispose();
    }
}

