/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.views;

import com.google.common.collect.Sets;
import info.scce.dime.libcompviews.ResourceChangeListener;
import info.scce.dime.libcompviews.pages.DataCompPage;
import info.scce.dime.libcompviews.provider.DataCompTreeProvider;
import info.scce.dime.libcompviews.utils.LibCompUtils;
import info.scce.dime.libcompviews.views.LibCompView;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class DataCompView
extends LibCompView<DataCompPage> {
    public static final String ID = "info.scce.dime.libcompviews.views.Data";
    private IAction filterAbstractTypesAction;
    private IAction showFlatViewAction;
    private IAction showHierarchicalViewAction;
    private IAction showInheritanceInfoAction;
    private IAction createFileAction;

    public DataCompView() {
        HashMap<String, HashSet> obsDefinition = new HashMap<String, HashSet>();
        obsDefinition.put("data", Sets.newHashSet((Object[])new ResourceChangeListener.ListenerEvents[]{ResourceChangeListener.ListenerEvents.ADDED, ResourceChangeListener.ListenerEvents.REMOVED, ResourceChangeListener.ListenerEvents.CONTENT_CHANGE}));
        obsDefinition.put("sibs", Sets.newHashSet((Object[])new ResourceChangeListener.ListenerEvents[]{ResourceChangeListener.ListenerEvents.ADDED, ResourceChangeListener.ListenerEvents.REMOVED, ResourceChangeListener.ListenerEvents.CONTENT_CHANGE}));
        this.obsDefinition = obsDefinition;
        this.genericParameterClass = DataCompPage.class;
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        MenuManager filterSubmenu = new MenuManager("Filters");
        filterSubmenu.add(this.filterAbstractTypesAction);
        MenuManager viewSubmenu = new MenuManager("Display Mode");
        viewSubmenu.add(this.showFlatViewAction);
        viewSubmenu.add(this.showHierarchicalViewAction);
        manager.add((IContributionItem)filterSubmenu);
        manager.add((IContributionItem)viewSubmenu);
        manager.add((IContributionItem)new Separator());
        manager.add(this.showInheritanceInfoAction);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add(this.openModelAction);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.reloadAction);
        manager.add(this.expandAllAction);
        manager.add(this.collapseAllAction);
        manager.add(this.linkWithEditorAction);
        manager.add((IContributionItem)new Separator());
    }

    @Override
    protected void makeActions() {
        super.makeActions();
        this.createFileAction = new Action(){

            public void run() {
            }
        };
        this.createFileAction.setText("Create data model");
        this.createFileAction.setToolTipText("Create data model");
        this.createFileAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.iconCreateFile));
        this.filterAbstractTypesAction = new Action(){

            public void run() {
                if (!((DataCompPage)DataCompView.this.activePage).isHideAbstractTypes()) {
                    ((DataCompPage)DataCompView.this.activePage).getTreeViewer().addFilter((ViewerFilter)((DataCompPage)DataCompView.this.activePage).getFilterAbstractType());
                    ((DataCompPage)DataCompView.this.activePage).setHideAbstractTypes(true);
                } else {
                    ((DataCompPage)DataCompView.this.activePage).getTreeViewer().removeFilter((ViewerFilter)((DataCompPage)DataCompView.this.activePage).getFilterAbstractType());
                    ((DataCompPage)DataCompView.this.activePage).setHideAbstractTypes(false);
                }
                DataCompView.this.reloadViewState();
            }
        };
        this.filterAbstractTypesAction.setText("filter abstract types");
        this.filterAbstractTypesAction.setToolTipText("filter abstract types");
        this.filterAbstractTypesAction.setChecked(false);
        this.showFlatViewAction = new Action(){

            public void run() {
                ((DataCompPage)DataCompView.this.activePage).getDataProvider().setActiveView(DataCompTreeProvider.ViewType.FLAT);
                ((DataCompPage)DataCompView.this.activePage).setShowInheritanceInfo(true);
                ((DataCompPage)DataCompView.this.activePage).getTreeViewer().setLabelProvider((IBaseLabelProvider)((DataCompPage)DataCompView.this.activePage).getDefaultLabelProvider());
                LibCompUtils.runBusy(new Runnable(){

                    @Override
                    public void run() {
                        ((DataCompPage)(this).DataCompView.this.activePage).reload();
                        DataCompView.this.reloadViewState();
                    }
                });
            }
        };
        this.showFlatViewAction.setText("Flat");
        this.showFlatViewAction.setToolTipText("show flat view");
        this.showFlatViewAction.setChecked(true);
        this.showHierarchicalViewAction = new Action(){

            public void run() {
                ((DataCompPage)DataCompView.this.activePage).getDataProvider().setActiveView(DataCompTreeProvider.ViewType.HIERARCHY);
                ((DataCompPage)DataCompView.this.activePage).setShowInheritanceInfo(false);
                ((DataCompPage)DataCompView.this.activePage).getTreeViewer().removeFilter((ViewerFilter)((DataCompPage)DataCompView.this.activePage).getFilterAbstractType());
                ((DataCompPage)DataCompView.this.activePage).setHideAbstractTypes(false);
                ((DataCompPage)DataCompView.this.activePage).getTreeViewer().setLabelProvider((IBaseLabelProvider)((DataCompPage)DataCompView.this.activePage).getDefaultLabelProvider());
                LibCompUtils.runBusy(new Runnable(){

                    @Override
                    public void run() {
                        ((DataCompPage)(this).DataCompView.this.activePage).reload();
                        DataCompView.this.reloadViewState();
                    }
                });
            }
        };
        this.showHierarchicalViewAction.setText("Hierarchical");
        this.showHierarchicalViewAction.setToolTipText("show hierarchical view");
        this.showHierarchicalViewAction.setChecked(false);
        this.showInheritanceInfoAction = new Action(){

            public void run() {
                boolean state = ((DataCompPage)DataCompView.this.activePage).isShowInheritanceInfo();
                ((DataCompPage)DataCompView.this.activePage).setShowInheritanceInfo(!state);
                ((DataCompPage)DataCompView.this.activePage).getTreeViewer().setLabelProvider((IBaseLabelProvider)((DataCompPage)DataCompView.this.activePage).getDefaultLabelProvider());
                DataCompView.this.reloadViewState();
            }
        };
        this.showInheritanceInfoAction.setText("show inheritance");
        this.showInheritanceInfoAction.setToolTipText("show inheritance information");
        this.showInheritanceInfoAction.setChecked(true);
    }

    @Override
    protected void reloadViewState() {
        this.filterAbstractTypesAction.setChecked(((DataCompPage)this.activePage).isHideAbstractTypes());
        this.showInheritanceInfoAction.setChecked(((DataCompPage)this.activePage).isShowInheritanceInfo());
        this.showFlatViewAction.setChecked(false);
        this.showHierarchicalViewAction.setChecked(false);
        switch (((DataCompPage)this.activePage).getDataProvider().getActiveView()) {
            case FLAT: {
                this.showFlatViewAction.setChecked(true);
                break;
            }
            case HIERARCHY: {
                this.showHierarchicalViewAction.setChecked(true);
                break;
            }
        }
        ((DataCompPage)this.activePage).getTreeViewer().refresh();
    }
}

