/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.utils;

import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import graphmodel.GraphModel;
import graphmodel.ModelElement;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.data.data.Data;
import info.scce.dime.gUIPlugin.Plugins;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.process.process.Process;
import info.scce.dime.siblibrary.SIBLibrary;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.ui.IEditorPart;

public class GraphModelUtils {
    private ResourceExtension resourceHelper = new ResourceExtension();
    private String[] fileExtensions;

    public GraphModelUtils(String[] fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public List<IResource> loadRecursive(IResource res) {
        ArrayList<IResource> contents = new ArrayList<IResource>();
        if (this.isModelResource(res)) {
            contents.add(res);
        }
        if (res instanceof IFolder) {
            try {
                contents.add(res);
                IResource[] iResourceArray = ((Container)res).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource iResource = iResourceArray[n2];
                    contents.addAll(this.loadRecursive(iResource));
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    public boolean isModelResource(IResource iResource) {
        if (iResource instanceof IFile && Arrays.asList(this.fileExtensions).isEmpty()) {
            return true;
        }
        return Arrays.asList(this.fileExtensions).contains(iResource.getFileExtension());
    }

    public boolean hasModelResource(IContainer container) {
        List<IResource> resList = this.loadRecursive((IResource)container);
        for (IResource res : resList) {
            if (!this.isModelResource(res)) continue;
            return true;
        }
        return false;
    }

    public EObject loadModel(IResource res) {
        File file = new File(res.getLocation().toOSString());
        ResourceSetImpl resSet = new ResourceSetImpl();
        URI uri = URI.createFileURI((String)file.getAbsolutePath());
        if (uri == null) {
            return null;
        }
        GraphModel model = ReferenceRegistry.getInstance().getGraphModelFromURI(uri);
        if (model != null) {
            return model;
        }
        Resource resource = resSet.getResource(uri, true);
        model = this.resourceHelper.getGraphModel(resource);
        if (model != null) {
            return model;
        }
        model = this.resourceHelper.getContent(resource, SIBLibrary.class);
        if (model != null) {
            return model;
        }
        model = this.resourceHelper.getContent(resource, Plugins.class);
        if (model != null) {
            return model;
        }
        System.out.println("Model " + file.getName() + " not found");
        return null;
    }

    public void collectReferences(EObject eObj, HashMap<String, ArrayList<EObject>> map) {
        if (!(eObj instanceof GraphModel)) {
            return;
        }
        GraphModel gModel = (GraphModel)eObj;
        TreeIterator it = gModel.eAllContents();
        while (it.hasNext()) {
            Object val;
            ModelElement me;
            EStructuralFeature libCompFeature;
            Object obj = it.next();
            if (!(obj instanceof ModelElement) || (libCompFeature = (me = (ModelElement)obj).eClass().getEStructuralFeature("libraryComponentUID")) == null || (val = me.eGet(libCompFeature)) == null || !(val instanceof String)) continue;
            String refId = (String)val;
            if (map.get(refId) == null) {
                map.put(refId, new ArrayList());
            }
            map.get(refId).add((EObject)me);
        }
    }

    public GUI getGuiWrapperFromEditor(IEditorPart editorPart) {
        Resource res = null;
        Diagram diagram = null;
        GUI model = null;
        if (editorPart instanceof DiagramEditor) {
            DiagramEditor deditor = (DiagramEditor)editorPart;
            TransactionalEditingDomain ed = deditor.getEditingDomain();
            ResourceSet rs = ed.getResourceSet();
            res = (Resource)rs.getResources().get(0);
        }
        for (EObject obj : res.getContents()) {
            if (obj instanceof Diagram) {
                diagram = (Diagram)obj;
            }
            if (!(obj instanceof GUI)) continue;
            model = (GUI)obj;
        }
        if (model != null && diagram != null) {
            try {
                return model;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public DAD getDADWrapperFromEditor(IEditorPart editorPart) {
        Resource res = null;
        Diagram diagram = null;
        DAD model = null;
        if (editorPart instanceof DiagramEditor) {
            DiagramEditor deditor = (DiagramEditor)editorPart;
            TransactionalEditingDomain ed = deditor.getEditingDomain();
            ResourceSet rs = ed.getResourceSet();
            res = (Resource)rs.getResources().get(0);
        }
        for (EObject obj : res.getContents()) {
            if (obj instanceof Diagram) {
                diagram = (Diagram)obj;
            }
            if (!(obj instanceof DAD)) continue;
            model = (DAD)obj;
        }
        if (model != null && diagram != null) {
            try {
                return model;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Process getProcessWrapperFromEditor(IEditorPart editorPart) {
        Resource res = null;
        Diagram diagram = null;
        Process model = null;
        if (editorPart instanceof DiagramEditor) {
            DiagramEditor deditor = (DiagramEditor)editorPart;
            TransactionalEditingDomain ed = deditor.getEditingDomain();
            ResourceSet rs = ed.getResourceSet();
            res = (Resource)rs.getResources().get(0);
        }
        for (EObject obj : res.getContents()) {
            if (obj instanceof Diagram) {
                diagram = (Diagram)obj;
            }
            if (!(obj instanceof Process)) continue;
            model = (Process)obj;
        }
        if (model != null && diagram != null) {
            try {
                return model;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Data getDataWrapperFromEditor(IEditorPart editorPart) {
        Resource res = null;
        Diagram diagram = null;
        Data model = null;
        if (editorPart instanceof DiagramEditor) {
            DiagramEditor deditor = (DiagramEditor)editorPart;
            TransactionalEditingDomain ed = deditor.getEditingDomain();
            ResourceSet rs = ed.getResourceSet();
            res = (Resource)rs.getResources().get(0);
        }
        for (EObject obj : res.getContents()) {
            if (obj instanceof Diagram) {
                diagram = (Diagram)obj;
            }
            if (!(obj instanceof Data)) continue;
            model = (Data)obj;
        }
        if (model != null && diagram != null) {
            try {
                return model;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void highlightElement(Data wrapper, String id) {
        Data model = wrapper;
        TreeIterator it = model.eAllContents();
        while (it.hasNext()) {
            ModelElement thisME = (ModelElement)it.next();
            if (!thisME.getId().equals(id)) continue;
            thisME.highlight();
        }
    }

    public void highlightElement(DAD wrapper, String id) {
        DAD model = wrapper;
        TreeIterator it = model.eAllContents();
        while (it.hasNext()) {
            ModelElement thisME = (ModelElement)it.next();
            if (!thisME.getId().equals(id)) continue;
            thisME.highlight();
        }
    }

    public void highlightElement(Process wrapper, String id) {
        Process model = wrapper;
        TreeIterator it = model.eAllContents();
        while (it.hasNext()) {
            ModelElement thisME = (ModelElement)it.next();
            if (!thisME.getId().equals(id)) continue;
            thisME.highlight();
        }
    }

    public void highlightElement(GUI wrapper, String id) {
        GUI model = wrapper;
        TreeIterator it = model.eAllContents();
        while (it.hasNext()) {
            ModelElement thisME = (ModelElement)it.next();
            if (!thisME.getId().equals(id)) continue;
            thisME.highlight();
        }
    }
}

