/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.utils;

import graphmodel.Edge;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.BidirectionalAttribute;
import info.scce.dime.data.data.ComplexAttribute;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.Inheritance;
import info.scce.dime.data.data.PrimitiveAttribute;
import info.scce.dime.data.data.ReferencedBidirectionalAttribute;
import info.scce.dime.data.data.ReferencedComplexAttribute;
import info.scce.dime.data.data.ReferencedPrimitiveAttribute;
import info.scce.dime.data.data.ReferencedType;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.data.UserAttribute;
import info.scce.dime.libcompviews.utils.GraphModelUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DataUtils
extends GraphModelUtils {
    public DataUtils(String[] fileExtensions) {
        super(fileExtensions);
    }

    public List<Type> getRootTypes(Data model) {
        ArrayList<Type> rootTypes = new ArrayList<Type>();
        if (model != null) {
            for (Type type : model.getTypes()) {
                boolean hasInheritance = false;
                for (Edge edge : type.getOutgoing()) {
                    if (!(edge instanceof Inheritance)) continue;
                    hasInheritance = true;
                }
                if (hasInheritance) continue;
                rootTypes.add(type);
            }
        }
        return rootTypes;
    }

    public List<Type> getSubTypes(Type type) {
        ArrayList<Type> subTypes = new ArrayList<Type>();
        if (type != null) {
            for (Edge edge : type.getIncoming()) {
                if (!(edge instanceof Inheritance)) continue;
                Inheritance inheritance = (Inheritance)edge;
                subTypes.add((Type)inheritance.getSourceElement());
            }
        }
        return subTypes;
    }

    public Type getSuperType(Type type) {
        if (type != null) {
            for (Edge edge : type.getOutgoing()) {
                if (!(edge instanceof Inheritance)) continue;
                Inheritance inheritance = (Inheritance)edge;
                return inheritance.getTargetElement();
            }
        }
        return null;
    }

    public Type getOriginType(Type type) {
        if (type instanceof ReferencedType) {
            return ((ReferencedType)type).getReferencedType();
        }
        return type;
    }

    public Attribute getOriginAttribute(Attribute attr) {
        if (attr instanceof ReferencedComplexAttribute || attr instanceof ReferencedPrimitiveAttribute || attr instanceof ReferencedBidirectionalAttribute) {
            Type type = this.getOriginType(this.getTypeForAttribute(attr));
            while (type != null) {
                Attribute refAttribute = this.getAttributeByName(type, attr.getName());
                if (refAttribute == null) {
                    type = this.getOriginType(this.getSuperType(type));
                    continue;
                }
                return refAttribute;
            }
        }
        return attr;
    }

    private Attribute getAttributeByName(Type type, String name) {
        for (Attribute attr : type.getAttributes()) {
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    public Type getTypeForAttribute(Attribute attr) {
        Type mec = attr.getContainer();
        if (mec instanceof Type) {
            return mec;
        }
        return null;
    }

    public List<Attribute> getAllAttributes(Type type) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        ArrayList<Attribute> possibleAttr = new ArrayList<Attribute>();
        ArrayList<Attribute> overwrittenAttr = new ArrayList<Attribute>();
        Type actType = type;
        HashSet<Type> visited = new HashSet<Type>();
        while (actType != null) {
            for (Attribute attribute : actType.getAttributes()) {
                ComplexAttribute superCa = null;
                if (attribute instanceof ComplexAttribute) {
                    superCa = ((ComplexAttribute)attribute).getSuperAttr();
                }
                if (attribute instanceof PrimitiveAttribute) {
                    superCa = ((PrimitiveAttribute)attribute).getSuperAttr();
                }
                if (attribute instanceof BidirectionalAttribute) {
                    superCa = ((BidirectionalAttribute)attribute).getSuperAttr();
                }
                if (superCa != null && superCa != attribute) {
                    overwrittenAttr.add(this.getOriginAttribute((Attribute)superCa));
                }
                possibleAttr.add(attribute);
            }
            Type superType = this.getOriginType(this.getSuperType(actType));
            Object object = actType = visited.add(superType) ? superType : null;
        }
        for (Attribute pAttr : possibleAttr) {
            boolean found = false;
            for (Attribute oAttr : overwrittenAttr) {
                if (!pAttr.getId().equals(oAttr.getId())) continue;
                found = true;
            }
            if (found) continue;
            attributes.add(pAttr);
        }
        return attributes;
    }

    public AssociationType getAssociationTypeFromAttribute(ComplexAttribute attr) {
        if (attr instanceof UserAttribute) {
            return AssociationType.USER;
        }
        if (attr instanceof BidirectionalAttribute) {
            return AssociationType.BIDIRECTIONAL;
        }
        return AssociationType.UNIDIRECTIONAL;
    }

    public static enum AssociationType {
        USER,
        BIDIRECTIONAL,
        UNIDIRECTIONAL;

    }
}

