/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.provider;

import graphmodel.GraphModel;
import info.scce.dime.gUIPlugin.Function;
import info.scce.dime.gUIPlugin.Plugin;
import info.scce.dime.gUIPlugin.Plugins;
import info.scce.dime.libcompviews.nodes.Category;
import info.scce.dime.libcompviews.nodes.ContainerTreeNode;
import info.scce.dime.libcompviews.nodes.GraphModelTreeNode;
import info.scce.dime.libcompviews.nodes.TreeNode;
import info.scce.dime.libcompviews.provider.LibCompTreeProvider;
import info.scce.dime.libcompviews.utils.GraphModelUtils;
import info.scce.dime.siblibrary.SIB;
import info.scce.dime.siblibrary.SIBLibrary;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;

public class UICompTreeProvider
extends LibCompTreeProvider {
    private String[] fileExtensions = new String[]{"gui", "gp"};
    private ContainerTreeNode categoryRoot;
    private ContainerTreeNode folderstructRoot;
    private ViewType activeView = ViewType.CATEGORY;

    public UICompTreeProvider() {
        this.utils = new GraphModelUtils(this.fileExtensions);
    }

    @Override
    public TreeNode getTree() {
        switch (this.activeView) {
            case CATEGORY: {
                return this.categoryRoot;
            }
        }
        return this.folderstructRoot;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public ViewType getActiveView() {
        return this.activeView;
    }

    public void setActiveView(ViewType activeView) {
        this.activeView = activeView;
    }

    @Override
    public void loadData(IProject project) {
        long timeStart = System.currentTimeMillis();
        this.modelToResource = new HashMap();
        this.resourceToModel = new HashMap();
        ArrayList<IResource> contents = new ArrayList<IResource>();
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                contents.addAll(this.utils.loadRecursive(res));
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.modelReferencedIn = new HashMap();
        for (IResource iResource : contents) {
            if (!this.utils.isModelResource(iResource)) continue;
            EObject eObject = this.utils.loadModel(iResource);
            this.modelToResource.put(eObject, iResource);
            this.resourceToModel.put(iResource, eObject);
            if (!this.isShowReferencedInInfo()) continue;
            this.utils.collectReferences(eObject, this.modelReferencedIn);
        }
        long timeLoad = System.currentTimeMillis();
        switch (this.activeView) {
            case CATEGORY: {
                this.categoryRoot = new ContainerTreeNode(null, "root");
                LibCompTreeProvider.ModelType[] modelTypeArray = LibCompTreeProvider.ModelType.values();
                int n = modelTypeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    LibCompTreeProvider.ModelType modelType = modelTypeArray[n3];
                    this.buildCategoryTree((Object)modelType, this.categoryRoot);
                    ++n3;
                }
                break;
            }
            default: {
                this.folderstructRoot = new ContainerTreeNode(null, "root");
                for (Object e : this.getDirectChilds((IContainer)project)) {
                    this.buildFolderTree(e, this.folderstructRoot);
                }
            }
        }
        long l = System.currentTimeMillis();
        System.out.println("UICompView - load Models: " + (timeLoad - timeStart) + " ms / create Tree: " + (l - timeLoad) + " ms");
    }

    private TreeNode buildFolderTree(Object obj, TreeNode parentNode) {
        Plugins gp;
        TreeNode node = new ContainerTreeNode(null, "dummy");
        if (obj instanceof IFolder) {
            node = new ContainerTreeNode(obj, ((IFolder)obj).getName());
            for (Object child : this.getDirectChilds((IContainer)obj)) {
                this.buildFolderTree(child, node);
            }
        }
        if (obj instanceof GraphModel) {
            node = new GraphModelTreeNode(obj, (IResource)this.modelToResource.get(obj));
            if (this.isShowReferencedInInfo()) {
                this.buildReferencedInSubTree(obj, node);
            }
        }
        if (obj instanceof SIBLibrary) {
            node = new GraphModelTreeNode(obj, (IResource)this.modelToResource.get(obj));
            SIBLibrary sl = (SIBLibrary)obj;
            if (sl.getSibs().size() <= 0) {
                return node;
            }
            for (SIB sib : sl.getSibs()) {
                this.buildFolderTree(sib, node);
            }
        }
        if (obj instanceof SIB) {
            node = new ContainerTreeNode(obj, ((SIB)obj).getName());
        }
        if (obj instanceof Plugins) {
            gp = (Plugins)obj;
            node = new GraphModelTreeNode(obj, (IResource)this.modelToResource.get(obj));
            for (SIB sib : gp.getPlugins()) {
                this.buildFolderTree(sib, node);
            }
        }
        if (obj instanceof Plugin) {
            gp = (Plugin)obj;
            node = new ContainerTreeNode(obj, gp.getPath());
            for (SIB sib : gp.getFunctions()) {
                this.buildFolderTree(sib, node);
            }
        }
        if (obj instanceof Function) {
            node = new ContainerTreeNode(obj, ((Function)obj).getFunctionName());
        }
        if (parentNode.find(node.getId()) == null) {
            parentNode.getChildren().add(node);
            node.setParent(parentNode);
        }
        return node;
    }

    private TreeNode buildCategoryTree(Object obj, TreeNode parentNode) {
        Plugins gp;
        TreeNode node = new ContainerTreeNode(null, "dummy");
        if (obj instanceof LibCompTreeProvider.ModelType) {
            LibCompTreeProvider.ModelType type = (LibCompTreeProvider.ModelType)((Object)obj);
            node = new ContainerTreeNode(new Category(this.getNameForModelType(type), (Object)type), this.getNameForModelType(type));
            ArrayList<EObject> list = new ArrayList<EObject>();
            for (EObject model : this.modelToResource.keySet()) {
                if (!type.equals((Object)this.mapEObjectToType(model))) continue;
                list.add(model);
            }
            if (list.size() <= 0) {
                return node;
            }
            for (EObject eObject2 : list) {
                this.buildCategoryTree(eObject2, node);
            }
        }
        if (obj instanceof GraphModel) {
            node = new GraphModelTreeNode(obj, (IResource)this.modelToResource.get(obj));
            if (this.isShowReferencedInInfo()) {
                this.buildReferencedInSubTree(obj, node);
            }
        }
        if (obj instanceof SIBLibrary) {
            node = new GraphModelTreeNode(obj, (IResource)this.modelToResource.get(obj));
            SIBLibrary sl = (SIBLibrary)obj;
            if (sl.getSibs().size() <= 0) {
                return node;
            }
            for (SIB sib : sl.getSibs()) {
                this.buildCategoryTree(sib, node);
            }
        }
        if (obj instanceof SIB) {
            node = new ContainerTreeNode(obj, ((SIB)obj).getName());
        }
        if (obj instanceof Plugins) {
            gp = (Plugins)obj;
            node = new GraphModelTreeNode(obj, (IResource)this.modelToResource.get(obj));
            for (SIB sib : gp.getPlugins()) {
                this.buildCategoryTree(sib, node);
            }
        }
        if (obj instanceof Plugin) {
            gp = (Plugin)obj;
            node = new ContainerTreeNode(obj, gp.getPath());
            for (SIB sib : gp.getFunctions()) {
                this.buildCategoryTree(sib, node);
            }
        }
        if (obj instanceof Function) {
            node = new ContainerTreeNode(obj, ((Function)obj).getFunctionName());
        }
        if (parentNode.find(node.getId()) == null) {
            parentNode.getChildren().add(node);
            node.setParent(parentNode);
        }
        return node;
    }

    public static enum ViewType {
        CATEGORY,
        FOLDERSTRUCT;

    }
}

