/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.provider;

import graphmodel.GraphModel;
import graphmodel.ModelElement;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.dad.dad.FindLoginUserComponent;
import info.scce.dime.dad.dad.LoginComponent;
import info.scce.dime.dad.dad.ProcessComponent;
import info.scce.dime.gui.gui.GuardSIB;
import info.scce.dime.gui.gui.SecuritySIB;
import info.scce.dime.libcompviews.nodes.ContainerTreeNode;
import info.scce.dime.libcompviews.nodes.GraphModelTreeNode;
import info.scce.dime.libcompviews.nodes.PrimeTreeNode;
import info.scce.dime.libcompviews.nodes.TreeNode;
import info.scce.dime.libcompviews.provider.LibCompTreeProvider;
import info.scce.dime.libcompviews.utils.GraphModelUtils;
import info.scce.dime.process.process.EntryPointProcessSIB;
import info.scce.dime.process.process.GUISIB;
import info.scce.dime.process.process.GuardProcessSIB;
import info.scce.dime.process.process.GuardedProcessSIB;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.SearchSIB;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ModelHierarchyTreeProvider
extends LibCompTreeProvider {
    private String[] fileExtensions = new String[]{"dad", "process", "gui"};
    private ContainerTreeNode root;
    private ArrayList<String> visitedModelIds = new ArrayList();

    public ModelHierarchyTreeProvider() {
        this.utils = new GraphModelUtils(this.fileExtensions);
    }

    @Override
    public TreeNode getTree() {
        return this.root;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    @Override
    public void loadData(IProject project) {
        long timeStart = System.currentTimeMillis();
        this.modelToResource = new HashMap();
        this.resourceToModel = new HashMap();
        ArrayList<IResource> contents = new ArrayList<IResource>();
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                contents.addAll(this.utils.loadRecursive(res));
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.modelReferencedIn = new HashMap();
        for (IResource iResource : contents) {
            if (!this.utils.isModelResource(iResource)) continue;
            EObject model = this.utils.loadModel(iResource);
            this.modelToResource.put(model, iResource);
            this.resourceToModel.put(iResource, model);
            if (!this.isShowReferencedInInfo()) continue;
            this.utils.collectReferences(model, this.modelReferencedIn);
        }
        long timeLoad = System.currentTimeMillis();
        this.root = new ContainerTreeNode(null, "root");
        this.visitedModelIds.clear();
        for (EObject model : this.modelToResource.keySet()) {
            if (!(model instanceof DAD)) continue;
            this.buildHierarchyForDadTree((DAD)model, this.root);
        }
        long timeBuild = System.currentTimeMillis();
        System.out.println("ModelHierarchyView - load Models: " + (timeLoad - timeStart) + " ms / create Tree: " + (timeBuild - timeLoad) + " ms");
    }

    private TreeNode getNode(Object obj) {
        LoginComponent me;
        GraphModelTreeNode node = null;
        if (obj instanceof DAD) {
            node = new GraphModelTreeNode(obj, (IResource)this.modelToResource.get(obj));
        }
        if (obj instanceof LoginComponent) {
            me = (LoginComponent)obj;
            node = new PrimeTreeNode((ModelElement)me, (GraphModel)me.getModel(), (IResource)this.modelToResource.get(me.getRootElement()));
        }
        if (obj instanceof FindLoginUserComponent) {
            me = (FindLoginUserComponent)obj;
            node = new PrimeTreeNode((ModelElement)me, (GraphModel)me.getModel(), (IResource)this.modelToResource.get(me.getRootElement()));
        }
        if (obj instanceof ProcessComponent) {
            me = (ProcessComponent)obj;
            node = new PrimeTreeNode((ModelElement)me, (GraphModel)me.getModel(), (IResource)this.modelToResource.get(me.getRootElement()));
        }
        if (obj instanceof ProcessSIB) {
            me = (ProcessSIB)obj;
            node = new PrimeTreeNode((ModelElement)me, (GraphModel)me.getProMod(), (IResource)this.modelToResource.get(me.getRootElement()));
        }
        if (obj instanceof EntryPointProcessSIB) {
            me = (EntryPointProcessSIB)obj;
            node = new PrimeTreeNode((ModelElement)me, (GraphModel)me.getProMod(), (IResource)this.modelToResource.get(me.getRootElement()));
        }
        if (obj instanceof GUISIB) {
            me = (GUISIB)obj;
            node = new PrimeTreeNode((ModelElement)me, (GraphModel)me.getGui(), (IResource)this.modelToResource.get(me.getRootElement()));
        }
        if (obj instanceof GuardProcessSIB) {
            me = (GuardProcessSIB)obj;
            node = new PrimeTreeNode((ModelElement)me, (GraphModel)me.getSecurityProcess(), (IResource)this.modelToResource.get(me.getRootElement()));
        }
        if (obj instanceof GuardedProcessSIB) {
            me = (GuardedProcessSIB)obj;
            node = new PrimeTreeNode((ModelElement)me, (GraphModel)me.getProMod(), (IResource)this.modelToResource.get(me.getRootElement()));
        }
        if (obj instanceof SearchSIB) {
            me = (SearchSIB)obj;
            node = new PrimeTreeNode((ModelElement)me, (GraphModel)me.getSearch(), (IResource)this.modelToResource.get(me.getRootElement()));
        }
        if (obj instanceof info.scce.dime.gui.gui.GUISIB) {
            me = (info.scce.dime.gui.gui.GUISIB)obj;
            node = new PrimeTreeNode((ModelElement)me, (GraphModel)me.getGui(), (IResource)this.modelToResource.get(me.getRootElement()));
        }
        if (obj instanceof info.scce.dime.gui.gui.ProcessSIB) {
            me = (info.scce.dime.gui.gui.ProcessSIB)obj;
            node = new PrimeTreeNode((ModelElement)me, (GraphModel)me.getProMod(), (IResource)this.modelToResource.get(me.getRootElement()));
        }
        if (obj instanceof SecuritySIB) {
            me = (SecuritySIB)obj;
            node = new PrimeTreeNode((ModelElement)me, (GraphModel)me.getProMod(), (IResource)this.modelToResource.get(me.getRootElement()));
        }
        if (obj instanceof GuardSIB) {
            me = (GuardSIB)obj;
            node = new PrimeTreeNode((ModelElement)me, (GraphModel)me.getProcess(), (IResource)this.modelToResource.get(me.getRootElement()));
        }
        return node;
    }

    private void addNodeToTree(TreeNode parent, TreeNode node) {
        if (node == null || parent == null) {
            return;
        }
        if (parent.find(node.getId()) == null) {
            parent.getChildren().add(node);
            node.setParent(parent);
        }
    }

    private void buildHierarchyForDadTree(Object obj, TreeNode parentNode) {
        if (obj instanceof GraphModel) {
            GraphModel gModel = (GraphModel)obj;
            if (this.visitedModelIds.contains(gModel.getId())) {
                return;
            }
            this.visitedModelIds.add(gModel.getId());
            TreeNode modelNode = this.getNode(gModel);
            this.addNodeToTree(parentNode, modelNode);
            if (modelNode != null) {
                parentNode = modelNode;
            }
            TreeIterator it = gModel.getInternalElement_().eAllContents();
            while (it.hasNext()) {
                ModelElement me;
                EStructuralFeature libCompFeature;
                Object objIt = it.next();
                if (!(objIt instanceof ModelElement) || (libCompFeature = (me = (ModelElement)objIt).getInternalElement_().eClass().getEStructuralFeature("libraryComponentUID")) == null) continue;
                this.buildHierarchyForDadTree(me, parentNode);
            }
        }
        if (obj instanceof ModelElement) {
            TreeNode elementNode = this.getNode(obj);
            this.addNodeToTree(parentNode, elementNode);
            if (elementNode instanceof PrimeTreeNode) {
                this.buildHierarchyForDadTree(((PrimeTreeNode)elementNode).getModel(), elementNode);
            }
        }
    }
}

