/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.provider;

import graphmodel.GraphModel;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.gUIPlugin.Plugins;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.libcompviews.nodes.ContainerTreeNode;
import info.scce.dime.libcompviews.nodes.TreeNode;
import info.scce.dime.libcompviews.provider.TreeProvider;
import info.scce.dime.libcompviews.utils.GraphModelUtils;
import info.scce.dime.process.process.Process;
import info.scce.dime.search.search.Search;
import info.scce.dime.siblibrary.SIBLibrary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;

public abstract class LibCompTreeProvider
extends TreeProvider {
    protected GraphModelUtils utils;
    protected HashMap<ModelType, List<ModelType>> allowedModels = new HashMap();
    protected HashMap<EObject, IResource> modelToResource = new HashMap();
    protected HashMap<IResource, EObject> resourceToModel = new HashMap();
    protected HashMap<String, ArrayList<EObject>> modelReferencedIn = new HashMap();
    protected boolean showReferencedInInfo = false;

    public LibCompTreeProvider() {
        this.initAllowedModels();
    }

    public GraphModelUtils getUtils() {
        return this.utils;
    }

    public HashMap<EObject, IResource> getModelToResource() {
        return this.modelToResource;
    }

    public EObject getEObjectForResource(IResource res) {
        return this.resourceToModel.get(res);
    }

    public HashMap<ModelType, List<ModelType>> getAllowedModels() {
        return this.allowedModels;
    }

    public boolean isShowReferencedInInfo() {
        return this.showReferencedInInfo;
    }

    public void setShowReferencedInInfo(boolean showReferencedInInfo) {
        this.showReferencedInInfo = showReferencedInInfo;
    }

    protected void initAllowedModels() {
        ArrayList<ModelType> guiModels = new ArrayList<ModelType>();
        guiModels.add(ModelType.GUI);
        guiModels.add(ModelType.GUIPLUGIN);
        this.allowedModels.put(ModelType.GUI, guiModels);
        ArrayList searchModels = new ArrayList();
        this.allowedModels.put(ModelType.SEARCH, searchModels);
        ArrayList siblibModels = new ArrayList();
        this.allowedModels.put(ModelType.SIBLIBRARY, siblibModels);
        ArrayList guiPluginModels = new ArrayList();
        this.allowedModels.put(ModelType.GUIPLUGIN, guiPluginModels);
        ArrayList<ModelType> processModels = new ArrayList<ModelType>();
        processModels.add(ModelType.SEARCH);
        processModels.add(ModelType.GUI);
        processModels.add(ModelType.SIBLIBRARY);
        processModels.add(ModelType.PROCESS);
        processModels.add(ModelType.PROCESS_LONGRUNNING);
        processModels.add(ModelType.PROCESS_BASIC);
        processModels.add(ModelType.PROCESS_SECURITY);
        this.allowedModels.put(ModelType.PROCESS, processModels);
        ArrayList<ModelType> processBasicModels = new ArrayList<ModelType>();
        processBasicModels.add(ModelType.SEARCH);
        processBasicModels.add(ModelType.SIBLIBRARY);
        processBasicModels.add(ModelType.PROCESS_LONGRUNNING);
        processBasicModels.add(ModelType.PROCESS_BASIC);
        processBasicModels.add(ModelType.PROCESS_SECURITY);
        this.allowedModels.put(ModelType.PROCESS_BASIC, processBasicModels);
        ArrayList<ModelType> processLongrunningModels = new ArrayList<ModelType>();
        processLongrunningModels.add(ModelType.SEARCH);
        processLongrunningModels.add(ModelType.SIBLIBRARY);
        processLongrunningModels.add(ModelType.PROCESS_LONGRUNNING);
        processLongrunningModels.add(ModelType.PROCESS_BASIC);
        processLongrunningModels.add(ModelType.PROCESS_SECURITY);
        this.allowedModels.put(ModelType.PROCESS_LONGRUNNING, processLongrunningModels);
        ArrayList<ModelType> processSecurityModels = new ArrayList<ModelType>();
        processSecurityModels.add(ModelType.SEARCH);
        processSecurityModels.add(ModelType.SIBLIBRARY);
        processSecurityModels.add(ModelType.PROCESS_LONGRUNNING);
        processSecurityModels.add(ModelType.PROCESS_BASIC);
        processSecurityModels.add(ModelType.PROCESS_SECURITY);
        this.allowedModels.put(ModelType.PROCESS_SECURITY, processSecurityModels);
    }

    public ModelType mapEObjectToType(EObject obj) {
        if (obj instanceof DAD) {
            return ModelType.DAD;
        }
        if (obj instanceof GUI) {
            return ModelType.GUI;
        }
        if (obj instanceof Search) {
            return ModelType.SEARCH;
        }
        if (obj instanceof SIBLibrary) {
            return ModelType.SIBLIBRARY;
        }
        if (obj instanceof Plugins) {
            return ModelType.GUIPLUGIN;
        }
        if (obj instanceof Process) {
            Process process = (Process)obj;
            switch (process.getProcessType()) {
                case BASIC: {
                    return ModelType.PROCESS_BASIC;
                }
                case LONG_RUNNING: {
                    return ModelType.PROCESS_LONGRUNNING;
                }
                case SECURITY: {
                    return ModelType.PROCESS_SECURITY;
                }
                case NATIVE_FRONTEND_SIB_LIBRARY: {
                    return ModelType.NATIVE_FRONTEND_LIBRARY;
                }
            }
            return ModelType.PROCESS;
        }
        return null;
    }

    protected String getNameForModelType(ModelType type) {
        switch (type) {
            case DAD: {
                return "Dad";
            }
            case GUI: {
                return "Gui";
            }
            case SEARCH: {
                return "Search";
            }
            case SIBLIBRARY: {
                return "Native";
            }
            case NATIVE_FRONTEND_LIBRARY: {
                return "Native Frontend";
            }
            case PROCESS: {
                return "Processes";
            }
            case GUIPLUGIN: {
                return "GUI Plugins";
            }
            case PROCESS_BASIC: {
                return "Basic";
            }
            case PROCESS_LONGRUNNING: {
                return "LongRunning";
            }
            case PROCESS_SECURITY: {
                return "Security";
            }
        }
        return "unknown";
    }

    protected List<Object> getDirectChilds(IContainer container) {
        ArrayList<Object> contents = new ArrayList<Object>();
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (this.utils.isModelResource(res)) {
                    for (IResource modelRes : this.resourceToModel.keySet()) {
                        if (!res.equals((Object)modelRes)) continue;
                        contents.add(this.resourceToModel.get(modelRes));
                    }
                }
                if (res instanceof IFolder && this.utils.hasModelResource((IContainer)res)) {
                    contents.add(res);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return contents;
    }

    protected void buildReferencedInSubTree(Object obj, TreeNode parentNode) {
        if (!(obj instanceof GraphModel)) {
            return;
        }
        GraphModel gModel = (GraphModel)obj;
        if (this.modelReferencedIn.get(gModel.getId()) == null) {
            return;
        }
        for (EObject eObj : this.modelReferencedIn.get(gModel.getId())) {
            ContainerTreeNode node = new ContainerTreeNode(eObj, eObj.toString());
            if (parentNode.find(((TreeNode)node).getId()) != null) continue;
            parentNode.getChildren().add(node);
            node.setParent(parentNode);
        }
    }

    public static enum ModelType {
        DAD,
        GUI,
        SEARCH,
        SIBLIBRARY,
        GUIPLUGIN,
        PROCESS,
        PROCESS_BASIC,
        PROCESS_LONGRUNNING,
        PROCESS_SECURITY,
        NATIVE_FRONTEND_LIBRARY;

    }
}

