/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.provider;

import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.ReferencedComplexAttribute;
import info.scce.dime.data.data.ReferencedExtensionAttribute;
import info.scce.dime.data.data.ReferencedPrimitiveAttribute;
import info.scce.dime.data.data.ReferencedType;
import info.scce.dime.data.data.ReferencedUserAttribute;
import info.scce.dime.data.data.Type;
import info.scce.dime.libcompviews.nodes.ContainerTreeNode;
import info.scce.dime.libcompviews.nodes.GraphModelTreeNode;
import info.scce.dime.libcompviews.nodes.ModelElementTreeNode;
import info.scce.dime.libcompviews.nodes.TreeNode;
import info.scce.dime.libcompviews.provider.TreeProvider;
import info.scce.dime.libcompviews.utils.DataUtils;
import info.scce.dime.siblibrary.SIBLibrary;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;

public class DataCompTreeProvider
extends TreeProvider {
    private String[] fileExtensions = new String[]{"data", "sibs"};
    private HashMap<EObject, IResource> modelToResource = null;
    private ContainerTreeNode flatRoot;
    private ContainerTreeNode hierarchyRoot;
    private ViewType activeView = ViewType.FLAT;
    private DataUtils utils = new DataUtils(this.fileExtensions);

    @Override
    public TreeNode getTree() {
        switch (this.activeView) {
            case HIERARCHY: {
                return this.hierarchyRoot;
            }
        }
        return this.flatRoot;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public DataUtils getUtils() {
        return this.utils;
    }

    public HashMap<EObject, IResource> getModelToResource() {
        return this.modelToResource;
    }

    public ViewType getActiveView() {
        return this.activeView;
    }

    public void setActiveView(ViewType activeView) {
        this.activeView = activeView;
    }

    @Override
    public void loadData(IProject project) {
        long timeStart = System.currentTimeMillis();
        this.modelToResource = new HashMap();
        if (project == null) {
            return;
        }
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                this.loadContentModels(iResource);
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        long timeLoad = System.currentTimeMillis();
        switch (this.activeView) {
            case HIERARCHY: {
                this.hierarchyRoot = new ContainerTreeNode(null, "root");
                for (EObject model : this.modelToResource.keySet()) {
                    this.buildHierarchyTree(model, this.hierarchyRoot);
                }
                break;
            }
            default: {
                this.flatRoot = new ContainerTreeNode(null, "root");
                for (EObject model : this.modelToResource.keySet()) {
                    this.buildFlatTree(model, this.flatRoot);
                }
            }
        }
        long timeBuild = System.currentTimeMillis();
        System.out.println("DataCompView - load Models: " + (timeLoad - timeStart) + " ms / create Tree: " + (timeBuild - timeLoad) + " ms");
    }

    private void loadContentModels(IResource iResource) {
        if (iResource instanceof File && Arrays.asList(this.fileExtensions).contains(iResource.getFileExtension())) {
            EObject model = this.utils.loadModel(iResource);
            this.modelToResource.put(model, iResource);
        }
        if (iResource instanceof Folder) {
            try {
                IResource[] iResourceArray = ((Folder)iResource).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource subRes = iResourceArray[n2];
                    this.loadContentModels(subRes);
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private TreeNode buildFlatTree(Object obj, TreeNode parentNode) {
        TreeNode treeNode;
        TreeNode node = new ContainerTreeNode(null, "dummy");
        if (obj instanceof Data) {
            node = new GraphModelTreeNode(obj, this.modelToResource.get(obj));
            if (((Data)obj).getTypes().size() <= 0) {
                return node;
            }
            for (Type type : ((Data)obj).getTypes()) {
                this.buildFlatTree(type, node);
            }
        }
        if (obj instanceof Type) {
            node = new ModelElementTreeNode(obj);
            if (obj instanceof ReferencedType) {
                return node;
            }
            for (Attribute attribute : this.utils.getAllAttributes((Type)obj)) {
                this.buildFlatTree(attribute, node);
            }
        }
        if (obj instanceof Attribute) {
            node = new ModelElementTreeNode(obj);
            if (obj instanceof ReferencedPrimitiveAttribute) {
                ReferencedPrimitiveAttribute referencedPrimitiveAttribute = (ReferencedPrimitiveAttribute)obj;
                node.setData(referencedPrimitiveAttribute.getReferencedAttribute());
            }
            if (obj instanceof ReferencedExtensionAttribute) {
                ReferencedExtensionAttribute referencedExtensionAttribute = (ReferencedExtensionAttribute)obj;
                node.setData(referencedExtensionAttribute.getReferencedAttribute());
            }
            if (obj instanceof ReferencedUserAttribute) {
                ReferencedUserAttribute referencedUserAttribute = (ReferencedUserAttribute)obj;
                node.setData(referencedUserAttribute.getReferencedAttribute());
            }
            if (obj instanceof ReferencedComplexAttribute) {
                ReferencedComplexAttribute referencedComplexAttribute = (ReferencedComplexAttribute)obj;
                node.setData(referencedComplexAttribute.getReferencedAttribute());
            }
        }
        if (obj instanceof SIBLibrary) {
            node = new GraphModelTreeNode(obj, this.modelToResource.get(obj));
            SIBLibrary sIBLibrary = (SIBLibrary)obj;
            if (sIBLibrary.getTypes().size() <= 0) {
                return node;
            }
            for (info.scce.dime.siblibrary.Type type : sIBLibrary.getTypes()) {
                this.buildFlatTree(type, node);
            }
        }
        if (obj instanceof info.scce.dime.siblibrary.Type) {
            node = new ContainerTreeNode(obj, ((info.scce.dime.siblibrary.Type)obj).getName());
        }
        if ((treeNode = parentNode.find(node.getId())) != null) {
            return treeNode;
        }
        parentNode.getChildren().add(node);
        node.setParent(parentNode);
        return node;
    }

    private TreeNode buildHierarchyTree(Object obj, TreeNode parentNode, boolean buildParent) {
        TreeNode existingNode;
        TreeNode node = new ContainerTreeNode(null, "dummy");
        if (obj instanceof Data) {
            node = new GraphModelTreeNode(obj, this.modelToResource.get(obj));
            if (((Data)obj).getTypes().size() <= 0) {
                return node;
            }
            for (Type type : this.utils.getRootTypes((Data)obj)) {
                this.buildHierarchyTree(type, node);
            }
        }
        if (obj instanceof Type) {
            node = new ModelElementTreeNode(obj);
            if (obj instanceof ReferencedType) {
                ReferencedType rType = (ReferencedType)obj;
                Type refType = this.utils.getOriginType((Type)rType);
                if (refType != null) {
                    node.setData(refType);
                }
                if (this.utils.getSuperType(refType) != null) {
                    parentNode = this.buildHierarchyTree(this.utils.getSuperType(refType), parentNode, true);
                }
            }
            for (ReferencedPrimitiveAttribute attr : ((Type)node.getData()).getAttributes()) {
                this.buildHierarchyTree(attr, node);
            }
            if (!buildParent) {
                for (Type type : this.utils.getSubTypes((Type)obj)) {
                    this.buildHierarchyTree(type, node);
                }
            }
        }
        if (obj instanceof Attribute) {
            ReferencedPrimitiveAttribute attr;
            node = new ModelElementTreeNode(obj);
            if (obj instanceof ReferencedPrimitiveAttribute) {
                attr = (ReferencedPrimitiveAttribute)obj;
                node.setData(attr.getReferencedAttribute());
            }
            if (obj instanceof ReferencedExtensionAttribute) {
                attr = (ReferencedExtensionAttribute)obj;
                node.setData(attr.getReferencedAttribute());
            }
            if (obj instanceof ReferencedUserAttribute) {
                attr = (ReferencedUserAttribute)obj;
                node.setData(attr.getReferencedAttribute());
            }
            if (obj instanceof ReferencedComplexAttribute) {
                attr = (ReferencedComplexAttribute)obj;
                node.setData(attr.getReferencedAttribute());
            }
        }
        if (obj instanceof SIBLibrary) {
            node = new GraphModelTreeNode(obj, this.modelToResource.get(obj));
            SIBLibrary sl = (SIBLibrary)obj;
            if (sl.getTypes().size() <= 0) {
                return node;
            }
            for (info.scce.dime.siblibrary.Type type : sl.getTypes()) {
                this.buildHierarchyTree(type, node);
            }
        }
        if (obj instanceof info.scce.dime.siblibrary.Type) {
            node = new ContainerTreeNode(obj, ((info.scce.dime.siblibrary.Type)obj).getName());
        }
        if ((existingNode = parentNode.find(node.getId())) != null) {
            return existingNode;
        }
        parentNode.getChildren().add(node);
        node.setParent(parentNode);
        return node;
    }

    private TreeNode buildHierarchyTree(Object obj, TreeNode parentNode) {
        return this.buildHierarchyTree(obj, parentNode, false);
    }

    public static enum ViewType {
        FLAT,
        HIERARCHY;

    }
}

