/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.provider;

import graphmodel.GraphModel;
import info.scce.dime.libcompviews.nodes.Category;
import info.scce.dime.libcompviews.nodes.ContainerTreeNode;
import info.scce.dime.libcompviews.nodes.EObjectTreeNode;
import info.scce.dime.libcompviews.nodes.GraphModelTreeNode;
import info.scce.dime.libcompviews.nodes.ModelElementTreeNode;
import info.scce.dime.libcompviews.nodes.TreeNode;
import info.scce.dime.libcompviews.provider.LibCompTreeProvider;
import info.scce.dime.libcompviews.utils.GraphModelUtils;
import info.scce.dime.modeltrafo.extensionpoint.ModeltrafoExtensionProvider;
import info.scce.dime.modeltrafo.extensionpoint.trafosupport.IModeltrafoSupporter;
import info.scce.dime.process.process.EntryPointProcessSIB;
import info.scce.dime.process.process.GUIBlueprintSIB;
import info.scce.dime.process.process.NativeFrontendSIB;
import info.scce.dime.process.process.Process;
import info.scce.dime.process.process.ProcessBlueprintSIB;
import info.scce.dime.process.process.ProcessType;
import info.scce.dime.siblibrary.SIB;
import info.scce.dime.siblibrary.SIBLibrary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;

public class ControlCompTreeProvider
extends LibCompTreeProvider {
    private String[] fileExtensions = new String[]{"process", "search", "sibs"};
    private ContainerTreeNode categoryRoot;
    private ContainerTreeNode folderstructRoot;
    private IProject project;
    private ViewType activeView = ViewType.CATEGORY;

    public ControlCompTreeProvider() {
        this.utils = new GraphModelUtils(this.fileExtensions);
    }

    @Override
    public TreeNode getTree() {
        switch (this.activeView) {
            case CATEGORY: {
                return this.categoryRoot;
            }
        }
        return this.folderstructRoot;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public ViewType getActiveView() {
        return this.activeView;
    }

    public void setActiveView(ViewType activeView) {
        this.activeView = activeView;
    }

    @Override
    public void loadData(IProject project) {
        this.project = project;
        long timeStart = System.currentTimeMillis();
        this.modelToResource = new HashMap();
        this.resourceToModel = new HashMap();
        ArrayList<IResource> contents = new ArrayList<IResource>();
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                contents.addAll(this.utils.loadRecursive(res));
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.modelReferencedIn = new HashMap();
        for (IResource iResource : contents) {
            try {
                if (!this.utils.isModelResource(iResource)) continue;
                EObject eObject = this.utils.loadModel(iResource);
                this.modelToResource.put(eObject, iResource);
                this.resourceToModel.put(iResource, eObject);
                if (!this.isShowReferencedInInfo()) continue;
                this.utils.collectReferences(eObject, this.modelReferencedIn);
            }
            catch (Exception exception) {
                System.err.println("Failed to load resource: " + iResource);
            }
        }
        long timeLoad = System.currentTimeMillis();
        switch (this.activeView) {
            case CATEGORY: {
                this.categoryRoot = new ContainerTreeNode(null, "root");
                LibCompTreeProvider.ModelType[] modelTypeArray = LibCompTreeProvider.ModelType.values();
                int n = modelTypeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    LibCompTreeProvider.ModelType modelType = modelTypeArray[n3];
                    this.buildCategoryTree((Object)modelType, this.categoryRoot);
                    ++n3;
                }
                for (IModeltrafoSupporter iModeltrafoSupporter : ModeltrafoExtensionProvider.getAllModeltrafoSupporter()) {
                    this.buildCategoryTree(iModeltrafoSupporter, this.categoryRoot);
                }
                break;
            }
            default: {
                this.folderstructRoot = new ContainerTreeNode(null, "root");
                for (Object e : this.getDirectChilds((IContainer)project)) {
                    this.buildFolderTree(e, this.folderstructRoot);
                }
            }
        }
        long l = System.currentTimeMillis();
        System.out.println("ControlCompView - load Models: " + (timeLoad - timeStart) + " ms / create Tree: " + (l - timeLoad) + " ms");
    }

    private TreeNode buildFolderTree(Object obj, TreeNode parentNode) {
        TreeNode node = new ContainerTreeNode(null, "dummy");
        if (obj instanceof IFolder) {
            node = new ContainerTreeNode(obj, ((IFolder)obj).getName());
            for (Object child : this.getDirectChilds((IContainer)obj)) {
                this.buildFolderTree(child, node);
            }
        }
        if (obj instanceof GraphModel) {
            node = new GraphModelTreeNode(obj, (IResource)this.modelToResource.get(obj));
            if (this.isShowReferencedInInfo()) {
                this.buildReferencedInSubTree(obj, node);
            }
        }
        if (obj instanceof SIBLibrary) {
            node = new GraphModelTreeNode(obj, (IResource)this.modelToResource.get(obj));
            SIBLibrary sl = (SIBLibrary)obj;
            if (sl.getSibs().size() <= 0) {
                return node;
            }
            for (SIB sib : sl.getSibs()) {
                this.buildFolderTree(sib, node);
            }
        }
        if (obj instanceof SIB) {
            node = new ContainerTreeNode(obj, ((SIB)obj).getName());
        }
        if (obj instanceof ProcessBlueprintSIB || obj instanceof GUIBlueprintSIB) {
            node = new ModelElementTreeNode(obj);
        }
        if (parentNode.find(node.getId()) == null) {
            parentNode.getChildren().add(node);
            node.setParent(parentNode);
        }
        return node;
    }

    private TreeNode buildCategoryTree(Object obj, TreeNode parentNode) {
        TreeNode node = new ContainerTreeNode(null, "dummy");
        if (obj instanceof LibCompTreeProvider.ModelType) {
            LibCompTreeProvider.ModelType type = (LibCompTreeProvider.ModelType)((Object)obj);
            node = new ContainerTreeNode(new Category(this.getNameForModelType(type), (Object)type), this.getNameForModelType(type));
            ArrayList<EObject> list = new ArrayList<EObject>();
            for (EObject model : this.modelToResource.keySet()) {
                if (!type.equals((Object)this.mapEObjectToType(model))) continue;
                list.add(model);
            }
            if (list.size() <= 0) {
                return node;
            }
            for (EObject eObject2 : list) {
                this.buildCategoryTree(eObject2, node);
            }
        }
        if (obj instanceof IModeltrafoSupporter) {
            IModeltrafoSupporter externProvider = (IModeltrafoSupporter)obj;
            node = new ContainerTreeNode(new Category(externProvider.getSIBName(), externProvider), externProvider.getSIBName());
            for (IResource resource : ModeltrafoExtensionProvider.getAllSupportedResourcesForProject((IModeltrafoSupporter)externProvider, (IProject)this.project)) {
                if (!(resource instanceof IFile)) continue;
                IFile file = (IFile)resource;
                this.buildCategoryTree(file, node);
            }
        }
        if (obj instanceof NativeFrontendSIB) {
            NativeFrontendSIB sib = (NativeFrontendSIB)obj;
            node = new ContainerTreeNode(obj, String.valueOf(sib.getLabel()) + "_" + sib.getMethodName());
        }
        if (obj instanceof GraphModel) {
            node = new GraphModelTreeNode(obj, (IResource)this.modelToResource.get(obj));
            if (this.isShowReferencedInInfo()) {
                this.buildReferencedInSubTree(obj, node);
            }
            if (obj instanceof Process) {
                Process p = (Process)obj;
                if (p.getProcessType() == ProcessType.NATIVE_FRONTEND_SIB_LIBRARY) {
                    List nfs = p.getNativeFrontendSIBLibrarys().stream().map(x -> x.getNativeFrontendSIBs().stream()).flatMap(Function.identity()).collect(Collectors.toList());
                    for (NativeFrontendSIB sib : nfs) {
                        this.buildCategoryTree(sib, node);
                    }
                }
                for (SIB sib : p.getEntryPointProcessSIBs()) {
                    this.buildCategoryTree(sib, node);
                }
                for (SIB sib : p.getBlueprintSIBs()) {
                    this.buildCategoryTree(sib, node);
                }
            }
        }
        if (obj instanceof SIBLibrary) {
            node = new GraphModelTreeNode(obj, (IResource)this.modelToResource.get(obj));
            SIBLibrary sl = (SIBLibrary)obj;
            if (sl.getSibs().size() <= 0) {
                return node;
            }
            for (SIB sib : sl.getSibs()) {
                this.buildCategoryTree(sib, node);
            }
        }
        if (obj instanceof SIB) {
            node = new ContainerTreeNode(obj, ((SIB)obj).getName());
        }
        if (obj instanceof EntryPointProcessSIB || obj instanceof ProcessBlueprintSIB || obj instanceof GUIBlueprintSIB) {
            node = new ModelElementTreeNode(obj);
        }
        if (obj instanceof EObject && ModeltrafoExtensionProvider.getSupportedModelElement((EObject)((EObject)obj)) != null) {
            node = new EObjectTreeNode(obj);
        }
        if (obj instanceof IFile) {
            Category category;
            IModeltrafoSupporter provider = null;
            if (parentNode.getData() instanceof Category && (category = (Category)parentNode.getData()).getType() instanceof IModeltrafoSupporter) {
                provider = (IModeltrafoSupporter)category.getType();
            }
            if (provider != null) {
                node = new GraphModelTreeNode(obj, (IResource)((IFile)obj));
                for (EObject content : ModeltrafoExtensionProvider.getAllSupportedElementsInResource((IResource)((IFile)obj), (IModeltrafoSupporter)provider)) {
                    if (content instanceof GraphModel) continue;
                    this.buildCategoryTree(content, node);
                }
            }
        }
        if (parentNode.find(node.getId()) == null) {
            parentNode.getChildren().add(node);
            node.setParent(parentNode);
        }
        return node;
    }

    public static enum ViewType {
        CATEGORY,
        FOLDERSTRUCT;

    }
}

