/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.pages;

import graphmodel.GraphModel;
import graphmodel.ModelElement;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.data.data.Type;
import info.scce.dime.gUIPlugin.AbstractParameter;
import info.scce.dime.gUIPlugin.ComplexInputParameter;
import info.scce.dime.gUIPlugin.Function;
import info.scce.dime.gUIPlugin.Output;
import info.scce.dime.gUIPlugin.Plugin;
import info.scce.dime.gUIPlugin.Plugins;
import info.scce.dime.gUIPlugin.PrimitiveInputParameter;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.ProcessSIB;
import info.scce.dime.libcompviews.nodes.Category;
import info.scce.dime.libcompviews.pages.LibCompPage;
import info.scce.dime.libcompviews.provider.LibCompTreeProvider;
import info.scce.dime.libcompviews.provider.UICompTreeProvider;
import info.scce.dime.libcompviews.utils.LibCompUtils;
import info.scce.dime.process.process.Process;
import info.scce.dime.search.search.Search;
import info.scce.dime.siblibrary.Branch;
import info.scce.dime.siblibrary.DataTypePort;
import info.scce.dime.siblibrary.JavaTypePort;
import info.scce.dime.siblibrary.Port;
import info.scce.dime.siblibrary.PrimitivePort;
import info.scce.dime.siblibrary.SIB;
import info.scce.dime.siblibrary.SIBLibrary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class UICompPage
extends LibCompPage {
    private UICompTreeProvider data = new UICompTreeProvider();
    private HashMap<String, Image> icons = new HashMap();
    private boolean showOnlyAllowedTypes = false;
    private UILabelProvider labelProvider = new UILabelProvider();
    private UINameSorter nameSorter = new UINameSorter();
    private UIModelTypeFilter modelTypeFilter = new UIModelTypeFilter();
    private ArrayList<LibCompTreeProvider.ModelType> hideModelTypes = new ArrayList();

    @Override
    public UICompTreeProvider getDataProvider() {
        return this.data;
    }

    public boolean isShowOnlyAllowedTypes() {
        return this.showOnlyAllowedTypes;
    }

    public void setShowOnlyAllowedTypes(boolean showOnlyAllowedTypes) {
        this.showOnlyAllowedTypes = showOnlyAllowedTypes;
    }

    public ArrayList<LibCompTreeProvider.ModelType> getHideModelTypes() {
        return this.hideModelTypes;
    }

    @Override
    public LabelProvider getDefaultLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public ViewerSorter getDefaultSorter() {
        return this.nameSorter;
    }

    public UIModelTypeFilter getModelTypeFilter() {
        return this.modelTypeFilter;
    }

    @Override
    protected void loadIcons() {
        try {
            super.loadIcons();
            this.icons.put("Folder", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
            this.icons.put("DadModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/dime16.png"), (boolean)true)));
            this.icons.put("ProcessModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/ProcessModel.png"), (boolean)true)));
            this.icons.put("GuiModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/GUI.png"), (boolean)true)));
            this.icons.put("SearchModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/SearchModel.png"), (boolean)true)));
            this.icons.put("AtomicSibLibrary", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/AtomicSibLib.png"), (boolean)true)));
            this.icons.put("GUIPlugins", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/guiPlugin.png"), (boolean)true)));
            this.icons.put("GUIPlugin", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/gPlugin.png"), (boolean)true)));
            this.icons.put("AtomicSibLibraryContent", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/r_attr.png"), (boolean)true)));
            this.icons.put("ReferencingComponent", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/r_attr.png"), (boolean)true)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void openAndHighlight(Object obj) {
        if ((obj = this.getTreeNodeData(obj)) instanceof ModelElement) {
            Process wrapper;
            ModelElement me = (ModelElement)obj;
            IEditorPart editorPart = this.openEditor((EObject)me.getRootElement());
            if (me.getRootElement() instanceof Process) {
                wrapper = this.data.getUtils().getProcessWrapperFromEditor(editorPart);
                this.data.getUtils().highlightElement(wrapper, me.getId());
            }
            if (me.getRootElement() instanceof GUI) {
                wrapper = this.data.getUtils().getGuiWrapperFromEditor(editorPart);
                this.data.getUtils().highlightElement((GUI)wrapper, me.getId());
            }
        }
        if (obj instanceof GraphModel) {
            this.openEditor((EObject)((GraphModel)obj));
        }
    }

    @Override
    public void reload() {
        this.storeTreeState();
        this.data.reset();
        this.treeViewer.setInput((Object)this.parentViewPart.getViewSite());
        this.restoreTreeState();
    }

    public void calculateModelTypesToHide(IResource res) {
        this.hideModelTypes.clear();
        EObject activeModel = this.data.getEObjectForResource(res);
        LibCompTreeProvider.ModelType modelType = this.data.mapEObjectToType(activeModel);
        List<LibCompTreeProvider.ModelType> allowedTypes = this.data.getAllowedModels().get((Object)modelType);
        LibCompTreeProvider.ModelType[] modelTypeArray = LibCompTreeProvider.ModelType.values();
        int n = modelTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LibCompTreeProvider.ModelType type = modelTypeArray[n2];
            if (allowedTypes == null || !allowedTypes.contains((Object)type)) {
                this.hideModelTypes.add(type);
            }
            ++n2;
        }
    }

    private class UILabelProvider
    extends LabelProvider {
        private UILabelProvider() {
        }

        public String getText(Object obj) {
            if ((obj = UICompPage.this.getTreeNodeData(obj)) instanceof Category) {
                return ((Category)obj).getName();
            }
            if (obj instanceof IFolder) {
                return ((IFolder)obj).getName();
            }
            if (obj instanceof GraphModel) {
                String label = UICompPage.this.data.getModelToResource().get(obj).getName();
                if (obj instanceof Process) {
                    label = String.valueOf(label) + " (" + ((Process)obj).getProcessType() + ")";
                }
                return label;
            }
            if (obj instanceof info.scce.dime.process.process.SIB) {
                info.scce.dime.process.process.SIB sib = (info.scce.dime.process.process.SIB)obj;
                Process process = sib.getRootElement();
                return String.valueOf(sib.getLabel()) + " (" + process.getModelName() + ")";
            }
            if (obj instanceof ProcessSIB) {
                GUI gui = ((ProcessSIB)obj).getRootElement();
                return String.valueOf(gui.getTitle()) + " (Embedded Interaction)";
            }
            if (obj instanceof SIBLibrary) {
                return UICompPage.this.data.getModelToResource().get(obj).getName();
            }
            if (obj instanceof SIB) {
                SIB sib = (SIB)obj;
                String label = sib.getName();
                if (sib.getInputPorts().size() > 0) {
                    label = String.valueOf(label) + " ( ";
                    for (Port port : sib.getInputPorts()) {
                        if (port instanceof PrimitivePort) {
                            label = String.valueOf(label) + ((PrimitivePort)port).getType();
                        }
                        if (port instanceof JavaTypePort) {
                            label = String.valueOf(label) + ((JavaTypePort)port).getType();
                        }
                        if (port instanceof DataTypePort) {
                            EObject type = ((DataTypePort)port).getType();
                            label = type instanceof Type ? String.valueOf(label) + ((Type)type).getName() : String.valueOf(label) + "DataType";
                        }
                        label = String.valueOf(label) + " ";
                    }
                    label = String.valueOf(label) + ")";
                }
                label = String.valueOf(label) + " -> |";
                for (Branch branch : sib.getBranches()) {
                    label = String.valueOf(label) + branch.getName() + "|";
                }
                return label;
            }
            if (obj instanceof Plugins) {
                return UICompPage.this.data.getModelToResource().get(obj).getName();
            }
            if (obj instanceof Plugin) {
                return ((Plugin)obj).getPath();
            }
            if (obj instanceof Function) {
                Function sib = (Function)obj;
                String label = sib.getFunctionName();
                if (sib.getParameters().size() > 0) {
                    label = String.valueOf(label) + " ( ";
                    for (AbstractParameter port : sib.getParameters()) {
                        label = port instanceof ComplexInputParameter ? String.valueOf(label) + ((ComplexInputParameter)port).getParameter().getName() + " " : (port instanceof PrimitiveInputParameter ? String.valueOf(label) + ((PrimitiveInputParameter)port).getParameter().getName() + " " : String.valueOf(label) + port.getName() + " ");
                    }
                    label = String.valueOf(label) + ")";
                }
                if (sib.getOutputs().size() > 0) {
                    label = String.valueOf(label) + " -> |";
                    for (Output branch : sib.getOutputs()) {
                        label = String.valueOf(label) + branch.getOutputName() + "|";
                    }
                }
                return label;
            }
            if (obj instanceof info.scce.dime.siblibrary.Type) {
                return ((info.scce.dime.siblibrary.Type)obj).getName();
            }
            return "unknown";
        }

        public Image getImage(Object obj) {
            Category cat;
            Object typeObj;
            if ((obj = UICompPage.this.getTreeNodeData(obj)) instanceof IFolder) {
                return (Image)UICompPage.this.icons.get("Folder");
            }
            if (obj instanceof DAD) {
                return (Image)UICompPage.this.icons.get("DadModel");
            }
            if (obj instanceof Plugins) {
                return (Image)UICompPage.this.icons.get("GUIPlugins");
            }
            if (obj instanceof Plugin) {
                return (Image)UICompPage.this.icons.get("GUIPlugin");
            }
            if (obj instanceof Function) {
                return (Image)UICompPage.this.icons.get("AtomicSibLibraryContent");
            }
            if (obj instanceof GUI) {
                return (Image)UICompPage.this.icons.get("GuiModel");
            }
            if (obj instanceof Search) {
                return (Image)UICompPage.this.icons.get("SearchModel");
            }
            if (obj instanceof Process) {
                return (Image)UICompPage.this.icons.get("ProcessModel");
            }
            if (obj instanceof info.scce.dime.process.process.SIB) {
                return (Image)UICompPage.this.icons.get("ReferencingComponent");
            }
            if (obj instanceof ProcessSIB) {
                return (Image)UICompPage.this.icons.get("ReferencingComponent");
            }
            if (obj instanceof SIBLibrary) {
                return (Image)UICompPage.this.icons.get("AtomicSibLibrary");
            }
            if (obj instanceof SIB) {
                return (Image)UICompPage.this.icons.get("AtomicSibLibraryContent");
            }
            if (obj instanceof Category && (typeObj = (cat = (Category)obj).getType()) instanceof LibCompTreeProvider.ModelType) {
                LibCompTreeProvider.ModelType type = (LibCompTreeProvider.ModelType)((Object)typeObj);
                switch (type) {
                    case DAD: {
                        return (Image)UICompPage.this.icons.get("DadModel");
                    }
                    case GUI: {
                        return (Image)UICompPage.this.icons.get("GuiModel");
                    }
                    case SEARCH: {
                        return (Image)UICompPage.this.icons.get("SearchModel");
                    }
                    case SIBLIBRARY: {
                        return (Image)UICompPage.this.icons.get("AtomicSibLibrary");
                    }
                    case PROCESS: 
                    case PROCESS_BASIC: 
                    case PROCESS_LONGRUNNING: 
                    case PROCESS_SECURITY: {
                        return (Image)UICompPage.this.icons.get("ProcessModel");
                    }
                }
            }
            return null;
        }
    }

    private class UIModelTypeFilter
    extends ViewerFilter {
        private UIModelTypeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            parentElement = UICompPage.this.getTreeNodeData(parentElement);
            return !((element = UICompPage.this.getTreeNodeData(element)) instanceof EObject) || !UICompPage.this.hideModelTypes.contains((Object)UICompPage.this.data.mapEObjectToType((EObject)element));
        }
    }

    private class UINameSorter
    extends ViewerSorter {
        private UINameSorter() {
        }

        public int category(Object element) {
            if (element instanceof IFolder) {
                return 1;
            }
            if (element instanceof GraphModel) {
                return 2;
            }
            if (element instanceof SIBLibrary) {
                return 3;
            }
            if (element instanceof info.scce.dime.siblibrary.Type) {
                return 4;
            }
            if (element instanceof SIB) {
                return 5;
            }
            if (element instanceof Plugins) {
                return 6;
            }
            return 99;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            e1 = UICompPage.this.getTreeNodeData(e1);
            e2 = UICompPage.this.getTreeNodeData(e2);
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof EObject && e2 instanceof EObject) {
                IResource res1 = UICompPage.this.data.getModelToResource().get(e1);
                IResource res2 = UICompPage.this.data.getModelToResource().get(e2);
                if (res1 != null && res2 != null) {
                    return res1.getName().toLowerCase().compareTo(res2.getName().toLowerCase());
                }
            }
            if (e1 instanceof IFolder && e2 instanceof IFolder) {
                IFolder folder1 = (IFolder)e1;
                IFolder folder2 = (IFolder)e2;
                return folder1.getName().toLowerCase().compareTo(folder2.getName().toLowerCase());
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

