/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.pages;

import graphmodel.Edge;
import graphmodel.GraphModel;
import graphmodel.ModelElement;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.dad.dad.ProcessComponent;
import info.scce.dime.gUIPlugin.Plugin;
import info.scce.dime.gUIPlugin.Plugins;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.SIB;
import info.scce.dime.libcompviews.nodes.GraphModelTreeNode;
import info.scce.dime.libcompviews.nodes.PrimeTreeNode;
import info.scce.dime.libcompviews.pages.LibCompPage;
import info.scce.dime.libcompviews.provider.LibCompTreeProvider;
import info.scce.dime.libcompviews.provider.ModelHierarchyTreeProvider;
import info.scce.dime.libcompviews.utils.LibCompUtils;
import info.scce.dime.process.process.Process;
import info.scce.dime.search.search.Search;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ModelHierarchyPage
extends LibCompPage {
    private ModelHierarchyTreeProvider data = new ModelHierarchyTreeProvider();
    private HashMap<String, Image> icons = new HashMap();
    private ModelHierarchyLabelProvider labelProvider = new ModelHierarchyLabelProvider();
    private ModelHierarchyNameSorter nameSorter = new ModelHierarchyNameSorter();
    private ModelHierarchyModelTypeFilter modelTypeFilter = new ModelHierarchyModelTypeFilter();
    private ArrayList<LibCompTreeProvider.ModelType> hideModelTypes = new ArrayList();

    @Override
    public ModelHierarchyTreeProvider getDataProvider() {
        return this.data;
    }

    public ArrayList<LibCompTreeProvider.ModelType> getHideModelTypes() {
        return this.hideModelTypes;
    }

    @Override
    public LabelProvider getDefaultLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public ViewerSorter getDefaultSorter() {
        return this.nameSorter;
    }

    public ModelHierarchyModelTypeFilter getModelTypeFilter() {
        return this.modelTypeFilter;
    }

    @Override
    protected void loadIcons() {
        try {
            super.loadIcons();
            this.icons.put("Folder", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
            this.icons.put("DadModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/dime16.png"), (boolean)true)));
            this.icons.put("ProcessModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/ProcessModel.png"), (boolean)true)));
            this.icons.put("GuiModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/GUI.png"), (boolean)true)));
            this.icons.put("SearchModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/SearchModel.png"), (boolean)true)));
            this.icons.put("GUIPlugin", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/gPlugin.png"), (boolean)true)));
            this.icons.put("ReferencingComponent", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/r_attr.png"), (boolean)true)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void openAndHighlight(Object obj) {
        if ((obj = this.getTreeNodeData(obj)) instanceof ModelElement) {
            Process wrapper;
            ModelElement me = (ModelElement)obj;
            IEditorPart editorPart = this.openEditor((EObject)me.getRootElement());
            if (me.getRootElement() instanceof Process) {
                wrapper = this.data.getUtils().getProcessWrapperFromEditor(editorPart);
                this.data.getUtils().highlightElement(wrapper, me.getId());
            }
            if (me.getRootElement() instanceof GUI) {
                wrapper = this.data.getUtils().getGuiWrapperFromEditor(editorPart);
                this.data.getUtils().highlightElement((GUI)wrapper, me.getId());
            }
        } else if (obj instanceof EObject) {
            this.openEditor((EObject)obj);
        }
    }

    @Override
    public void reload() {
        this.storeTreeState();
        this.data.reset();
        this.treeViewer.setInput((Object)this.parentViewPart.getViewSite());
        this.restoreTreeState();
    }

    private class ModelHierarchyLabelProvider
    extends LabelProvider {
        private ModelHierarchyLabelProvider() {
        }

        public String getText(Object obj) {
            String label = "";
            if (obj instanceof PrimeTreeNode) {
                ProcessComponent sib;
                PrimeTreeNode node = (PrimeTreeNode)obj;
                if (node.getElement() instanceof ProcessComponent) {
                    sib = (ProcessComponent)node.getElement();
                    label = String.valueOf(label) + ((Edge)sib.getIncoming().get(0)).getClass().getSimpleName();
                }
                if (node.getElement() instanceof SIB) {
                    sib = (SIB)node.getElement();
                    label = String.valueOf(label) + sib.getLabel();
                }
                if (node.getElement() instanceof info.scce.dime.process.process.SIB) {
                    sib = (info.scce.dime.process.process.SIB)node.getElement();
                    label = String.valueOf(label) + sib.getLabel();
                }
                if (node.getModel() instanceof GraphModel) {
                    String text = ModelHierarchyPage.this.data.getModelToResource().get(node.getModel()).getName();
                    if (obj instanceof Process) {
                        text = String.valueOf(text) + " (" + ((Process)obj).getProcessType() + ")";
                    }
                    label = String.valueOf(label) + " \u21d2 " + text;
                }
                return label;
            }
            if (obj instanceof GraphModelTreeNode) {
                GraphModelTreeNode node = (GraphModelTreeNode)obj;
                if (node.getData() instanceof GraphModel) {
                    String text = ModelHierarchyPage.this.data.getModelToResource().get(node.getData()).getName();
                    if (obj instanceof Process) {
                        text = String.valueOf(text) + " (" + ((Process)obj).getProcessType() + ")";
                    }
                    label = String.valueOf(label) + text;
                }
                return label;
            }
            return "unknown: " + obj;
        }

        public Image getImage(Object obj) {
            if ((obj = obj instanceof PrimeTreeNode ? ((PrimeTreeNode)obj).getModel() : ModelHierarchyPage.this.getTreeNodeData(obj)) instanceof IFolder) {
                return (Image)ModelHierarchyPage.this.icons.get("Folder");
            }
            if (obj instanceof DAD) {
                return (Image)ModelHierarchyPage.this.icons.get("DadModel");
            }
            if (obj instanceof Plugin) {
                return (Image)ModelHierarchyPage.this.icons.get("GUIPlugin");
            }
            if (obj instanceof GUI) {
                return (Image)ModelHierarchyPage.this.icons.get("GuiModel");
            }
            if (obj instanceof Search) {
                return (Image)ModelHierarchyPage.this.icons.get("SearchModel");
            }
            if (obj instanceof Process) {
                return (Image)ModelHierarchyPage.this.icons.get("ProcessModel");
            }
            if (obj instanceof info.scce.dime.process.process.SIB) {
                return (Image)ModelHierarchyPage.this.icons.get("ReferencingComponent");
            }
            return (Image)ModelHierarchyPage.this.icons.get("ReferencingComponent");
        }
    }

    private class ModelHierarchyModelTypeFilter
    extends ViewerFilter {
        private ModelHierarchyModelTypeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            parentElement = ModelHierarchyPage.this.getTreeNodeData(parentElement);
            return !((element = ModelHierarchyPage.this.getTreeNodeData(element)) instanceof EObject) || !ModelHierarchyPage.this.hideModelTypes.contains((Object)ModelHierarchyPage.this.data.mapEObjectToType((EObject)element));
        }
    }

    private class ModelHierarchyNameSorter
    extends ViewerSorter {
        private ModelHierarchyNameSorter() {
        }

        public int category(Object element) {
            if (element instanceof IFolder) {
                return 1;
            }
            if (element instanceof GraphModel) {
                return 2;
            }
            if (element instanceof info.scce.dime.siblibrary.SIB) {
                return 5;
            }
            if (element instanceof Plugins) {
                return 6;
            }
            return 99;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            e1 = ModelHierarchyPage.this.getTreeNodeData(e1);
            e2 = ModelHierarchyPage.this.getTreeNodeData(e2);
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof EObject && e2 instanceof EObject) {
                IResource res1 = ModelHierarchyPage.this.data.getModelToResource().get(e1);
                IResource res2 = ModelHierarchyPage.this.data.getModelToResource().get(e2);
                if (res1 != null && res2 != null) {
                    return res1.getName().toLowerCase().compareTo(res2.getName().toLowerCase());
                }
            }
            if (e1 instanceof IFolder && e2 instanceof IFolder) {
                IFolder folder1 = (IFolder)e1;
                IFolder folder2 = (IFolder)e2;
                return folder1.getName().toLowerCase().compareTo(folder2.getName().toLowerCase());
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

