/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.pages;

import graphmodel.GraphModel;
import graphmodel.ModelElement;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.dad.dad.ProcessComponent;
import info.scce.dime.dad.dad.ProcessEntryPointComponent;
import info.scce.dime.dad.dad.URLProcess;
import info.scce.dime.libcompviews.nodes.Category;
import info.scce.dime.libcompviews.pages.LibCompPage;
import info.scce.dime.libcompviews.provider.LibCompTreeProvider;
import info.scce.dime.libcompviews.provider.LinkCompTreeProvider;
import info.scce.dime.libcompviews.utils.LibCompUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.osgi.framework.Bundle;

public class LinkCompPage
extends LibCompPage {
    private LinkCompTreeProvider data = new LinkCompTreeProvider();
    private HashMap<String, Image> icons = new HashMap();
    private boolean showOnlyAllowedTypes = false;
    private LinkLabelProvider labelProvider = new LinkLabelProvider();
    private LinkNameSorter nameSorter = new LinkNameSorter();
    private LinkModelTypeFilter modelTypeFilter = new LinkModelTypeFilter();
    private ArrayList<LibCompTreeProvider.ModelType> hideModelTypes = new ArrayList();

    @Override
    public LinkCompTreeProvider getDataProvider() {
        return this.data;
    }

    public boolean isShowOnlyAllowedTypes() {
        return this.showOnlyAllowedTypes;
    }

    public void setShowOnlyAllowedTypes(boolean showOnlyAllowedTypes) {
        this.showOnlyAllowedTypes = showOnlyAllowedTypes;
    }

    public ArrayList<LibCompTreeProvider.ModelType> getHideModelTypes() {
        return this.hideModelTypes;
    }

    @Override
    public LabelProvider getDefaultLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public ViewerSorter getDefaultSorter() {
        return this.nameSorter;
    }

    public LinkModelTypeFilter getModelTypeFilter() {
        return this.modelTypeFilter;
    }

    @Override
    protected void loadIcons() {
        try {
            super.loadIcons();
            this.icons.put("LinkModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/linkSIB16.png"), (boolean)true)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void openAndHighlight(Object obj) {
        if ((obj = this.getTreeNodeData(obj)) instanceof ModelElement) {
            DAD wrapper;
            ModelElement me = (ModelElement)obj;
            IEditorPart editorPart = this.openEditor((EObject)me.getRootElement());
            if (me instanceof URLProcess) {
                wrapper = this.data.getUtils().getDADWrapperFromEditor(editorPart);
                this.data.getUtils().highlightElement(wrapper, me.getId());
            }
            if (me.getRootElement() instanceof DAD) {
                wrapper = this.data.getUtils().getDADWrapperFromEditor(editorPart);
                this.data.getUtils().highlightElement(wrapper, me.getId());
            }
        } else if (obj instanceof EObject) {
            this.openEditor((EObject)obj);
        }
    }

    @Override
    public void reload() {
        this.storeTreeState();
        this.data.reset();
        this.treeViewer.setInput((Object)this.parentViewPart.getViewSite());
        this.restoreTreeState();
    }

    public void calculateModelTypesToHide(IResource res) {
        this.hideModelTypes.clear();
        EObject activeModel = this.data.getEObjectForResource(res);
        LibCompTreeProvider.ModelType modelType = this.data.mapEObjectToType(activeModel);
        List<LibCompTreeProvider.ModelType> allowedTypes = this.data.getAllowedModels().get((Object)modelType);
        LibCompTreeProvider.ModelType[] modelTypeArray = LibCompTreeProvider.ModelType.values();
        int n = modelTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LibCompTreeProvider.ModelType type = modelTypeArray[n2];
            if (allowedTypes == null || !allowedTypes.contains((Object)type)) {
                this.hideModelTypes.add(type);
            }
            ++n2;
        }
    }

    private class LinkLabelProvider
    extends LabelProvider {
        private LinkLabelProvider() {
        }

        public String getText(Object obj) {
            if ((obj = LinkCompPage.this.getTreeNodeData(obj)) instanceof Category) {
                return ((Category)obj).getName();
            }
            if (obj instanceof IFolder) {
                return ((IFolder)obj).getName();
            }
            if (obj instanceof GraphModel) {
                String label = LinkCompPage.this.data.getModelToResource().get(obj).getName();
                return label;
            }
            if (obj instanceof URLProcess) {
                String l = "";
                String url = ((URLProcess)obj).getUrl();
                if (obj instanceof ProcessComponent) {
                    l = ((ProcessComponent)obj).getModel().getModelName();
                }
                if (obj instanceof ProcessEntryPointComponent) {
                    l = ((ProcessEntryPointComponent)obj).getEntryPoint().getLabel();
                }
                if (url == null) {
                    url = l;
                }
                return "/" + url + " (" + l + ")";
            }
            return "unknown";
        }

        public Image getImage(Object obj) {
            if ((obj = LinkCompPage.this.getTreeNodeData(obj)) instanceof IFolder) {
                return (Image)LinkCompPage.this.icons.get("Folder");
            }
            if (obj instanceof URLProcess) {
                return (Image)LinkCompPage.this.icons.get("LinkModel");
            }
            return null;
        }
    }

    private class LinkModelTypeFilter
    extends ViewerFilter {
        private LinkModelTypeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            parentElement = LinkCompPage.this.getTreeNodeData(parentElement);
            return !((element = LinkCompPage.this.getTreeNodeData(element)) instanceof EObject) || !LinkCompPage.this.hideModelTypes.contains((Object)LinkCompPage.this.data.mapEObjectToType((EObject)element));
        }
    }

    private class LinkNameSorter
    extends ViewerSorter {
        private LinkNameSorter() {
        }

        public int category(Object element) {
            if (element instanceof IFolder) {
                return 1;
            }
            if (element instanceof GraphModel) {
                return 2;
            }
            if (element instanceof URLProcess) {
                return 3;
            }
            return 99;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            e1 = LinkCompPage.this.getTreeNodeData(e1);
            e2 = LinkCompPage.this.getTreeNodeData(e2);
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof EObject && e2 instanceof EObject) {
                IResource res1 = LinkCompPage.this.data.getModelToResource().get(e1);
                IResource res2 = LinkCompPage.this.data.getModelToResource().get(e2);
                if (res1 != null && res2 != null) {
                    return res1.getName().toLowerCase().compareTo(res2.getName().toLowerCase());
                }
            }
            if (e1 instanceof IFolder && e2 instanceof IFolder) {
                IFolder folder1 = (IFolder)e1;
                IFolder folder2 = (IFolder)e2;
                return folder1.getName().toLowerCase().compareTo(folder2.getName().toLowerCase());
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

