/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.pages;

import info.scce.dime.libcompviews.nodes.TreeNode;
import info.scce.dime.libcompviews.provider.TreeProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class LibCompPage {
    protected Composite parent;
    protected ViewPart parentViewPart;
    protected TreeViewer treeViewer;
    private Composite frameComposite;
    protected IProject project;
    protected Bundle bundle = FrameworkUtil.getBundle(this.getClass());
    private Image iconClearSearch = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE");
    private HashMap<String, Boolean> expandState = new HashMap();
    private LibCompFullTextFilter defaultFilterFullText = new LibCompFullTextFilter();
    private LibCompContentProvider defaultContentProvider = new LibCompContentProvider();

    public Composite getFrameComposite() {
        return this.frameComposite;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public IProject getProject() {
        return this.project;
    }

    public LibCompFullTextFilter getDefaultFilterFullText() {
        return this.defaultFilterFullText;
    }

    public void setDefaultFilterFullText(LibCompFullTextFilter defaultFilterFullText) {
        this.defaultFilterFullText = defaultFilterFullText;
    }

    public LibCompContentProvider getDefaultContentProvider() {
        return this.defaultContentProvider;
    }

    public void setDefaultContentProvider(LibCompContentProvider defaultContentProvider) {
        this.defaultContentProvider = defaultContentProvider;
    }

    protected void loadIcons() throws IOException {
    }

    public void initPage(Composite parent, ViewPart parentViewPart, IProject project) throws IOException {
        this.parent = parent;
        this.parentViewPart = parentViewPart;
        this.project = project;
        this.loadIcons();
        this.frameComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        this.frameComposite.setLayout((Layout)gridLayout);
        this.frameComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final Text searchField = new Text(this.frameComposite, 2052);
        GridData gridData = new GridData(4, 0, true, false);
        searchField.setLayoutData((Object)gridData);
        searchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                LibCompPage.this.treeViewer.removeFilter((ViewerFilter)LibCompPage.this.defaultFilterFullText);
                LibCompPage.this.defaultFilterFullText.searchString = text.getText();
                LibCompPage.this.treeViewer.addFilter((ViewerFilter)LibCompPage.this.defaultFilterFullText);
                if (text.getText().length() > 0) {
                    LibCompPage.this.treeViewer.expandAll();
                }
            }
        });
        Button buttonClearSearch = new Button(this.frameComposite, 0);
        buttonClearSearch.setImage(this.iconClearSearch);
        buttonClearSearch.setToolTipText("clear search field");
        buttonClearSearch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                searchField.setText("");
            }
        });
        this.treeViewer = new TreeViewer(this.frameComposite, 768);
        GridData gridDataViewer = new GridData(4, 4, true, true);
        gridDataViewer.horizontalSpan = 4;
        this.treeViewer.getTree().setLayoutData((Object)gridDataViewer);
        this.treeViewer.setContentProvider((IContentProvider)this.defaultContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.getDefaultLabelProvider());
        this.treeViewer.setSorter(this.getDefaultSorter());
        this.treeViewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                ISelection sel = LibCompPage.this.treeViewer.getSelection();
                if (sel instanceof TreeSelection) {
                    TreeSelection treeSel = (TreeSelection)LibCompPage.this.treeViewer.getSelection();
                    ArrayList<Object> selItems = new ArrayList<Object>();
                    Object firstELem = treeSel.getFirstElement();
                    if (firstELem instanceof TreeNode) {
                        selItems.add(((TreeNode)firstELem).getData());
                    }
                    sel = new StructuredSelection(selItems);
                }
                LocalSelectionTransfer.getTransfer().setSelection(sel);
            }
        });
        this.treeViewer.getTree().addListener(17, new Listener(){

            public void handleEvent(Event e) {
                LibCompPage.this.storeTreeState();
                LibCompPage.this.expandState.put(LibCompPage.this.getPathIdentifier(((TreeItem)e.item).getData()), true);
            }
        });
        this.treeViewer.getTree().addListener(18, new Listener(){

            public void handleEvent(Event e) {
                LibCompPage.this.storeTreeState();
                LibCompPage.this.expandState.put(LibCompPage.this.getPathIdentifier(((TreeItem)e.item).getData()), false);
            }
        });
        this.treeViewer.setInput((Object)parentViewPart.getViewSite());
        this.frameComposite.pack();
    }

    public void storeTreeState() {
        this.expandState.clear();
        ArrayList<TreeItem> list = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = this.treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            list.add(item);
            list.addAll(this.getAllTreeItems(item));
            ++n2;
        }
        for (TreeItem treeItem : list) {
            this.expandState.put(this.getPathIdentifier(treeItem.getData()), treeItem.getExpanded());
        }
    }

    public void restoreTreeState() {
        this.treeViewer.expandAll();
        ArrayList<TreeItem> list = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = this.treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            list.add(item);
            list.addAll(this.getAllTreeItems(item));
            ++n2;
        }
        for (TreeItem treeItem : list) {
            Boolean expanded = this.expandState.get(this.getPathIdentifier(treeItem.getData()));
            if (expanded == null) continue;
            treeItem.setExpanded(expanded.booleanValue());
        }
    }

    public void selectTreeItem(IFile file) {
        this.storeTreeState();
        ArrayList<TreeItem> list = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = this.treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            list.add(item);
            list.addAll(this.getAllTreeItems(item));
            ++n2;
        }
        for (TreeItem treeItem : list) {
            if (!treeItem.getText().contains(file.getName())) continue;
            this.treeViewer.setSelection((ISelection)new StructuredSelection(treeItem.getData()), true);
            TreeItem item = treeItem;
            while (item != null) {
                this.expandState.put(this.getPathIdentifier(item.getData()), true);
                item = item.getParentItem();
            }
        }
        this.restoreTreeState();
    }

    private String getPathIdentifier(Object obj) {
        if (obj instanceof TreeNode) {
            return ((TreeNode)obj).getPathIdentifier();
        }
        return "";
    }

    protected Object getTreeNodeData(Object obj) {
        if (obj instanceof TreeNode) {
            return ((TreeNode)obj).getData();
        }
        return obj;
    }

    private List<TreeItem> getAllTreeItems(TreeItem item) {
        ArrayList<TreeItem> list = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            list.add(treeItem);
            list.addAll(this.getAllTreeItems(treeItem));
            ++n2;
        }
        return list;
    }

    public void closeView() {
        this.frameComposite.dispose();
    }

    public void toggleExpand(Object obj) {
        if (obj instanceof TreeNode) {
            ArrayList<TreeItem> list = new ArrayList<TreeItem>();
            TreeItem[] treeItemArray = this.treeViewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                list.add(item);
                list.addAll(this.getAllTreeItems(item));
                ++n2;
            }
            for (TreeItem treeItem : list) {
                if (treeItem.getData() != obj) continue;
                if (treeItem.getExpanded()) {
                    this.treeViewer.collapseToLevel(obj, -1);
                    this.expandState.put(this.getPathIdentifier(treeItem.getData()), false);
                } else {
                    this.treeViewer.expandToLevel(obj, 1);
                    this.expandState.put(this.getPathIdentifier(treeItem.getData()), true);
                }
                return;
            }
        }
    }

    protected IEditorPart openEditor(EObject eObj) {
        IEditorPart iEditor = null;
        URI uri = EcoreUtil.getURI((EObject)eObj);
        URI uri2 = eObj.eResource().getURI();
        IFile iFile = null;
        Path path = null;
        if (uri.toPlatformString(true) != null) {
            path = new Path(uri.toPlatformString(true));
        }
        if (uri.toFileString() != null) {
            IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
            path = new Path(newFile.getFullPath().toOSString());
        }
        if (path != null) {
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        if (iFile == null) {
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri2.toString()));
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            iEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)iFile);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return iEditor;
    }

    public abstract LabelProvider getDefaultLabelProvider();

    public abstract ViewerSorter getDefaultSorter();

    public abstract void reload();

    public abstract void openAndHighlight(Object var1);

    public abstract TreeProvider getDataProvider();

    private class LibCompContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private final Object[] EMPTY_ARRAY = new Object[0];

        private LibCompContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(LibCompPage.this.parentViewPart.getViewSite())) {
                if (LibCompPage.this.getDataProvider().isResetted()) {
                    LibCompPage.this.getDataProvider().load(LibCompPage.this.project);
                }
                return this.getChildren(LibCompPage.this.getDataProvider().getTree());
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeNode) {
                return ((TreeNode)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeNode) {
                return ((TreeNode)parent).getChildren().toArray();
            }
            return this.EMPTY_ARRAY;
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }
    }

    private class LibCompFullTextFilter
    extends ViewerFilter {
        private String searchString;

        private LibCompFullTextFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.searchString.length() > 0) {
                if (this.compare(LibCompPage.this.getDefaultLabelProvider().getText(element))) {
                    return true;
                }
                if (this.compare(LibCompPage.this.getDefaultLabelProvider().getText(parentElement))) {
                    return true;
                }
                return element instanceof TreeNode && this.compare((TreeNode)element);
            }
            return true;
        }

        private boolean compare(TreeNode element) {
            if (this.compare(LibCompPage.this.getDefaultLabelProvider().getText((Object)element))) {
                return true;
            }
            for (TreeNode childElement : element.getChildren()) {
                if (!this.compare(childElement)) continue;
                return true;
            }
            return false;
        }

        private boolean compare(String string) {
            return string.toLowerCase().contains(this.searchString.toLowerCase());
        }
    }
}

