/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.pages;

import graphmodel.GraphModel;
import graphmodel.ModelElement;
import info.scce.dime.data.data.AbstractType;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.ComplexAttribute;
import info.scce.dime.data.data.ConcreteType;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.data.EnumLiteral;
import info.scce.dime.data.data.EnumType;
import info.scce.dime.data.data.ExtensionAttribute;
import info.scce.dime.data.data.PrimitiveAttribute;
import info.scce.dime.data.data.ReferencedBidirectionalAttribute;
import info.scce.dime.data.data.ReferencedComplexAttribute;
import info.scce.dime.data.data.ReferencedEnumType;
import info.scce.dime.data.data.ReferencedExtensionAttribute;
import info.scce.dime.data.data.ReferencedPrimitiveAttribute;
import info.scce.dime.data.data.ReferencedType;
import info.scce.dime.data.data.ReferencedUserAttribute;
import info.scce.dime.data.data.ReferencedUserType;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.data.UserType;
import info.scce.dime.libcompviews.pages.LibCompPage;
import info.scce.dime.libcompviews.provider.DataCompTreeProvider;
import info.scce.dime.libcompviews.utils.LibCompUtils;
import info.scce.dime.siblibrary.SIBLibrary;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.osgi.framework.Bundle;

public class DataCompPage
extends LibCompPage {
    private DataCompTreeProvider data = new DataCompTreeProvider();
    private HashMap<String, Image> icons = new HashMap();
    private boolean showInheritanceInfo = true;
    private boolean hideAbstractTypes = false;
    private DataAbstractTypeFilter filterAbstractType = new DataAbstractTypeFilter();
    private DataLabelProvider labelProvider = new DataLabelProvider();
    private DataNameSorter nameSorter = new DataNameSorter();

    @Override
    public DataCompTreeProvider getDataProvider() {
        return this.data;
    }

    public boolean isShowInheritanceInfo() {
        return this.showInheritanceInfo;
    }

    public void setShowInheritanceInfo(boolean showInheritanceInfo) {
        this.showInheritanceInfo = showInheritanceInfo;
    }

    public boolean isHideAbstractTypes() {
        return this.hideAbstractTypes;
    }

    public void setHideAbstractTypes(boolean hideAbstractTypes) {
        this.hideAbstractTypes = hideAbstractTypes;
    }

    public DataAbstractTypeFilter getFilterAbstractType() {
        return this.filterAbstractType;
    }

    @Override
    public LabelProvider getDefaultLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public ViewerSorter getDefaultSorter() {
        return this.nameSorter;
    }

    @Override
    protected void loadIcons() {
        try {
            super.loadIcons();
            this.icons.put("DataModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/DataModel.png"), (boolean)true)));
            this.icons.put("AbstractType", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/a_type.png"), (boolean)true)));
            this.icons.put("ConcreteType", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/c_type.png"), (boolean)true)));
            this.icons.put("PrimitiveAttribute", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/p_attr.png"), (boolean)true)));
            this.icons.put("ExtensionAttribute", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/ProcessModel.png"), (boolean)true)));
            this.icons.put("ComplexAttribute", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/c_attr1.png"), (boolean)true)));
            this.icons.put("ComplexAttributeBi", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/c_attr2.png"), (boolean)true)));
            this.icons.put("EnumLiteral", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/e_attr.png"), (boolean)true)));
            this.icons.put("EnumType", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/e_type.png"), (boolean)true)));
            this.icons.put("ReferencedType", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/r_type.png"), (boolean)true)));
            this.icons.put("ReferencedUserType", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/u_type.png"), (boolean)true)));
            this.icons.put("UserType", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/u_type.png"), (boolean)true)));
            this.icons.put("UserAttribute", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/u_attr.png"), (boolean)true)));
            this.icons.put("AtomicSibLibrary", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/AtomicSibLib.png"), (boolean)true)));
            this.icons.put("AtomicSibLibraryContent", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/r_attr.png"), (boolean)true)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reload() {
        this.storeTreeState();
        this.data.reset();
        this.treeViewer.setInput((Object)this.parentViewPart.getViewSite());
        this.restoreTreeState();
    }

    @Override
    public void openAndHighlight(Object obj) {
        if ((obj = this.getTreeNodeData(obj)) instanceof ModelElement) {
            ModelElement me = (ModelElement)obj;
            IEditorPart iEditorPart = this.openEditor((EObject)me.getRootElement());
        }
        if (obj instanceof GraphModel) {
            this.openEditor((EObject)((GraphModel)obj));
        }
    }

    private class DataAbstractTypeFilter
    extends ViewerFilter {
        private DataAbstractTypeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            parentElement = DataCompPage.this.getTreeNodeData(parentElement);
            return !((element = DataCompPage.this.getTreeNodeData(element)) instanceof AbstractType);
        }
    }

    private class DataLabelProvider
    extends LabelProvider {
        private DataLabelProvider() {
        }

        public String getText(Object obj) {
            if ((obj = DataCompPage.this.getTreeNodeData(obj)) instanceof Data) {
                return DataCompPage.this.data.getModelToResource().get(obj).getName();
            }
            if (obj instanceof ReferencedType) {
                String label = ((ReferencedType)obj).getReferencedType().getName();
                if (DataCompPage.this.showInheritanceInfo && DataCompPage.this.data.getUtils().getSuperType((Type)((ReferencedType)obj).getReferencedType()) != null) {
                    label = String.valueOf(label) + " <" + DataCompPage.this.data.getUtils().getSuperType((Type)((ReferencedType)obj).getReferencedType()).getName() + ">";
                }
                return label;
            }
            if (obj instanceof ReferencedUserType) {
                String label = ((ReferencedUserType)obj).getReferencedType().getName();
                if (DataCompPage.this.showInheritanceInfo && DataCompPage.this.data.getUtils().getSuperType((Type)((ReferencedUserType)obj).getReferencedType()) != null) {
                    label = String.valueOf(label) + " <" + DataCompPage.this.data.getUtils().getSuperType((Type)((ReferencedUserType)obj).getReferencedType()).getName() + ">";
                }
                return label;
            }
            if (obj instanceof Type) {
                String label = ((Type)obj).getName();
                if (DataCompPage.this.showInheritanceInfo && DataCompPage.this.data.getUtils().getSuperType((Type)obj) != null) {
                    label = String.valueOf(label) + " <" + DataCompPage.this.data.getUtils().getSuperType((Type)obj).getName() + ">";
                }
                return label;
            }
            if (obj instanceof ReferencedPrimitiveAttribute) {
                ReferencedPrimitiveAttribute pa = (ReferencedPrimitiveAttribute)obj;
                String label = String.valueOf(pa.getName()) + " : ";
                String type = pa.getReferencedAttribute().getDataType().getLiteral();
                if (pa.isIsList()) {
                    type = "[" + type + "]";
                }
                label = String.valueOf(label) + type;
                if (DataCompPage.this.showInheritanceInfo && DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)pa) != null) {
                    label = String.valueOf(label) + " <" + DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)pa).getName() + ">";
                }
                return label;
            }
            if (obj instanceof ReferencedExtensionAttribute) {
                ReferencedExtensionAttribute pa = (ReferencedExtensionAttribute)obj;
                String label = String.valueOf(pa.getName()) + " : ";
                String type = pa.getReferencedAttribute().getDataType();
                if (pa.isIsList()) {
                    type = "[" + type + "]";
                }
                label = String.valueOf(label) + type;
                if (DataCompPage.this.showInheritanceInfo && DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)pa) != null) {
                    label = String.valueOf(label) + " <" + DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)pa).getName() + ">";
                }
                return label;
            }
            if (obj instanceof PrimitiveAttribute) {
                PrimitiveAttribute pa = (PrimitiveAttribute)obj;
                String label = String.valueOf(pa.getName()) + " : ";
                String type = pa.getDataType().getLiteral();
                if (pa.isIsList()) {
                    type = "[" + type + "]";
                }
                label = String.valueOf(label) + type;
                if (DataCompPage.this.showInheritanceInfo && DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)pa) != null) {
                    label = String.valueOf(label) + " <" + DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)pa).getName() + ">";
                }
                return label;
            }
            if (obj instanceof ExtensionAttribute) {
                ExtensionAttribute pa = (ExtensionAttribute)obj;
                String label = String.valueOf(pa.getName()) + " : ";
                String type = pa.getDataType();
                if (pa.isIsList()) {
                    type = "[" + type + "]";
                }
                label = String.valueOf(label) + type;
                if (DataCompPage.this.showInheritanceInfo && DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)pa) != null) {
                    label = String.valueOf(label) + " <" + DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)pa).getName() + ">";
                }
                return label;
            }
            if (obj instanceof ReferencedComplexAttribute) {
                ReferencedComplexAttribute ca = (ReferencedComplexAttribute)obj;
                String label = String.valueOf(ca.getName()) + " : ";
                String type = ca.getReferencedAttribute().getDataType().getName();
                if (ca.isIsList()) {
                    type = "[" + type + "]";
                }
                label = String.valueOf(label) + type;
                if (DataCompPage.this.showInheritanceInfo && DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)ca) != null) {
                    label = String.valueOf(label) + " <" + DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)ca).getName() + ">";
                }
                return label;
            }
            if (obj instanceof ReferencedBidirectionalAttribute) {
                ReferencedBidirectionalAttribute ca = (ReferencedBidirectionalAttribute)obj;
                String label = String.valueOf(ca.getName()) + " : ";
                String type = ca.getReferencedAttribute().getDataType().getName();
                if (ca.isIsList()) {
                    type = "[" + type + "]";
                }
                label = String.valueOf(label) + type;
                if (DataCompPage.this.showInheritanceInfo && DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)ca) != null) {
                    label = String.valueOf(label) + " <" + DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)ca).getName() + ">";
                }
                return label;
            }
            if (obj instanceof ReferencedUserAttribute) {
                ReferencedUserAttribute ca = (ReferencedUserAttribute)obj;
                String label = String.valueOf(ca.getName()) + " : ";
                String type = ca.getReferencedAttribute().getDataType().getName();
                if (ca.isIsList()) {
                    type = "[" + type + "]";
                }
                label = String.valueOf(label) + type;
                if (DataCompPage.this.showInheritanceInfo && DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)ca) != null) {
                    label = String.valueOf(label) + " <" + DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)ca).getName() + ">";
                }
                return label;
            }
            if (obj instanceof ComplexAttribute) {
                ComplexAttribute ca = (ComplexAttribute)obj;
                String label = String.valueOf(ca.getName()) + " : ";
                String type = ca.getDataType().getName();
                if (ca.isIsList()) {
                    type = "[" + type + "]";
                }
                label = String.valueOf(label) + type;
                if (DataCompPage.this.showInheritanceInfo && DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)ca) != null) {
                    label = String.valueOf(label) + " <" + DataCompPage.this.data.getUtils().getTypeForAttribute((Attribute)ca).getName() + ">";
                }
                return label;
            }
            if (obj instanceof ReferencedEnumType) {
                ReferencedEnumType el = (ReferencedEnumType)obj;
                String label = el.getReferencedType().getName();
                return label;
            }
            if (obj instanceof EnumLiteral) {
                EnumLiteral el = (EnumLiteral)obj;
                String label = el.getName();
                return label;
            }
            if (obj instanceof SIBLibrary) {
                return DataCompPage.this.data.getModelToResource().get(obj).getName();
            }
            if (obj instanceof info.scce.dime.siblibrary.Type) {
                return ((info.scce.dime.siblibrary.Type)obj).getName();
            }
            return "unknown";
        }

        public Image getImage(Object obj) {
            if ((obj = DataCompPage.this.getTreeNodeData(obj)) instanceof Data) {
                return (Image)DataCompPage.this.icons.get("DataModel");
            }
            if (obj instanceof AbstractType) {
                return (Image)DataCompPage.this.icons.get("AbstractType");
            }
            if (obj instanceof ConcreteType) {
                return (Image)DataCompPage.this.icons.get("ConcreteType");
            }
            if (obj instanceof PrimitiveAttribute) {
                return (Image)DataCompPage.this.icons.get("PrimitiveAttribute");
            }
            if (obj instanceof ExtensionAttribute) {
                return (Image)DataCompPage.this.icons.get("ExtensionAttribute");
            }
            if (obj instanceof ReferencedExtensionAttribute) {
                return (Image)DataCompPage.this.icons.get("ExtensionAttribute");
            }
            if (obj instanceof ComplexAttribute) {
                switch (DataCompPage.this.data.getUtils().getAssociationTypeFromAttribute((ComplexAttribute)obj)) {
                    default: {
                        return (Image)DataCompPage.this.icons.get("ComplexAttribute");
                    }
                    case BIDIRECTIONAL: {
                        return (Image)DataCompPage.this.icons.get("ComplexAttributeBi");
                    }
                    case USER: 
                }
                return (Image)DataCompPage.this.icons.get("UserAttribute");
            }
            if (obj instanceof EnumType) {
                return (Image)DataCompPage.this.icons.get("EnumType");
            }
            if (obj instanceof EnumLiteral) {
                return (Image)DataCompPage.this.icons.get("EnumLiteral");
            }
            if (obj instanceof ReferencedType) {
                return (Image)DataCompPage.this.icons.get("ReferencedType");
            }
            if (obj instanceof ReferencedUserType) {
                return (Image)DataCompPage.this.icons.get("ReferencedUserType");
            }
            if (obj instanceof UserType) {
                return (Image)DataCompPage.this.icons.get("UserType");
            }
            if (obj instanceof SIBLibrary) {
                return (Image)DataCompPage.this.icons.get("AtomicSibLibrary");
            }
            if (obj instanceof info.scce.dime.siblibrary.Type) {
                return (Image)DataCompPage.this.icons.get("AtomicSibLibraryContent");
            }
            return null;
        }
    }

    private class DataNameSorter
    extends ViewerSorter {
        private DataNameSorter() {
        }

        public int category(Object element) {
            if (element instanceof Data) {
                return 3;
            }
            if (element instanceof Type) {
                return 2;
            }
            if (element instanceof Attribute) {
                return 1;
            }
            if (element instanceof SIBLibrary) {
                return 3;
            }
            if (element instanceof info.scce.dime.siblibrary.Type) {
                return 2;
            }
            return 4;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            e1 = DataCompPage.this.getTreeNodeData(e1);
            e2 = DataCompPage.this.getTreeNodeData(e2);
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof Data && e2 instanceof Data) {
                IResource res1 = DataCompPage.this.data.getModelToResource().get(e1);
                IResource res2 = DataCompPage.this.data.getModelToResource().get(e2);
                return res1.getName().toLowerCase().compareTo(res2.getName().toLowerCase());
            }
            if (e1 instanceof Type && e2 instanceof Type) {
                Type type1 = (Type)e1;
                Type type2 = (Type)e2;
                return type1.getName().toLowerCase().compareTo(type2.getName().toLowerCase());
            }
            if (e1 instanceof Attribute && e2 instanceof Attribute) {
                Attribute attr1 = (Attribute)e1;
                Attribute attr2 = (Attribute)e2;
                return attr1.getName().toLowerCase().compareTo(attr2.getName().toLowerCase());
            }
            if (e1 instanceof SIBLibrary && e2 instanceof SIBLibrary) {
                IResource res1 = DataCompPage.this.data.getModelToResource().get(e1);
                IResource res2 = DataCompPage.this.data.getModelToResource().get(e2);
                return res1.getName().toLowerCase().compareTo(res2.getName().toLowerCase());
            }
            if (e1 instanceof info.scce.dime.siblibrary.Type && e2 instanceof info.scce.dime.siblibrary.Type) {
                info.scce.dime.siblibrary.Type type1 = (info.scce.dime.siblibrary.Type)e1;
                info.scce.dime.siblibrary.Type type2 = (info.scce.dime.siblibrary.Type)e2;
                return type1.getName().toLowerCase().compareTo(type2.getName().toLowerCase());
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

