/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.pages;

import graphmodel.GraphModel;
import graphmodel.ModelElement;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.data.data.Type;
import info.scce.dime.gUIPlugin.AbstractParameter;
import info.scce.dime.gUIPlugin.ComplexInputParameter;
import info.scce.dime.gUIPlugin.Function;
import info.scce.dime.gUIPlugin.Output;
import info.scce.dime.gUIPlugin.Plugin;
import info.scce.dime.gUIPlugin.Plugins;
import info.scce.dime.gUIPlugin.PrimitiveInputParameter;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.ProcessSIB;
import info.scce.dime.libcompviews.nodes.Category;
import info.scce.dime.libcompviews.pages.LibCompPage;
import info.scce.dime.libcompviews.provider.ControlCompTreeProvider;
import info.scce.dime.libcompviews.provider.LibCompTreeProvider;
import info.scce.dime.libcompviews.utils.LibCompUtils;
import info.scce.dime.modeltrafo.extensionpoint.ModeltrafoExtensionProvider;
import info.scce.dime.modeltrafo.extensionpoint.trafosupport.IModeltrafoSupporter;
import info.scce.dime.process.process.BlueprintSIB;
import info.scce.dime.process.process.EntryPointProcessSIB;
import info.scce.dime.process.process.GUIBlueprintSIB;
import info.scce.dime.process.process.NativeFrontendSIB;
import info.scce.dime.process.process.Process;
import info.scce.dime.process.process.ProcessBlueprintSIB;
import info.scce.dime.search.search.Search;
import info.scce.dime.siblibrary.Branch;
import info.scce.dime.siblibrary.DataTypePort;
import info.scce.dime.siblibrary.JavaTypePort;
import info.scce.dime.siblibrary.Port;
import info.scce.dime.siblibrary.PrimitivePort;
import info.scce.dime.siblibrary.SIB;
import info.scce.dime.siblibrary.SIBLibrary;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ControlCompPage
extends LibCompPage {
    private ControlCompTreeProvider data = new ControlCompTreeProvider();
    private HashMap<String, Image> icons = new HashMap();
    private boolean showOnlyAllowedTypes = false;
    private ControlLabelProvider labelProvider = new ControlLabelProvider();
    private ControlNameSorter nameSorter = new ControlNameSorter();
    private ControlModelTypeFilter modelTypeFilter = new ControlModelTypeFilter();
    private ArrayList<LibCompTreeProvider.ModelType> hideModelTypes = new ArrayList();

    @Override
    public ControlCompTreeProvider getDataProvider() {
        return this.data;
    }

    public boolean isShowOnlyAllowedTypes() {
        return this.showOnlyAllowedTypes;
    }

    public void setShowOnlyAllowedTypes(boolean showOnlyAllowedTypes) {
        this.showOnlyAllowedTypes = showOnlyAllowedTypes;
    }

    public ArrayList<LibCompTreeProvider.ModelType> getHideModelTypes() {
        return this.hideModelTypes;
    }

    @Override
    public LabelProvider getDefaultLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public ViewerSorter getDefaultSorter() {
        return this.nameSorter;
    }

    public ControlModelTypeFilter getModelTypeFilter() {
        return this.modelTypeFilter;
    }

    @Override
    protected void loadIcons() {
        try {
            super.loadIcons();
            this.icons.put("Folder", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
            this.icons.put("DadModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/dime16.png"), (boolean)true)));
            this.icons.put("ProcessModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/ProcessModel.png"), (boolean)true)));
            this.icons.put("EntryPointSIB", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/entryProcessSIB16.png"), (boolean)true)));
            this.icons.put("GuiModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/GUI.png"), (boolean)true)));
            this.icons.put("SearchModel", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/SearchModel.png"), (boolean)true)));
            this.icons.put("ProcessBlueprintSIB", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/processBlueprintSIB16.png"), (boolean)true)));
            this.icons.put("GUIBlueprintSIB", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/guiBlueprintSIB16.png"), (boolean)true)));
            this.icons.put("AtomicSibLibrary", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/AtomicSibLib.png"), (boolean)true)));
            this.icons.put("GUIPlugins", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/guiPlugin.png"), (boolean)true)));
            this.icons.put("GUIPlugin", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/gPlugin.png"), (boolean)true)));
            this.icons.put("AtomicSibLibraryContent", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/r_attr.png"), (boolean)true)));
            this.icons.put("ReferencingComponent", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/r_attr.png"), (boolean)true)));
            this.icons.put("NativeFrontendSibLibrary", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/nfsl.png"), (boolean)true)));
            this.icons.put("NativeFrontendSibLibraryContents", new Image((Device)LibCompUtils.getDisplay(), FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("icons/r_attr.png"), (boolean)true)));
            for (IModeltrafoSupporter provider : ModeltrafoExtensionProvider.getAllModeltrafoSupporter()) {
                this.icons.put(provider.getSIBName(), new Image((Device)LibCompUtils.getDisplay(), (InputStream)new FileInputStream(new File(provider.getIconPath()))));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void openAndHighlight(Object obj) {
        if ((obj = this.getTreeNodeData(obj)) instanceof ModelElement) {
            Process wrapper;
            ModelElement me = (ModelElement)obj;
            IEditorPart editorPart = this.openEditor((EObject)me.getRootElement());
            if (me.getRootElement() instanceof Process) {
                wrapper = this.data.getUtils().getProcessWrapperFromEditor(editorPart);
                this.data.getUtils().highlightElement(wrapper, me.getId());
            }
            if (me.getRootElement() instanceof GUI) {
                wrapper = this.data.getUtils().getGuiWrapperFromEditor(editorPart);
                this.data.getUtils().highlightElement((GUI)wrapper, me.getId());
            }
        } else if (obj instanceof EObject) {
            this.openEditor((EObject)obj);
        }
    }

    @Override
    public void reload() {
        this.storeTreeState();
        this.data.reset();
        this.treeViewer.setInput((Object)this.parentViewPart.getViewSite());
        this.restoreTreeState();
    }

    public void calculateModelTypesToHide(IResource res) {
        this.hideModelTypes.clear();
        EObject activeModel = this.data.getEObjectForResource(res);
        LibCompTreeProvider.ModelType modelType = this.data.mapEObjectToType(activeModel);
        List<LibCompTreeProvider.ModelType> allowedTypes = this.data.getAllowedModels().get((Object)modelType);
        LibCompTreeProvider.ModelType[] modelTypeArray = LibCompTreeProvider.ModelType.values();
        int n = modelTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LibCompTreeProvider.ModelType type = modelTypeArray[n2];
            if (allowedTypes == null || !allowedTypes.contains((Object)type)) {
                this.hideModelTypes.add(type);
            }
            ++n2;
        }
    }

    private class ControlLabelProvider
    extends LabelProvider {
        private ControlLabelProvider() {
        }

        public String getText(Object obj) {
            String label;
            NativeFrontendSIB sib;
            EObject eObject;
            IModeltrafoSupporter provider;
            if ((obj = ControlCompPage.this.getTreeNodeData(obj)) instanceof Category) {
                return ((Category)obj).getName();
            }
            if (obj instanceof IFolder) {
                return ((IFolder)obj).getName();
            }
            if (obj instanceof IFile) {
                return ((IFile)obj).getName();
            }
            if (obj instanceof EObject && (provider = ModeltrafoExtensionProvider.getSupportedModelElement((EObject)(eObject = (EObject)obj))) != null) {
                return provider.getModellingProvider().getLabel(eObject);
            }
            if (obj instanceof GraphModel) {
                String label2 = ControlCompPage.this.data.getModelToResource().get(obj).getName();
                return label2;
            }
            if (obj instanceof NativeFrontendSIB) {
                sib = (NativeFrontendSIB)obj;
                return String.valueOf(sib.getLabel()) + " " + sib.getMethodName();
            }
            if (obj instanceof EntryPointProcessSIB) {
                sib = (info.scce.dime.process.process.SIB)obj;
                return sib.getLabel();
            }
            if (obj instanceof BlueprintSIB) {
                sib = (BlueprintSIB)obj;
                return sib.getLabel();
            }
            if (obj instanceof info.scce.dime.process.process.SIB) {
                sib = (info.scce.dime.process.process.SIB)obj;
                Process process = sib.getRootElement();
                return String.valueOf(sib.getLabel()) + " (" + process.getModelName() + ")";
            }
            if (obj instanceof ProcessSIB) {
                GUI gui = ((ProcessSIB)obj).getRootElement();
                return String.valueOf(gui.getTitle()) + " (Embedded Process)";
            }
            if (obj instanceof SIBLibrary) {
                return ControlCompPage.this.data.getModelToResource().get(obj).getName();
            }
            if (obj instanceof SIB) {
                sib = (SIB)obj;
                label = sib.getName();
                if (sib.getInputPorts().size() > 0) {
                    label = String.valueOf(label) + " ( ";
                    for (Port port : sib.getInputPorts()) {
                        if (port instanceof PrimitivePort) {
                            label = String.valueOf(label) + ((PrimitivePort)port).getType();
                        }
                        if (port instanceof JavaTypePort) {
                            label = String.valueOf(label) + ((JavaTypePort)port).getType().getName();
                        }
                        if (port instanceof DataTypePort) {
                            EObject type = ((DataTypePort)port).getType();
                            label = type instanceof Type ? String.valueOf(label) + ((Type)type).getName() : String.valueOf(label) + "DataType";
                        }
                        label = String.valueOf(label) + " ";
                    }
                    label = String.valueOf(label) + ")";
                }
                label = String.valueOf(label) + " -> |";
                for (Branch branch : sib.getBranches()) {
                    label = String.valueOf(label) + branch.getName() + "|";
                }
                return label;
            }
            if (obj instanceof Plugins) {
                return ControlCompPage.this.data.getModelToResource().get(obj).getName();
            }
            if (obj instanceof Plugin) {
                return ((Plugin)obj).getPath();
            }
            if (obj instanceof Function) {
                sib = (Function)obj;
                label = sib.getFunctionName();
                if (sib.getParameters().size() > 0) {
                    label = String.valueOf(label) + " ( ";
                    for (AbstractParameter port : sib.getParameters()) {
                        label = port instanceof ComplexInputParameter ? String.valueOf(label) + ((ComplexInputParameter)port).getParameter().getName() + " " : (port instanceof PrimitiveInputParameter ? String.valueOf(label) + ((PrimitiveInputParameter)port).getParameter().getName() + " " : String.valueOf(label) + port.getName() + " ");
                    }
                    label = String.valueOf(label) + ")";
                }
                if (sib.getOutputs().size() > 0) {
                    label = String.valueOf(label) + " -> |";
                    for (Output branch : sib.getOutputs()) {
                        label = String.valueOf(label) + branch.getOutputName() + "|";
                    }
                }
                return label;
            }
            if (obj instanceof info.scce.dime.siblibrary.Type) {
                return ((info.scce.dime.siblibrary.Type)obj).getName();
            }
            return "unknown";
        }

        public Image getImage(Object obj) {
            EObject eObject;
            IModeltrafoSupporter provider;
            IFile ifile;
            if ((obj = ControlCompPage.this.getTreeNodeData(obj)) instanceof IFolder) {
                return (Image)ControlCompPage.this.icons.get("Folder");
            }
            if (obj instanceof IFile && (ifile = (IFile)obj).getFileExtension() != null) {
                IModeltrafoSupporter provider2 = ModeltrafoExtensionProvider.getSupportedModelElement((String)ifile.getFileExtension());
                return (Image)ControlCompPage.this.icons.get(provider2.getSIBName());
            }
            if (obj instanceof EObject && (provider = ModeltrafoExtensionProvider.getSupportedModelElement((EObject)(eObject = (EObject)obj))) != null) {
                return (Image)ControlCompPage.this.icons.get(provider.getSIBName());
            }
            if (obj instanceof DAD) {
                return (Image)ControlCompPage.this.icons.get("DadModel");
            }
            if (obj instanceof Plugins) {
                return (Image)ControlCompPage.this.icons.get("GUIPlugins");
            }
            if (obj instanceof Plugin) {
                return (Image)ControlCompPage.this.icons.get("GUIPlugin");
            }
            if (obj instanceof Function) {
                return (Image)ControlCompPage.this.icons.get("AtomicSibLibraryContent");
            }
            if (obj instanceof GUI) {
                return (Image)ControlCompPage.this.icons.get("GuiModel");
            }
            if (obj instanceof Search) {
                return (Image)ControlCompPage.this.icons.get("SearchModel");
            }
            if (obj instanceof Process) {
                return (Image)ControlCompPage.this.icons.get("ProcessModel");
            }
            if (obj instanceof EntryPointProcessSIB) {
                return (Image)ControlCompPage.this.icons.get("EntryPointSIB");
            }
            if (obj instanceof info.scce.dime.process.process.SIB) {
                return (Image)ControlCompPage.this.icons.get("ReferencingComponent");
            }
            if (obj instanceof ProcessSIB) {
                return (Image)ControlCompPage.this.icons.get("ReferencingComponent");
            }
            if (obj instanceof ProcessBlueprintSIB) {
                return (Image)ControlCompPage.this.icons.get("ProcessBlueprintSIB");
            }
            if (obj instanceof GUIBlueprintSIB) {
                return (Image)ControlCompPage.this.icons.get("GUIBlueprintSIB");
            }
            if (obj instanceof info.scce.dime.process.process.SIB) {
                return (Image)ControlCompPage.this.icons.get("ReferencingComponent");
            }
            if (obj instanceof SIBLibrary) {
                return (Image)ControlCompPage.this.icons.get("AtomicSibLibrary");
            }
            if (obj instanceof NativeFrontendSIB) {
                return (Image)ControlCompPage.this.icons.get("NativeFrontendSibLibraryContents");
            }
            if (obj instanceof SIB) {
                return (Image)ControlCompPage.this.icons.get("AtomicSibLibraryContent");
            }
            if (obj instanceof Category) {
                Category cat = (Category)obj;
                Object typeObj = cat.getType();
                if (typeObj instanceof LibCompTreeProvider.ModelType) {
                    LibCompTreeProvider.ModelType type = (LibCompTreeProvider.ModelType)((Object)typeObj);
                    switch (type) {
                        case SEARCH: {
                            return (Image)ControlCompPage.this.icons.get("SearchModel");
                        }
                        case SIBLIBRARY: {
                            return (Image)ControlCompPage.this.icons.get("AtomicSibLibrary");
                        }
                        case NATIVE_FRONTEND_LIBRARY: {
                            return (Image)ControlCompPage.this.icons.get("NativeFrontendSibLibrary");
                        }
                        case PROCESS: 
                        case PROCESS_BASIC: 
                        case PROCESS_LONGRUNNING: 
                        case PROCESS_SECURITY: {
                            return (Image)ControlCompPage.this.icons.get("ProcessModel");
                        }
                    }
                } else if (ControlCompPage.this.icons.get(cat.getName()) != null) {
                    return (Image)ControlCompPage.this.icons.get(cat.getName());
                }
            }
            return null;
        }
    }

    private class ControlModelTypeFilter
    extends ViewerFilter {
        private ControlModelTypeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            parentElement = ControlCompPage.this.getTreeNodeData(parentElement);
            return !((element = ControlCompPage.this.getTreeNodeData(element)) instanceof EObject) || !ControlCompPage.this.hideModelTypes.contains((Object)ControlCompPage.this.data.mapEObjectToType((EObject)element));
        }
    }

    private class ControlNameSorter
    extends ViewerSorter {
        private ControlNameSorter() {
        }

        public int category(Object element) {
            if (element instanceof IFolder) {
                return 1;
            }
            if (element instanceof GraphModel) {
                return 2;
            }
            if (element instanceof SIBLibrary) {
                return 3;
            }
            if (element instanceof info.scce.dime.siblibrary.Type) {
                return 4;
            }
            if (element instanceof SIB) {
                return 5;
            }
            if (element instanceof Plugins) {
                return 6;
            }
            return 99;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            e1 = ControlCompPage.this.getTreeNodeData(e1);
            e2 = ControlCompPage.this.getTreeNodeData(e2);
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof EObject && e2 instanceof EObject) {
                IResource res1 = ControlCompPage.this.data.getModelToResource().get(e1);
                IResource res2 = ControlCompPage.this.data.getModelToResource().get(e2);
                if (res1 != null && res2 != null) {
                    return res1.getName().toLowerCase().compareTo(res2.getName().toLowerCase());
                }
            }
            if (e1 instanceof IFolder && e2 instanceof IFolder) {
                IFolder folder1 = (IFolder)e1;
                IFolder folder2 = (IFolder)e2;
                return folder1.getName().toLowerCase().compareTo(folder2.getName().toLowerCase());
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

