/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews.nodes;

import java.util.ArrayList;
import java.util.List;

public abstract class TreeNode {
    protected Object data = null;
    private TreeNode parent = null;
    private List<TreeNode> children = new ArrayList<TreeNode>();

    TreeNode(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode> children) {
        this.children = children;
    }

    public abstract String getId();

    public String getPathIdentifier() {
        String ident = this.getId();
        if (this.parent != null) {
            ident = String.valueOf(this.parent.getPathIdentifier()) + "/" + ident;
        }
        return ident;
    }

    public TreeNode find(String id) {
        if (id.equals(this.getId())) {
            return this;
        }
        for (TreeNode child : this.children) {
            TreeNode result = child.find(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String toString() {
        String output = "TreeNode of: " + this.data + "\n";
        for (TreeNode treeNode : this.children) {
            output = String.valueOf(output) + " - " + treeNode.toString();
        }
        return output;
    }
}

