/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.libcompviews;

import info.scce.dime.libcompviews.pages.LibCompPage;
import info.scce.dime.libcompviews.views.LibCompView;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;

public class ResourceChangeListener
implements IResourceChangeListener {
    private final LibCompView view;
    private Map<String, Set<ListenerEvents>> obsDefinition;
    private Set<ListenerEvents> events;

    public ResourceChangeListener(LibCompView view, Map<String, Set<ListenerEvents>> obsDefinition) {
        this.view = view;
        this.obsDefinition = obsDefinition;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        Object obj;
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        IFile iFile = this.getFileFromDelta(delta);
        if (iFile == null || !this.obsDefinition.keySet().contains(iFile.getFileExtension())) {
            return;
        }
        this.getActualListenerEvents(event);
        HashSet retainSet = new HashSet(this.obsDefinition.get(iFile.getFileExtension()));
        retainSet.retainAll(this.events);
        if (retainSet.size() < 1) {
            return;
        }
        String projectName = this.getProjectNameFromDelta(event.getDelta());
        if (projectName != null && (obj = this.view.getPageMap().get(projectName)) instanceof LibCompPage) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((LibCompPage)obj).reload();
                    ResourceChangeListener.this.view.refreshView();
                }
            });
        }
    }

    private String getProjectNameFromDelta(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            IResource res = child.getResource();
            if (res instanceof IProject) {
                return ((IProject)res).getName();
            }
            if (res instanceof IFile) {
                IFile file = (IFile)res;
                return file.getProject().getName();
            }
            ++n2;
        }
        return null;
    }

    private void getActualListenerEvents(IResourceChangeEvent event) {
        this.events = new HashSet<ListenerEvents>();
        IResource res = event.getResource();
        switch (event.getType()) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 8: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 16: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter());
                    break;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private IFile getFileFromDelta(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        if (iResourceDeltaArray.length != 0) {
            IResourceDelta child = iResourceDeltaArray[0];
            IResource res = child.getResource();
            if (res instanceof IFile) {
                IFile file = (IFile)res;
                return file;
            }
            return this.getFileFromDelta(child);
        }
        return null;
    }

    public class DeltaPrinter
    implements IResourceDeltaVisitor {
        public boolean visit(IResourceDelta delta) {
            IResource res = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    ResourceChangeListener.this.events.add(ListenerEvents.ADDED);
                    break;
                }
                case 2: {
                    ResourceChangeListener.this.events.add(ListenerEvents.REMOVED);
                    break;
                }
                case 4: {
                    int flags = delta.getFlags();
                    if ((flags & 0x100) != 0) {
                        ResourceChangeListener.this.events.add(ListenerEvents.CONTENT_CHANGE);
                    }
                    if ((flags & 0x20000) == 0) break;
                    IMarkerDelta[] iMarkerDeltaArray = delta.getMarkerDeltas();
                }
            }
            return true;
        }
    }

    public static enum ListenerEvents {
        ADDED,
        REMOVED,
        CONTENT_CHANGE;

    }
}

