/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.siblibrary.validation;

import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import info.scce.dime.siblibrary.Import;
import info.scce.dime.siblibrary.SIB;
import info.scce.dime.siblibrary.SIBLibraryPackage;
import info.scce.dime.siblibrary.validation.AbstractSIBLibraryValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class SIBLibraryValidator
extends AbstractSIBLibraryValidator {
    @Extension
    protected ResourceExtension _resourceExtension = new ResourceExtension();

    @Check
    public void checkImport(Import it) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getPath());
        if (_isNullOrEmpty) {
            this.error("No path specified", (EStructuralFeature)SIBLibraryPackage.Literals.IMPORT__PATH);
        } else {
            boolean _not;
            Resource _eResource = it.eResource();
            IProject _project = null;
            if (_eResource != null) {
                _project = this._resourceExtension.getProject(_eResource);
            }
            IFile _file = null;
            if (_project != null) {
                _file = _project.getFile(it.getPath());
            }
            boolean _exists = false;
            if (_file != null) {
                _exists = _file.exists();
            }
            boolean bl = _not = !_exists;
            if (_not) {
                this.error("The specified file does not exist", (EStructuralFeature)SIBLibraryPackage.Literals.IMPORT__PATH);
            }
        }
    }

    @Check
    public void checkSIB(SIB sib) {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)sib.getIconPath());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            boolean _not_1;
            IFile file = this._resourceExtension.getProject(sib.eResource()).getFile(sib.getIconPath());
            boolean _exists = file.exists();
            boolean bl2 = _not_1 = !_exists;
            if (_not_1) {
                this.error("The specified file does not exist", (EStructuralFeature)SIBLibraryPackage.Literals.SIB__ICON_PATH);
            }
        }
    }
}

