/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.siblibrary;

import com.google.inject.Inject;
import graphmodel.internal.InternalIdentifiableElement;
import info.scce.dime.siblibrary.AbstractSIBLibraryRuntimeModule;
import info.scce.dime.siblibrary.Package;
import info.scce.dime.siblibrary.SIB;
import info.scce.dime.siblibrary.SIBLibrary;
import info.scce.dime.siblibrary.SIBLibraryValueConverterService;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.linking.ILinker;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.linking.impl.Linker;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.DefaultEcoreElementFactory;
import org.eclipse.xtext.parser.IAstFactory;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class SIBLibraryRuntimeModule
extends AbstractSIBLibraryRuntimeModule {
    public Class<? extends IAstFactory> bindIAstFactory() {
        return MyAstFactory.class;
    }

    public Class<? extends IValueConverterService> bindIValueConverterService() {
        return SIBLibraryValueConverterService.class;
    }

    public Class<? extends ILinker> bindILinker() {
        return GUIPluginLinker.class;
    }

    public Class<? extends ILinkingService> bindILinkingService() {
        return SIBLibraryPluginLinkingService.class;
    }

    public static class GUIPluginLinker
    extends Linker {
        protected boolean isClearAllReferencesRequired(Resource resource) {
            return false;
        }
    }

    static class MyAstFactory
    extends DefaultEcoreElementFactory {
        MyAstFactory() {
        }

        public void add(EObject object, String feature, Object value, String ruleName, INode node) throws ValueConverterException {
            if (node.getSemanticElement() instanceof SIB) {
                try {
                    SIB sib = (SIB)node.getSemanticElement();
                    if (object instanceof SIBLibrary) {
                        SIBLibrary sibLib = (SIBLibrary)object;
                        Package pkg = sibLib.getPackage();
                        String sibId = String.valueOf(pkg.getName()) + "." + sib.getName();
                        sib.setId(sibId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            super.add(object, feature, value, ruleName, node);
        }
    }

    public static class SIBLibraryPluginLinkingService
    extends DefaultLinkingService {
        @Inject
        private IQualifiedNameConverter qualifiedNameConverter;

        public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
            QualifiedName qualifiedLinkName;
            String crossRefString = this.getCrossRefNodeAsString(node);
            if (crossRefString == null || crossRefString.isEmpty()) {
                return Collections.emptyList();
            }
            IScope scope = this.getScope(context, ref);
            IEObjectDescription eObjectDescription = scope.getSingleElement(qualifiedLinkName = this.qualifiedNameConverter.toQualifiedName(crossRefString));
            if (eObjectDescription == null) {
                crossRefString = String.valueOf(crossRefString) + "_INTERNAL";
                qualifiedLinkName = this.qualifiedNameConverter.toQualifiedName(crossRefString);
                eObjectDescription = scope.getSingleElement(qualifiedLinkName);
            }
            if (eObjectDescription != null) {
                EObject eObj = eObjectDescription.getEObjectOrProxy();
                if (eObj instanceof InternalIdentifiableElement) {
                    eObj = ((InternalIdentifiableElement)eObj).getElement();
                }
                return Collections.singletonList(eObj);
            }
            return Collections.emptyList();
        }
    }
}

