/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.executer.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ProjectCreator {
    public static IProject createProject(String projectName, List<String> srcFolders, List<IProject> referencedProjects, Set<String> requiredBundles, List<String> exportedPackages, List<String> additionalNatures, IProgressMonitor progressMonitor, boolean askIfDel, String pluginContent) {
        return ProjectCreator.createProject(projectName, srcFolders, referencedProjects, requiredBundles, exportedPackages, additionalNatures, progressMonitor, null, askIfDel, pluginContent);
    }

    public static IProject createProject(String projectName, List<String> srcFolders, List<IProject> referencedProjects, Set<String> requiredBundles, List<String> exportedPackages, List<String> additionalNatures, IProgressMonitor progressMonitor, boolean askIfDel) {
        return ProjectCreator.createProject(projectName, srcFolders, referencedProjects, requiredBundles, exportedPackages, additionalNatures, progressMonitor, null, askIfDel, null);
    }

    public static IProject createProject(String projectName, List<String> srcFolders, List<IProject> referencedProjects, Set<String> requiredBundles, List<String> exportedPackages, List<String> additionalNatures, IProgressMonitor progressMonitor) {
        return ProjectCreator.createProject(projectName, srcFolders, referencedProjects, requiredBundles, exportedPackages, additionalNatures, progressMonitor, null, true, null);
    }

    public static IProject createProject(final String projectName, List<String> srcFolders, List<IProject> referencedProjects, Set<String> requiredBundles, List<String> exportedPackages, List<String> additionalNatures, IProgressMonitor progressMonitor, List<String> cleanDirs, boolean askIfDelete, String pluginContent) {
        IProject project = null;
        try {
            progressMonitor.beginTask("", 10);
            progressMonitor.subTask("Creating project " + projectName);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            project = workspace.getRoot().getProject(projectName);
            if (project.exists()) {
                final boolean[] result = new boolean[]{true};
                if (askIfDelete) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            result[0] = MessageDialog.openQuestion(null, (String)("Do you want to overwrite the project " + projectName), (String)("Note that everything inside the project '" + projectName + "' will be deleted if you confirm this dialog."));
                        }
                    });
                }
                if (result[0]) {
                    if (cleanDirs == null) {
                        project.delete(true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    } else {
                        for (String s : cleanDirs) {
                            IFolder f = project.getFolder(s);
                            if (!f.exists()) continue;
                            f.delete(true, progressMonitor);
                        }
                    }
                } else {
                    return null;
                }
            }
            try {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
                projectDescription.setLocation(null);
                if (!project.exists()) {
                    project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                }
                ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
                if (referencedProjects != null && referencedProjects.size() != 0) {
                    projectDescription.setReferencedProjects(referencedProjects.toArray(new IProject[referencedProjects.size()]));
                    for (IProject referencedProject : referencedProjects) {
                        IClasspathEntry referencedProjectClasspathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                        classpathEntries.add(referencedProjectClasspathEntry);
                    }
                }
                if (additionalNatures != null) {
                    String[] natures = new String[additionalNatures.size() + 2];
                    int i = 0;
                    while (i < additionalNatures.size()) {
                        natures[i] = additionalNatures.get(i);
                        ++i;
                    }
                    natures[additionalNatures.size()] = "org.eclipse.jdt.core.javanature";
                    natures[additionalNatures.size() + 1] = "org.eclipse.pde.PluginNature";
                    projectDescription.setNatureIds(natures);
                } else {
                    projectDescription.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"});
                }
                ICommand java = projectDescription.newCommand();
                java.setBuilderName("org.eclipse.jdt.core.javabuilder");
                ICommand manifest = projectDescription.newCommand();
                manifest.setBuilderName("org.eclipse.pde.ManifestBuilder");
                ICommand schema = projectDescription.newCommand();
                schema.setBuilderName("org.eclipse.pde.SchemaBuilder");
                projectDescription.setBuildSpec(new ICommand[]{java, manifest, schema});
                project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                project.setDescription(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                if (srcFolders != null) {
                    Collections.reverse(srcFolders);
                    for (String src : srcFolders) {
                        IFolder srcContainer = project.getFolder(src);
                        if (!srcContainer.exists()) {
                            srcContainer.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            IPackageFragment iPackageFragment = javaProject.getPackageFragmentRoot((IResource)srcContainer).createPackageFragment(projectName, false, null);
                        }
                        IClasspathEntry srcClasspathEntry = JavaCore.newSourceEntry((IPath)srcContainer.getFullPath());
                        classpathEntries.add(0, srcClasspathEntry);
                    }
                }
                classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-11")));
                classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
                javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                javaProject.setOutputLocation((IPath)new Path("/" + projectName + "/bin"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                if (pluginContent != null) {
                    ProjectCreator.createPlugin(projectName, pluginContent, progressMonitor, project);
                }
                ProjectCreator.createManifest(projectName, requiredBundles, exportedPackages, progressMonitor, project);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            progressMonitor.done();
        }
        return project;
    }

    public static String makeSymbolicName(String projectName) {
        String symbolicName = projectName.replaceAll("[^a-zA-Z0-9_\\-\\.]", "_");
        if (symbolicName.endsWith(".")) {
            symbolicName = String.valueOf(symbolicName.substring(0, symbolicName.lastIndexOf(46))) + "_";
        }
        if (symbolicName.startsWith(".")) {
            symbolicName = "_" + symbolicName.substring(1);
        }
        return symbolicName;
    }

    private static void createPlugin(String projectName, String content, IProgressMonitor progressMonitor, IProject project) throws CoreException {
        StringBuilder plugiContent = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        plugiContent.append("<?eclipse version=\"3.4\"?>\n");
        plugiContent.append("<plugin>\n\n");
        plugiContent.append(content);
        plugiContent.append("\n</plugin>\n");
        ProjectCreator.createFile("plugin.xml", project.getFile("plugin.xml").getParent(), plugiContent.toString(), progressMonitor);
    }

    private static void createManifest(String projectName, Set<String> requiredBundles, List<String> exportedPackages, IProgressMonitor progressMonitor, IProject project) throws CoreException {
        StringBuilder maniContent = new StringBuilder("Manifest-Version: 1.0\n");
        maniContent.append("Bundle-ManifestVersion: 2\n");
        maniContent.append("Bundle-Name: " + projectName + "\n");
        maniContent.append("Bundle-SymbolicName: " + ProjectCreator.makeSymbolicName(projectName) + "; singleton:=true\n");
        maniContent.append("Bundle-Version: 1.0.0\n");
        if (requiredBundles != null) {
            maniContent.append("Require-Bundle: ");
            Iterator<String> it = requiredBundles.iterator();
            while (it.hasNext()) {
                String entry = it.next();
                maniContent.append(" " + entry);
                if (it.hasNext()) {
                    maniContent.append(",\n");
                    continue;
                }
                maniContent.append("\n");
            }
        }
        if (exportedPackages != null && !exportedPackages.isEmpty()) {
            maniContent.append("Export-Package: " + exportedPackages.get(0));
            int i = 1;
            int x = exportedPackages.size();
            while (i < x) {
                maniContent.append(",\n " + exportedPackages.get(i));
                ++i;
            }
            maniContent.append("\n");
        }
        maniContent.append("Bundle-RequiredExecutionEnvironment: JavaSE-11\r\n");
        IFolder metaInf = project.getFolder("META-INF");
        if (!metaInf.exists()) {
            metaInf.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        ProjectCreator.createFile("MANIFEST.MF", (IContainer)metaInf, maniContent.toString(), progressMonitor);
    }

    public static IFile createFile(String name, IContainer container, String content, IProgressMonitor progressMonitor) {
        IFile file = container.getFile((IPath)new Path(name));
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(file.getCharset()));
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, progressMonitor);
            } else {
                file.create((InputStream)stream, true, progressMonitor);
            }
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        progressMonitor.worked(1);
        return file;
    }

    public static String getProjectSymbolicName(IProject project) {
        BundleContext bc = InternalPlatform.getDefault().getBundleContext();
        ServiceReference ref = bc.getServiceReference(IBundleProjectService.class.getName());
        IBundleProjectService service = (IBundleProjectService)bc.getService(ref);
        try {
            IBundleProjectDescription bpd = service.getDescription(project);
            String string = bpd.getSymbolicName();
            return string;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        finally {
            bc.ungetService(ref);
        }
        return "";
    }
}

