/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.executer.generator.tracer;

import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel;
import de.jabc.cinco.meta.plugin.executer.generator.tracer.MainTemplate;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ThreadTemplate
extends MainTemplate {
    public ThreadTemplate(ExecutableGraphmodel graphmodel) {
        super(graphmodel);
    }

    @Override
    public String fileName() {
        return "Thread.java";
    }

    @Override
    public CharSequence create(ExecutableGraphmodel graphmodel) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _tracerPackage = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage);
        _builder.append(".stepper.model;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.LinkedList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import java.util.Queue;");
        _builder.newLine();
        _builder.append("import java.util.Set;");
        _builder.newLine();
        _builder.append("import java.util.stream.Collectors;");
        _builder.newLine();
        _builder.append("import java.util.stream.Stream;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import graphmodel.ModelElement;");
        _builder.newLine();
        _builder.append("import ");
        String _tracerPackage_1 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_1);
        _builder.append(".extension.AbstractContext;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_2 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_2);
        _builder.append(".extension.AbstractSemantic;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_3 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_3);
        _builder.append(".match.model.LTSMatch;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_4 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_4);
        _builder.append(".match.model.Match;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_5 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_5);
        _builder.append(".stepper.utils.ContentView;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_6 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_6);
        _builder.append(".stepper.utils.Highlighter;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_7 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_7);
        _builder.append(".stepper.utils.TracerException;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_8 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_8);
        _builder.append(".stepper.utils.WaitingException;");
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The Thread defines a single instance of a control flow.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* All threads share a global context, which can be separated.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The Thread holds a stack and the history of levels.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author zweihoff");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public final class Thread {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private Level currentLevel;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<Level> levelHistory;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private LinkedList<Level> levelQueue;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<Match> globalHistory;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private AbstractContext context;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private AbstractSemantic semantic;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private Highlighter highlighter;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Creates the History and Stack of levels.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Creates the first level and initializes it with the first modelelement");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param firstGraph The current graphmodel");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param firstElement The first modelelement for execution");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param context The global shared context");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param semantic The gloabel shared semantics");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Thread(LTSMatch firstGraph,Match firstElement, AbstractContext context, AbstractSemantic semantic)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//create the context");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.context = context;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//set semantics");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.semantic = semantic;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//create a highlighter");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.highlighter = new Highlighter();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("levelHistory = new LinkedList<Level>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("levelQueue = new LinkedList<Level>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("globalHistory = new LinkedList<Match>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Level firstLevel = new Level(firstElement,semantic,globalHistory);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("currentLevel = firstLevel;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("levelHistory.add(firstLevel);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("levelQueue.addFirst(firstLevel);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Creates a new level, sets the first element");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* and updates the level stack and history");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param stepResult The StepResult to be executed");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private final void levelDown(StepResult stepResult)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("currentLevel.setCurrenElement(stepResult.getPreElement());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Create new Level");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Level level = new Level(stepResult.getFollowingElement(), semantic,globalHistory);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("levelHistory.add(level);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("levelQueue.addFirst(level);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("currentLevel = level;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Removes the current level, which execution has been ended");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* and goes back to the previous level if available");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param stepResult");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private final boolean levelUp(StepResult stepResult)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("levelQueue.removeFirst();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(levelQueue.isEmpty()){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("//End of Execution on top level");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("currentLevel = levelQueue.getFirst();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final ThreadStepResult doStep(List<Thread> threads) throws TracerException, WaitingException");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ThreadStepResult result = new ThreadStepResult();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("StepResult sr = currentLevel.doStep(this.context,threads);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(sr == null){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("result.setStepResult(sr);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("result.setThread(this);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final boolean executeStep(StepResult stepResult,List<Thread> threads,AbstractSemantic semantic) throws TracerException");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Execute the Step and set the new current Modelelement");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//and synchronize the history");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stepResult = currentLevel.executeStep(stepResult,globalHistory,context);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Spawn new threads if needed");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Add the new threads to the active threads to be executed in parallel");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(Match match:stepResult.getNewElements()){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("semantic.preSpawnNewThread(this);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Thread newThread = new Thread(match.getRoot(),match,context,semantic);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("threads.add(newThread);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("semantic.postSpawnNewThread(newThread);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("System.out.println(stepResult);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//If Level is terminated, look for upper level");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(stepResult.getStepType()==StepType.Terminating){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("semantic.preLeaveLevel(this,currentLevel);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return levelUp(stepResult);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//If new Level is activated, jump to new level");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else if (stepResult.getStepType() == StepType.Level) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("semantic.preEnterNewLevel(this,currentLevel);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("levelDown(stepResult);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("semantic.postEnterNewLevel(this,currentLevel);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final Level getCurrentLevel() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return currentLevel;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setCurrentLevel(Level currentLevel) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.currentLevel = currentLevel;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final List<Level> getLevelHistory() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return levelHistory;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setLevelHistory(LinkedList<Level> levelHistory) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.levelHistory = levelHistory;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final Queue<Level> getLevelQueue() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return levelQueue;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setLevelQueue(LinkedList<Level> levelQueue) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.levelQueue = levelQueue;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final Object[] displayHistory()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<ContentView> result = new LinkedList<ContentView>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(Match match:this.globalHistory){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("result.add(new ContentView(semantic.displayElement(match),match,this));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result.toArray();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void highlightHistory() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.highlighter.highlight(this.globalHistory.stream().flatMap(n->n.getElements().stream()).collect(Collectors.toSet()));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void highlightCurrent() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.highlighter.highlight(this.currentLevel.getCurrenElement().getElements());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final Object[] displayLevel()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<ContentView> result = new LinkedList<ContentView>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(Level l:this.levelQueue){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("result.add(new ContentView(");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("semantic.displayLevel(l.getCurrentContainer().getContainer())+\":\"+semantic.displayElement(l.getCurrenElement()),");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("l.getCurrenElement(),");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("this");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result.toArray();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void highlightLevels()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Set<ModelElement> activeElements = Stream.concat(");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("this.levelQueue.stream().map(n->n.getCurrentContainer().getContainer()).filter(n->n!=null).filter(n->n instanceof ModelElement).map(n->(ModelElement)n),");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("this.levelQueue.stream().flatMap(n->n.getCurrenElement().getElements().stream())");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(").collect(Collectors.toSet());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.highlighter.highlight(activeElements);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final List<Match> getGlobalHistory() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return globalHistory;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setGlobalHistory(List<Match> globalHistory) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.globalHistory = globalHistory;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final AbstractContext getContext() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return context;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setContext(AbstractContext context) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.context = context;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final AbstractSemantic getSemantic() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return semantic;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setSemantic(AbstractSemantic semantic) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.semantic = semantic;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final Highlighter getHighlighter() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return highlighter;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setHighlighter(Highlighter highlighter) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.highlighter = highlighter;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setLevelHistory(List<Level> levelHistory) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.levelHistory = levelHistory;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

