/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.executer.generator.tracer;

import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel;
import de.jabc.cinco.meta.plugin.executer.generator.tracer.MainTemplate;
import org.eclipse.xtend2.lib.StringConcatenation;

public class StepperTemplate
extends MainTemplate {
    public StepperTemplate(ExecutableGraphmodel graphmodel) {
        super(graphmodel);
    }

    @Override
    public String fileName() {
        return "Stepper.java";
    }

    @Override
    public CharSequence create(ExecutableGraphmodel graphmodel) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _tracerPackage = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage);
        _builder.append(".stepper.model;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.Arrays;");
        _builder.newLine();
        _builder.append("import java.util.LinkedList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import org.eclipse.swt.widgets.Shell;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import ");
        String _tracerPackage_1 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_1);
        _builder.append(".extension.AbstractContext;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_2 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_2);
        _builder.append(".extension.AbstractSemantic;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_3 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_3);
        _builder.append(".match.model.LTSMatch;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_4 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_4);
        _builder.append(".match.model.Match;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_5 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_5);
        _builder.append(".stepper.utils.JointTracerException;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_6 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_6);
        _builder.append(".stepper.utils.TracerException;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_7 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_7);
        _builder.append(".stepper.utils.WaitingException;");
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The main class for the execution of a model.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* A single execution step for all active threads in parallel can be triggered ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author zweihoff");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public final class Stepper {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<Thread> activeThreads;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private AbstractSemantic semantic;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Initializes the context");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* and determines all initial modelelements in the graphmodel");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* and creates a new thread for each of them");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param firstGraph");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param shell");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param context");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param semantic");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Stepper(LTSMatch firstGraph, Shell shell, AbstractContext context, AbstractSemantic semantic) throws TracerException");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this(firstGraph,null,shell,context,semantic);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Stepper(LTSMatch firstGraph,List<Match> startingElements, Shell shell, AbstractContext context, AbstractSemantic semantic) throws TracerException");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.semantic = semantic;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("activeThreads = new LinkedList<Thread>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// initialize the context");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(!context.initialize(shell))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("throw new TracerException(\"Context has not been initialized correctly\");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Get starting element");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(startingElements != null){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("for(Match cme:startingElements)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("activeThreads.add(new Thread(firstGraph,cme,context,semantic));");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// ----");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("for(Match cme:firstGraph.getStartStates())");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("activeThreads.add(new Thread(firstGraph,cme,context,semantic));");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// ----");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Executes a single step of execution for each active thread");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Determines the next modelelements.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Deactivates threads, which execution has been ended");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return boolean True, if at least one thread is active. False, if all executions have ended");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @throws JointTracerException If an Illegal state has been reaches");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @throws TracerException ");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final boolean doStep() throws JointTracerException");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return doStep(null);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Executes a single step of execution for each active thread");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Determines the next modelelements.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Deactivates threads, which execution has been ended");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return boolean True, if the at least one thread is active. False, if all executions have ended");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @throws JointTracerException If an Illegal state has been reaches");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @throws TracerException ");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final boolean doStep(Thread thread) throws JointTracerException");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(activeThreads.isEmpty()){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//combined list of tracer exception messages for all ");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<String> tracerExceptionMessages = new LinkedList<String>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<Thread> inactiveThreads = new LinkedList<Thread>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<ThreadStepResult> nextSteps = new LinkedList<ThreadStepResult>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<Thread> executableThreads = this.activeThreads;\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(thread != null){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("executableThreads = Arrays.asList(thread);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Calculate the next steps for all active Threads");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(Thread t:executableThreads){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("ThreadStepResult tsr = t.doStep(activeThreads);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if(tsr == null){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("inactiveThreads.add(t);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("continue;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("nextSteps.add(tsr);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("catch (WaitingException e)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("//No next step is calculated");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("System.out.println(\"Waiting\");");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("catch(TracerException te)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// trigger Hook pre terminate");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("semantic.preTerminateThread(t);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("inactiveThreads.add(t);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("tracerExceptionMessages.add(te.getText());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Check for Deadlock or Termination");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(nextSteps.isEmpty()){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("//All Threads are deactivated before execution.");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(inactiveThreads.size() >= activeThreads.size()){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// if threads has been ended with an exception");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if(!tracerExceptionMessages.isEmpty()){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("throw new JointTracerException(tracerExceptionMessages);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("//Not all Threads are terminated, but no one has done a step");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("throw new JointTracerException(Arrays.asList(\"Deadlock detected\"));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//All next steps has been calculated and can now be executed");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(ThreadStepResult next:nextSteps)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Thread t = next.getThread();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if(!t.executeStep(next.getStepResult(), this.activeThreads,this.semantic))");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("inactiveThreads.add(t);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("System.out.println(\"deactivate: \"+t);\t\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} catch (TracerException e) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("tracerExceptionMessages.add(e.getText());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Reduce active threads by inactive threads");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("activeThreads.removeAll(inactiveThreads);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(!tracerExceptionMessages.isEmpty()){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("throw new JointTracerException(tracerExceptionMessages);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return !activeThreads.isEmpty();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final List<Thread> getActiveThreads() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return activeThreads;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setActiveThreads(List<Thread> activeThreads) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.activeThreads = activeThreads;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final AbstractSemantic getSemantic() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return semantic;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setSemantic(AbstractSemantic semantic) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.semantic = semantic;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

