/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.executer.generator.tracer;

import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel;
import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableNode;
import de.jabc.cinco.meta.plugin.executer.generator.tracer.MainTemplate;
import mgl.Node;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class NodeSimulatorTemplate
extends MainTemplate {
    public NodeSimulatorTemplate(ExecutableGraphmodel graphmodel) {
        super(graphmodel);
    }

    @Override
    public String fileName() {
        return "NodeSimulator.java";
    }

    @Override
    public CharSequence create(ExecutableGraphmodel graphmodel) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _tracerPackage = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage);
        _builder.append(".match.simulation;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.HashSet;");
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.append("import java.util.Set;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import org.eclipse.graphiti.mm.pictograms.Diagram;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import graphmodel.ModelElement;");
        _builder.newLine();
        _builder.append("import graphmodel.Node;");
        _builder.newLine();
        _builder.append("import ");
        String _apiPackage = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage);
        _builder.append(".MetaLevel;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_1 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_1);
        _builder.append(".Pattern;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_2 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_2);
        _builder.append(".");
        String _name = graphmodel.getGraphModel().getName();
        _builder.append(_name);
        _builder.append("ES;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_3 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_3);
        _builder.append(".MetaLevel;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_1 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_1);
        _builder.append(".match.model.Match;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_2 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_2);
        _builder.append(".match.model.LTSMatch;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class NodeSimulator {");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private EdgeSimulator edgeSimulator;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private GraphSimulator graphSimulator;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private ");
        String _name_1 = graphmodel.getGraphModel().getName();
        _builder.append(_name_1, "\t");
        _builder.append("ES patternGraph;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Match simulatePatternFromNode(Node startGraphNode,Node startPatternNode,Map<ModelElement,Set<ModelElement>> foundMatches,LTSMatch ltsMatch)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* 1. Has this node been checked ? ");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(foundMatches.containsKey(startPatternNode)){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(foundMatches.get(startPatternNode).contains(startGraphNode)){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// terminate matching path");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return new Match();\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("foundMatches.put(startPatternNode, new HashSet<ModelElement>());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* 2. Type check");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(!TypeChecker.checkType(startGraphNode, startPatternNode))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Match match = new Match();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("match.setPattern((Pattern) startPatternNode.getContainer());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("match.setRoot(ltsMatch);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("match.getElements().add(startGraphNode);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("BorderMatcher.setBorder(match,startGraphNode,startPatternNode);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("foundMatches.get(startPatternNode).addAll(match.getElements());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* 3. simulate edges");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* For each possible edge type, check the cardinalities");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Match edgeMatch = edgeSimulator.simulateSurroundingEdges(startGraphNode, startPatternNode, foundMatches,ltsMatch);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(edgeMatch == null)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("match.unionMatch(edgeMatch);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return match;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        Functions.Function1<ExecutableNode, Node> _function = new Functions.Function1<ExecutableNode, Node>(){

            public Node apply(ExecutableNode n) {
                Node _modelElement = n.getModelElement();
                return _modelElement;
            }
        };
        Functions.Function1<Node, Boolean> _function_1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return NodeSimulatorTemplate.this.getIsPrime(it);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)ListExtensions.map(graphmodel.getExclusivelyNodes(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        for (Node n : _filter) {
            _builder.append("\t");
            _builder.append("public Match simulatePatternFromOLNode(Node startGraphNode,");
            String _apiPackage_4 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_4, "\t");
            _builder.append(".");
            String _name_2 = n.getName();
            _builder.append(_name_2, "\t");
            _builder.append("OuterLevelState startPatternNode,Map<ModelElement,Set<ModelElement>> foundMatches,LTSMatch ltsMatch)");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("Match match = simulatePatternFromNode(startGraphNode,(Node) startPatternNode, foundMatches,ltsMatch);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if(match==null) ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("return null;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("MetaLevel level = ((");
            String _apiPackage_5 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_5, "\t\t");
            _builder.append(".");
            String _name_3 = n.getName();
            _builder.append(_name_3, "\t\t");
            _builder.append("OuterLevelState)startPatternNode.getModelElement()).getLevel();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("CMetaLevel cMetaLevel = (CMetaLevel) this.patternGraph.getModelElements().stream().filter(n->n.getModelElement().getId().equals(level.getId())).findFirst().get();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            String _sourceApiPackage = this.getSourceApiPackage(graphmodel);
            _builder.append(_sourceApiPackage, "\t\t");
            _builder.append(".");
            String _name_4 = n.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append(" startNode = (");
            String _sourceApiPackage_1 = this.getSourceApiPackage(graphmodel);
            _builder.append(_sourceApiPackage_1, "\t\t");
            _builder.append(".");
            String _name_5 = n.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append(") startGraphNode.getModelElement();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            String _sourceApiPackage_2 = this.getSourceApiPackage(graphmodel);
            _builder.append(_sourceApiPackage_2, "\t\t");
            _builder.append(".");
            String _name_6 = graphmodel.getModelElement().getName();
            _builder.append(_name_6, "\t\t");
            _builder.append(" graphModel = startNode.getProcedure().getRootElement();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            String _sourceApiPackage_3 = this.getSourceApiPackage(graphmodel);
            _builder.append(_sourceApiPackage_3, "\t\t");
            _builder.append(".");
            String _primeAttrType = this.primeAttrType(n);
            _builder.append(_primeAttrType, "\t\t");
            _builder.append(" reference = (");
            String _sourceApiPackage_4 = this.getSourceApiPackage(graphmodel);
            _builder.append(_sourceApiPackage_4, "\t\t");
            _builder.append(".");
            String _primeAttrType_1 = this.primeAttrType(n);
            _builder.append(_primeAttrType_1, "\t\t");
            _builder.append(") graphModel.getAllNodes().stream().filter(n->n.getModelElement().getId().equals(startNode.get");
            String _firstUpper = StringExtensions.toFirstUpper((String)this.primeAttrName(n));
            _builder.append(_firstUpper, "\t\t");
            _builder.append("().getId())).findFirst().get();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("LTSMatch lts = graphSimulator.simulateLTS(cMetaLevel,startGraphNode.getRootElement(),reference);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("match.setLevel(lts);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return match;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setEdgeSimulator(EdgeSimulator edgeSimulator) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.edgeSimulator = edgeSimulator;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setGraphSimulator(GraphSimulator graphSimulator) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.graphSimulator = graphSimulator;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setPatternGraph(");
        String _name_7 = graphmodel.getGraphModel().getName();
        _builder.append(_name_7, "\t");
        _builder.append("ES patternGraph) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("this.patternGraph = patternGraph;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

