/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.executer.generator.tracer;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel;
import de.jabc.cinco.meta.util.xapi.WorkspaceExtension;
import java.util.List;
import mgl.MGLModel;
import mgl.Node;
import mgl.ReferencedModelElement;
import mgl.ReferencedType;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public abstract class MainTemplate {
    @Extension
    private static WorkspaceExtension _workspaceExtension = new WorkspaceExtension();
    protected ExecutableGraphmodel graphmodel;

    public MainTemplate(ExecutableGraphmodel graphmodel) {
        this.graphmodel = graphmodel;
    }

    public CharSequence create() {
        return this.create(this.graphmodel);
    }

    public abstract CharSequence create(ExecutableGraphmodel var1);

    public abstract String fileName();

    public String getProjectName(ExecutableGraphmodel graphmodel) {
        String _name = graphmodel.getGraphModel().getName();
        return String.valueOf(_name) + "ES";
    }

    public static String getPackage(ExecutableGraphmodel graphmodel) {
        EObject _eContainer = graphmodel.getGraphModel().eContainer();
        String _package = ((MGLModel)_eContainer).getPackage();
        return String.valueOf(_package) + ".esdsl";
    }

    public String getSourceApiPackage(ExecutableGraphmodel graphmodel) {
        EObject _eContainer = graphmodel.getGraphModel().eContainer();
        String _package = ((MGLModel)_eContainer).getPackage();
        String _plus = String.valueOf(_package) + ".";
        String _lowerCase = graphmodel.getGraphModel().getName().toLowerCase();
        return String.valueOf(_plus) + _lowerCase;
    }

    public String getSourceGraphitiPackage(ExecutableGraphmodel graphmodel) {
        EObject _eContainer = graphmodel.getGraphModel().eContainer();
        String _package = ((MGLModel)_eContainer).getPackage();
        return String.valueOf(_package) + ".graphiti";
    }

    public String getApiPackage(ExecutableGraphmodel graphmodel) {
        EObject _eContainer = graphmodel.getGraphModel().eContainer();
        String _package = ((MGLModel)_eContainer).getPackage();
        String _plus = String.valueOf(_package) + ".esdsl.";
        String _lowerCase = graphmodel.getGraphModel().getName().toLowerCase();
        String _plus_1 = String.valueOf(_plus) + _lowerCase;
        return String.valueOf(_plus_1) + "es";
    }

    public static String getTracerPackage(ExecutableGraphmodel graphmodel) {
        EObject _eContainer = graphmodel.getGraphModel().eContainer();
        String _package = ((MGLModel)_eContainer).getPackage();
        return String.valueOf(_package) + ".esdsl.tracer";
    }

    public String getRunnerPackage(ExecutableGraphmodel graphmodel) {
        EObject _eContainer = graphmodel.getGraphModel().eContainer();
        String _package = ((MGLModel)_eContainer).getPackage();
        return String.valueOf(_package) + ".esdsl.runner";
    }

    public String getNsUri(ExecutableGraphmodel graphmodel) {
        EObject _eContainer = graphmodel.getGraphModel().eContainer();
        String _nsURI = this.nsURI((MGLModel)_eContainer);
        return String.valueOf(_nsURI) + "/esdsl";
    }

    public boolean getIsPrime(Node node) {
        ReferencedType _retrievePrimeReference = MGLUtil.retrievePrimeReference((Node)node);
        return !Objects.equal((Object)_retrievePrimeReference, null);
    }

    public String primeAttrName(Node node) {
        return MGLUtil.retrievePrimeReference((Node)node).getName();
    }

    public String primeAttrType(Node node) {
        ReferencedType type = MGLUtil.retrievePrimeReference((Node)node);
        if (type instanceof ReferencedModelElement) {
            return ((ReferencedModelElement)type).getType().getName();
        }
        return type.getClass().getName();
    }

    public static IFile generateFile(MainTemplate template, String folderFQN, IProject project) {
        boolean _not;
        IFile _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)folderFQN);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            IFile _xblockexpression = null;
            String folderPath = folderFQN.replaceAll("\\.", "/");
            IFolder folder = _workspaceExtension.createFolder((IContainer)project, folderPath);
            String _fileName = template.fileName();
            String _string = template.create().toString();
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            _xifexpression = _xblockexpression = ProjectCreator.createFile((String)_fileName, (IContainer)folder, (String)_string, (IProgressMonitor)_nullProgressMonitor);
        } else {
            String _fileName = template.fileName();
            String _string = template.create().toString();
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            _xifexpression = ProjectCreator.createFile((String)_fileName, (IContainer)project, (String)_string, (IProgressMonitor)_nullProgressMonitor);
        }
        return _xifexpression;
    }

    public IFile generate(String folderFQN, IProject project) {
        return MainTemplate.generateFile(this, folderFQN, project);
    }

    public String nsURI(MGLModel model) {
        String _join = IterableExtensions.join((Iterable)ListExtensions.reverse((List)((List)Conversions.doWrapArray((Object)model.getPackage().split(".")))), (CharSequence)"/");
        return "http://" + _join;
    }
}

