/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.executer.generator.tracer;

import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel;
import de.jabc.cinco.meta.plugin.executer.generator.tracer.MainTemplate;
import org.eclipse.xtend2.lib.StringConcatenation;

public class LevelTemplate
extends MainTemplate {
    public LevelTemplate(ExecutableGraphmodel graphmodel) {
        super(graphmodel);
    }

    @Override
    public String fileName() {
        return "Level.java";
    }

    @Override
    public CharSequence create(ExecutableGraphmodel graphmodel) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _tracerPackage = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage);
        _builder.append(".stepper.model;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.LinkedList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import ");
        String _tracerPackage_1 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_1);
        _builder.append(".extension.AbstractContext;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_2 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_2);
        _builder.append(".extension.AbstractSemantic;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_3 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_3);
        _builder.append(".match.model.LTSMatch;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_4 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_4);
        _builder.append(".match.model.Match;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_5 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_5);
        _builder.append(".stepper.utils.TracerException;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_6 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_6);
        _builder.append(".stepper.utils.WaitingException;");
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Defines a level of execution.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* every time an inter- or outerlevel state is executed, a new level is created.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The level contains information about the current modelelement");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author zweihoff");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public final class Level {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private LTSMatch graph;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private Match currentElement;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private LTSMatch currentContainer;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<Match> history;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private AbstractSemantic abstractSemantic;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Creates a new Level.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Set the first element and highlights it");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Initializes the history");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param firstElement");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param abstractSemantic");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Level(Match firstElement,AbstractSemantic abstractSemantic,List<Match> globalHistory)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.abstractSemantic = abstractSemantic;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("history = new LinkedList<Match>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("currentElement = firstElement;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("currentContainer = firstElement.getRoot();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("graph = firstElement.getRoot();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("history.add(currentElement);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("globalHistory.add(currentElement);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Determines the next modelelement for this level after the execution");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return StepResult The next and the previous modelelement");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final StepResult doStep(AbstractContext context,List<Thread> threads) throws TracerException, WaitingException");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return abstractSemantic.doStep(currentElement, context,threads);\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Finaly executes the StepResult and sets the new current modelelement of this level");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Iff the StepResult is a default execution without any level changes.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param stepResult The StepResult to be executed");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param globalHistory ");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return The given StepResult without changes");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @throws TracerException ");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final StepResult executeStep(StepResult stepResult, List<Match> globalHistory,AbstractContext context) throws TracerException");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stepResult = this.abstractSemantic.doPostProcessingStep(stepResult,context);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(stepResult.getStepType() == StepType.Default)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("history.add(stepResult.getFollowingElement());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("globalHistory.add(stepResult.getFollowingElement());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("currentElement = stepResult.getPostElement();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else if(stepResult.getStepType() == StepType.Terminating){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("history.add(stepResult.getFollowingElement());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("globalHistory.add(stepResult.getFollowingElement());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return stepResult;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final LTSMatch getGraph() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return graph;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setGraph(LTSMatch graph) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.graph = graph;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final Match getCurrenElement() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return currentElement;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setCurrenElement(Match currenElement) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.currentElement = currenElement;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final LTSMatch getCurrentContainer() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return currentContainer;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setCurrentContainer(LTSMatch currentContainer) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.currentContainer = currentContainer;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final List<Match> getHistory() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return history;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void setHistory(List<Match> history) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.history = history;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final String toString()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return this.abstractSemantic.displayLevel(currentContainer.getContainer())+\" \"+this.abstractSemantic.displayElement(currentElement);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

