/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.executer.generator.tracer;

import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel;
import de.jabc.cinco.meta.plugin.executer.generator.tracer.MainTemplate;
import org.eclipse.xtend2.lib.StringConcatenation;

public class LTSMatchTemplate
extends MainTemplate {
    public LTSMatchTemplate(ExecutableGraphmodel graphmodel) {
        super(graphmodel);
    }

    @Override
    public String fileName() {
        return "LTSMatch.java";
    }

    @Override
    public CharSequence create(ExecutableGraphmodel graphmodel) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _tracerPackage = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage);
        _builder.append(".match.model;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.LinkedList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import java.util.stream.Collectors;");
        _builder.newLine();
        _builder.append("import java.util.stream.Stream;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import graphmodel.GraphModel;");
        _builder.newLine();
        _builder.append("import graphmodel.ModelElementContainer;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class LTSMatch {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<StateMatch> startStates;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<StateMatch> states;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<StateMatch> endStates;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<TransitionMatch> transitions;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private ModelElementContainer container;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private GraphModel graph;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public LTSMatch(GraphModel graph,ModelElementContainer container)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.startStates = new LinkedList<StateMatch>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.endStates = new LinkedList<StateMatch>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.states = new LinkedList<StateMatch>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.transitions = new LinkedList<TransitionMatch>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.container = container;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.graph = graph;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<Match> getAllMatches()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return Stream.concat(startStates.stream(), Stream.concat(states.stream(), Stream.concat(endStates.stream(), transitions.stream()))).collect(Collectors.toList());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<StateMatch> getStartStates() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return startStates;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setStartStates(List<StateMatch> startStates) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.startStates = startStates;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setAbstractStartStates(List<Match> startStates) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.startStates = startStates.stream().map(n->new StateMatch(n)).collect(Collectors.toList());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<StateMatch> getStates() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return states;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setStates(List<StateMatch> states) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.states = states;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setAbstractStates(List<Match> states) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.states = states.stream().map(n->new StateMatch(n)).collect(Collectors.toList());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<TransitionMatch> getTransitions() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return transitions;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setTransitions(List<TransitionMatch> transitions) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.transitions = transitions;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setAbstractTransitions(List<Match> transitions) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.transitions = transitions.stream().map(n->new TransitionMatch(n)).collect(Collectors.toList());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<StateMatch> getEndStates() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return endStates;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setEndStates(List<StateMatch> endStates) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.endStates = endStates;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setAbstractEndStates(List<Match> endStates) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.endStates = endStates.stream().map(n->new StateMatch(n)).collect(Collectors.toList());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<StateMatch> getAllStateMatches() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return Stream.concat(startStates.stream(), Stream.concat(states.stream(),endStates.stream())).collect(Collectors.toList());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ModelElementContainer getContainer() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return container;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setContainer(ModelElementContainer container) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.container = container;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public GraphModel getGraphModel() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return graph;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setGraphModel(GraphModel graph) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.graph = graph;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

