/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.executer.generator.tracer;

import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableContainer;
import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel;
import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableNode;
import de.jabc.cinco.meta.plugin.executer.generator.tracer.MainTemplate;
import java.util.List;
import mgl.Node;
import mgl.NodeContainer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class GraphSimulatorTemplate
extends MainTemplate {
    public GraphSimulatorTemplate(ExecutableGraphmodel graphmodel) {
        super(graphmodel);
    }

    @Override
    public String fileName() {
        return "GraphSimulator.java";
    }

    @Override
    public CharSequence create(ExecutableGraphmodel graphmodel) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _tracerPackage = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage);
        _builder.append(".match.simulation;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.HashMap;");
        _builder.newLine();
        _builder.append("import java.util.LinkedList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.append("import java.util.Set;");
        _builder.newLine();
        _builder.append("import java.util.stream.Collectors;");
        _builder.newLine();
        _builder.append("import java.util.stream.Stream;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import graphmodel.Edge;");
        _builder.newLine();
        _builder.append("import graphmodel.GraphModel;");
        _builder.newLine();
        _builder.append("import graphmodel.ModelElement;");
        _builder.newLine();
        _builder.append("import graphmodel.ModelElementContainer;");
        _builder.newLine();
        _builder.append("import graphmodel.Node;");
        _builder.newLine();
        _builder.append("import ");
        String _sourceApiPackage = this.getSourceApiPackage(graphmodel);
        _builder.append(_sourceApiPackage);
        _builder.append(".");
        String _name = graphmodel.getGraphModel().getName();
        _builder.append(_name);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage);
        _builder.append(".ExecutableEdge;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_1 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_1);
        _builder.append(".ExecutableNode;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_2 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_2);
        _builder.append(".ExecutableContainer;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_3 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_3);
        _builder.append(".MetaLevel;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_4 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_4);
        _builder.append(".Pattern;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_5 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_5);
        _builder.append(".");
        String _name_1 = graphmodel.getGraphModel().getName();
        _builder.append(_name_1);
        _builder.append("ES;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_1 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_1);
        _builder.append(".match.model.LTSMatch;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_2 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_2);
        _builder.append(".match.model.Match;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_3 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_3);
        _builder.append(".match.model.StateMatch;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_4 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_4);
        _builder.append(".match.model.TransitionMatch;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class GraphSimulator {");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private ");
        String _name_2 = graphmodel.getGraphModel().getName();
        _builder.append(_name_2, "\t");
        _builder.append(" graph;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<MetaLevel> metaLevels;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private Map<ModelElementContainer,LTSMatch> lts;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private NodeSimulator nodeSimulator;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private EdgeSimulator edgeSimulator;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private ContainerSimulator containerSimulator;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public GraphSimulator(");
        String _name_3 = graphmodel.getGraphModel().getName();
        _builder.append(_name_3, "\t");
        _builder.append(" graph,");
        String _name_4 = graphmodel.getGraphModel().getName();
        _builder.append(_name_4, "\t");
        _builder.append("ES patternGraph)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.graph = graph;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.metaLevels = patternGraph.getMetaLevels();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.containerSimulator = new ContainerSimulator();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.edgeSimulator = new EdgeSimulator();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.nodeSimulator = new NodeSimulator();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("containerSimulator.setGraphSimulator(this);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("containerSimulator.setNodeSimulator(nodeSimulator);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("containerSimulator.setPatternGraph(patternGraph);\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("nodeSimulator.setEdgeSimulator(edgeSimulator);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("nodeSimulator.setGraphSimulator(this);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("nodeSimulator.setPatternGraph(patternGraph);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("edgeSimulator.setContainerSimulator(containerSimulator);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("edgeSimulator.setNodeSimulator(nodeSimulator);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("lts = new HashMap<ModelElementContainer, LTSMatch>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final LTSMatch simulate()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(MetaLevel levelDefinition : metaLevels)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// for each level definition try to build up a LTS match");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("LTSMatch ltsMatch = simulateLTS(levelDefinition,graph,graph);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(ltsMatch == null){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("continue;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ltsMatch;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final LTSMatch simulateLTS(MetaLevel levelDefinition,GraphModel graphModel,ModelElementContainer container)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(lts.containsKey(container)){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return lts.get(container);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("LTSMatch ltsMatch = new LTSMatch(graphModel,container);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("lts.put(container, ltsMatch);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* 1. phase: find matches for the patterns");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<Match> initializingStateMatches = getMatches(levelDefinition.getInitializings(),ltsMatch);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ltsMatch.setAbstractStartStates(initializingStateMatches);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ltsMatch.setAbstractStates(getMatches(levelDefinition.getDefaults(),ltsMatch));\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ltsMatch.setAbstractEndStates(getMatches(levelDefinition.getTerminatings(),ltsMatch));");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ltsMatch.setAbstractTransitions(getMatches(levelDefinition.getMetaTransitions(),ltsMatch));");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* 2. phase, connect states to states by transitions");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(StateMatch match:ltsMatch.getAllStateMatches())");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(match.getStartPoint() instanceof Edge){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("Node connectingSource = ((Edge)match.getStartPoint()).getSourceElement();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// find source as ");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("for(TransitionMatch transition:ltsMatch.getTransitions())");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("if(transition.getEndPoint() instanceof Node){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("if(connectingSource.equals(transition.getEndPoint())){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t");
        _builder.append("match.getIncoming().add(transition);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t");
        _builder.append("transition.setTarget(match);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(match.getEndPoint() instanceof Edge){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("Node connectingSource = ((Edge)match.getEndPoint()).getTargetElement();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// find source as ");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("for(TransitionMatch transition:ltsMatch.getTransitions())");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("if(transition.getStartPoint() instanceof Node){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("if(connectingSource.equals(transition.getStartPoint())){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t");
        _builder.append("match.getOutgoing().add(transition);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t");
        _builder.append("transition.setSource(match);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(TransitionMatch match:ltsMatch.getTransitions())");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(match.getStartPoint() instanceof Edge){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("Node connectingSource = ((Edge)match.getStartPoint()).getSourceElement();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// find source as ");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("for(StateMatch state:ltsMatch.getAllStateMatches())");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("if(state.getEndPoint() instanceof Node){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("if(connectingSource.equals(state.getEndPoint())){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t");
        _builder.append("match.setSource(state);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t");
        _builder.append("state.getOutgoing().add(match);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(match.getEndPoint() instanceof Edge){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("Node connectingSource = ((Edge)match.getEndPoint()).getTargetElement();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// find source as ");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("for(StateMatch state:ltsMatch.getAllStateMatches())");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("if(state.getStartPoint() instanceof Node){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("if(connectingSource.equals(state.getStartPoint())){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t");
        _builder.append("match.setTarget(state);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t");
        _builder.append("state.getIncoming().add(match);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return ltsMatch;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<Match> getMatches(List<? extends Pattern> elements,LTSMatch ltsMatch)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return elements.stream().flatMap(pattern->matchPattern(pattern,ltsMatch).stream()).collect(Collectors.toList());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<Match> matchPattern(Pattern pattern,LTSMatch ltsMatch)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<Match> abstractMatches = new LinkedList<Match>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// cache: pattern element -> list of matching graph model elements");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Map<ModelElement,Set<ModelElement>> foundMatches = new HashMap<ModelElement, Set<ModelElement>>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* Inner and outer level states");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// try to find simulation starting by any node of the graph");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<ExecutableNode> cenOL = pattern.getExecutableNodes().stream().filter(n->TypeChecker.isNodeOuterLevelState(n)).collect(Collectors.toList());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(!cenOL.isEmpty())");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        Functions.Function1<ExecutableNode, Node> _function = new Functions.Function1<ExecutableNode, Node>(){

            public Node apply(ExecutableNode n) {
                Node _modelElement = n.getModelElement();
                return _modelElement;
            }
        };
        Functions.Function1<Node, Boolean> _function_1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return GraphSimulatorTemplate.this.getIsPrime(it);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)ListExtensions.map(graphmodel.getExclusivelyNodes(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        for (Node n : _filter) {
            _builder.append("\t\t\t");
            _builder.append("if(cenOL.get(0) instanceof ");
            String _apiPackage_6 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_6, "\t\t\t");
            _builder.append(".");
            String _name_5 = n.getName();
            _builder.append(_name_5, "\t\t\t");
            _builder.append("OuterLevelState)");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("ltsMatch.getContainer().getAllNodes().forEach(node->addMatches(pattern, abstractMatches, nodeSimulator.simulatePatternFromOLNode(node, (");
            String _apiPackage_7 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_7, "\t\t\t\t");
            _builder.append(".");
            String _name_6 = n.getName();
            _builder.append(_name_6, "\t\t\t\t");
            _builder.append("OuterLevelState)cenOL.get(0),foundMatches,ltsMatch)));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t\t");
        _builder.append("return abstractMatches;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// try to find simulation starting by any container of the graph");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<ExecutableContainer> cecOL = pattern.getExecutableContainers().stream().filter(n->TypeChecker.isContainerOuterLevelState(n)).collect(Collectors.toList());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(!cecOL.isEmpty())");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        Functions.Function1<ExecutableContainer, NodeContainer> _function_2 = new Functions.Function1<ExecutableContainer, NodeContainer>(){

            public NodeContainer apply(ExecutableContainer n) {
                Node _modelElement = n.getModelElement();
                return (NodeContainer)_modelElement;
            }
        };
        Functions.Function1<NodeContainer, Boolean> _function_3 = new Functions.Function1<NodeContainer, Boolean>(){

            public Boolean apply(NodeContainer it) {
                return GraphSimulatorTemplate.this.getIsPrime((Node)it);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)ListExtensions.map(graphmodel.getContainers(), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        for (NodeContainer node : _filter_1) {
            _builder.append("\t\t\t");
            _builder.append("if(cecOL.get(0) instanceof ");
            String _apiPackage_8 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_8, "\t\t\t");
            _builder.append(".");
            String _name_7 = node.getName();
            _builder.append(_name_7, "\t\t\t");
            _builder.append("OuterLevelState)");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("ltsMatch.getContainer().getAllContainers().forEach(container->addMatches(pattern, abstractMatches, containerSimulator.simulatePatternFromOLContainer(container,(");
            String _apiPackage_9 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_9, "\t\t\t\t");
            _builder.append(".");
            String _name_8 = node.getName();
            _builder.append(_name_8, "\t\t\t\t");
            _builder.append("OuterLevelState) cecOL.get(0),foundMatches,ltsMatch)));\t\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t\t");
        _builder.append("return abstractMatches;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// try to find simulation starting by any container of the graph");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<ExecutableContainer> cecIL = pattern.getExecutableContainers().stream().filter(n->TypeChecker.isContainerInnerLevelState(n)).collect(Collectors.toList());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(!cecIL.isEmpty())");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        Functions.Function1<ExecutableContainer, NodeContainer> _function_4 = new Functions.Function1<ExecutableContainer, NodeContainer>(){

            public NodeContainer apply(ExecutableContainer n) {
                Node _modelElement = n.getModelElement();
                return (NodeContainer)_modelElement;
            }
        };
        List _map = ListExtensions.map(graphmodel.getContainers(), (Functions.Function1)_function_4);
        for (NodeContainer node_1 : _map) {
            _builder.append("\t\t\t");
            _builder.append("if(cecIL.get(0) instanceof ");
            String _apiPackage_10 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_10, "\t\t\t");
            _builder.append(".");
            String _name_9 = node_1.getName();
            _builder.append(_name_9, "\t\t\t");
            _builder.append("InnerLevelState)");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("ltsMatch.getContainer().getAllContainers().forEach(container->addMatches(pattern, abstractMatches, containerSimulator.simulatePatternFromILContainer(container,(");
            String _apiPackage_11 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_11, "\t\t\t\t");
            _builder.append(".");
            String _name_10 = node_1.getName();
            _builder.append(_name_10, "\t\t\t\t");
            _builder.append("InnerLevelState) cecIL.get(0),foundMatches,ltsMatch)));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t\t");
        _builder.append("return abstractMatches;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* One level states");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// try to find simulation starting by any node of the graph");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(!pattern.getExecutableNodes().isEmpty())");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("ltsMatch.getContainer().getAllNodes().forEach(node->addMatches(pattern, abstractMatches, nodeSimulator.simulatePatternFromNode(node, pattern.getExecutableNodes().get(0),foundMatches,ltsMatch)));");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return abstractMatches;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// try to find simulation starting by any container of the graph");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(!pattern.getExecutableContainers().isEmpty())");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("ltsMatch.getContainer().getAllContainers().forEach(container->addMatches(pattern, abstractMatches, nodeSimulator.simulatePatternFromNode(container, pattern.getExecutableContainers().get(0),foundMatches,ltsMatch)));");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return abstractMatches;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* Only Transitions");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// try to find simulation starting by any container of the graph");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Set<ExecutableEdge> edges = Stream.concat(");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("pattern.getAllNodes().stream().flatMap(node->node.getIncoming().stream().filter(edge->(edge instanceof ExecutableEdge)).map(edge->(ExecutableEdge)edge)),");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("pattern.getAllNodes().stream().flatMap(node->node.getOutgoing().stream().filter(edge->(edge instanceof ExecutableEdge)).map(edge->(ExecutableEdge)edge))");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(").collect(Collectors.toSet());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(!edges.isEmpty())");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("ltsMatch.getContainer().getAllEdges().forEach(edge->addMatches(pattern, abstractMatches, edgeSimulator.simulatePatternFromEdge(edge, edges.stream().findFirst().get(),foundMatches,ltsMatch)));\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return abstractMatches;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return abstractMatches;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private void addMatches(Pattern pattern,List<Match> abstractMatches, Match match) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(match != null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("match.setPattern(pattern);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("abstractMatches.add(match);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

