/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.executer.generator.tracer;

import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableContainer;
import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel;
import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableNode;
import de.jabc.cinco.meta.plugin.executer.generator.tracer.MainTemplate;
import java.util.List;
import mgl.Node;
import mgl.NodeContainer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class EdgeSimulatorTemplate
extends MainTemplate {
    public EdgeSimulatorTemplate(ExecutableGraphmodel graphmodel) {
        super(graphmodel);
    }

    @Override
    public String fileName() {
        return "EdgeSimulator.java";
    }

    @Override
    public CharSequence create(ExecutableGraphmodel graphmodel) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _tracerPackage = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage);
        _builder.append(".match.simulation;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.append("import java.util.Set;");
        _builder.newLine();
        _builder.append("import java.util.stream.Collectors;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import graphmodel.Container;");
        _builder.newLine();
        _builder.append("import graphmodel.Edge;");
        _builder.newLine();
        _builder.append("import graphmodel.ModelElement;");
        _builder.newLine();
        _builder.append("import graphmodel.Node;");
        _builder.newLine();
        _builder.append("import ");
        String _apiPackage = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage);
        _builder.append(".ExecutableContainer;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_1 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_1);
        _builder.append(".ExecutableEdge;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_2 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_2);
        _builder.append(".ExecutableNode;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_3 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_3);
        _builder.append(".Pattern;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_4 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_4);
        _builder.append(".SourceConnector;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_5 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_5);
        _builder.append(".TargetConnector;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_1 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_1);
        _builder.append(".match.model.LTSMatch;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_2 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_2);
        _builder.append(".match.model.Match;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class EdgeSimulator {");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private NodeSimulator nodeSimulator;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private ContainerSimulator containerSimulator;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Match simulatePatternFromEdge(Edge edge, ExecutableEdge cExecutableEdge,Map<ModelElement, Set<ModelElement>> foundMatches,LTSMatch ltsMatch) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Match match = new Match();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("match.setRoot(ltsMatch);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("match.getElements().add(edge);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("BorderMatcher.setBorder(match,edge,cExecutableEdge);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//check incoming");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Match sourceMatch = simulatePatternFromIncommingEdge(edge, cExecutableEdge,foundMatches,ltsMatch);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(sourceMatch == null){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// pattern did not match");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//check outgoing");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Match targetMatch = simulatePatternFromOutgoingEdge(edge, cExecutableEdge,foundMatches,ltsMatch);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(targetMatch == null){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// pattern did not match");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("match.unionMatch(sourceMatch);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("match.unionMatch(targetMatch);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return match;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Match simulateSurroundingEdges(Node startGraphNode, Node startPatternNode,Map<ModelElement, Set<ModelElement>> foundMatches,LTSMatch ltsMatch) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Match match = new Match();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("match.setPattern((Pattern) startPatternNode.getContainer());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("match.setRoot(ltsMatch);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// simulate incoming edges");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(ExecutableEdge patternEdge:startPatternNode.getIncoming(ExecutableEdge.class)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// for each incoming pattern edge");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Set<Edge> fittingEdges = startGraphNode.");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("getIncoming().");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("stream().");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("filter(n->TypeChecker.checkType(n, patternEdge)).");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("collect(Collectors.toSet());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// check cardinality");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(CardinalityChecker.checkCardinality(patternEdge, fittingEdges.size()))");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("for(Edge edge:startGraphNode.getIncoming()){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("Match sourceMatch = simulatePatternFromIncommingEdge(edge, patternEdge,foundMatches,ltsMatch);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("if(sourceMatch == null){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("// pattern did not match");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("match.unionMatch(sourceMatch);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("else{");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(ExecutableEdge patternEdge:startPatternNode.getOutgoing(ExecutableEdge.class)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Set<Edge> fittingEdges = startGraphNode.");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("getOutgoing().");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("stream().");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("filter(n->TypeChecker.checkType(n, patternEdge)).");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("collect(Collectors.toSet());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// check cardinality");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(CardinalityChecker.checkCardinality(patternEdge, fittingEdges.size()))");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("for(Edge edge:startGraphNode.getOutgoing()){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("Match targetMatch = simulatePatternFromOutgoingEdge(edge, patternEdge,foundMatches,ltsMatch);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("if(targetMatch == null){");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("// pattern did not match");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("match.unionMatch(targetMatch);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("else{");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return match;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Match simulatePatternFromIncommingEdge(Edge startGraphEdge,ExecutableEdge startPatternEdge, Map<ModelElement, Set<ModelElement>> foundMatches,LTSMatch ltsMatch)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Node targetPattern = startPatternEdge.getTargetElement();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Node targetNode = startGraphEdge.getTargetElement();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return simulateNode(startGraphEdge, foundMatches, targetPattern, targetNode, TargetConnector.class,ltsMatch);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* precondition: type check passed");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* precondition: cardinality check passed");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param startGraphEdge");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param startPatternEdge");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param foundMatches");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Match simulatePatternFromOutgoingEdge(Edge startGraphEdge,ExecutableEdge startPatternEdge, Map<ModelElement, Set<ModelElement>> foundMatches,LTSMatch ltsMatch)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Node sourcePattern = startPatternEdge.getSourceElement();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Node sourceNode = startGraphEdge.getSourceElement();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return simulateNode(startGraphEdge, foundMatches, sourcePattern, sourceNode, SourceConnector.class,ltsMatch);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Match simulateNode(Edge startGraphEdge,Map<ModelElement, Set<ModelElement>> foundMatches, Node pattern,Node node, Class<? extends Node> clazz,LTSMatch ltsMatch) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Match match = new Match();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("match.setPattern((Pattern) pattern.getContainer());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("match.setRoot(ltsMatch);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* 1. Check if target is a connector");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(clazz.isInstance(pattern)){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return match;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("match.getElements().add(startGraphEdge);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* 2. Check pattern type of the source and continue with the source node");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Match connectorMatch = null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        Functions.Function1<ExecutableContainer, NodeContainer> _function = new Functions.Function1<ExecutableContainer, NodeContainer>(){

            public NodeContainer apply(ExecutableContainer n) {
                Node _modelElement = n.getModelElement();
                return (NodeContainer)_modelElement;
            }
        };
        List _map = ListExtensions.map(graphmodel.getContainers(), (Functions.Function1)_function);
        for (NodeContainer node : _map) {
            _builder.append("\t\t");
            _builder.append("if(pattern instanceof ");
            String _apiPackage_6 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_6, "\t\t");
            _builder.append(".");
            String _name = node.getName();
            _builder.append(_name, "\t\t");
            _builder.append("InnerLevelState && node instanceof Container){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("connectorMatch = containerSimulator.simulatePatternFromILContainer((Container)node, (");
            String _apiPackage_7 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_7, "\t\t\t");
            _builder.append(".");
            String _name_1 = node.getName();
            _builder.append(_name_1, "\t\t\t");
            _builder.append("InnerLevelState)pattern,foundMatches,ltsMatch);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("if(connectorMatch != null){");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("match.unionMatch(connectorMatch);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("return match;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            boolean _isPrime = this.getIsPrime((Node)node);
            if (!_isPrime) continue;
            _builder.append("\t\t");
            _builder.append("if(pattern instanceof ");
            String _apiPackage_8 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_8, "\t\t");
            _builder.append(".");
            String _name_2 = node.getName();
            _builder.append(_name_2, "\t\t");
            _builder.append("OuterLevelState && node instanceof Container){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("connectorMatch = containerSimulator.simulatePatternFromOLContainer((Container)node, (");
            String _apiPackage_9 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_9, "\t\t\t");
            _builder.append(".");
            String _name_3 = node.getName();
            _builder.append(_name_3, "\t\t\t");
            _builder.append("OuterLevelState)pattern,foundMatches,ltsMatch);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("if(connectorMatch != null){");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("match.unionMatch(connectorMatch);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("return match;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        Functions.Function1<ExecutableNode, Node> _function_1 = new Functions.Function1<ExecutableNode, Node>(){

            public Node apply(ExecutableNode n) {
                Node _modelElement = n.getModelElement();
                return _modelElement;
            }
        };
        Functions.Function1<Node, Boolean> _function_2 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return EdgeSimulatorTemplate.this.getIsPrime(it);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)ListExtensions.map(graphmodel.getExclusivelyNodes(), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        for (Node n : _filter) {
            _builder.append("\t\t");
            _builder.append("if(pattern instanceof ");
            String _apiPackage_10 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_10, "\t\t");
            _builder.append(".");
            String _name_4 = n.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append("OuterLevelState){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("connectorMatch = nodeSimulator.simulatePatternFromOLNode(node, (");
            String _apiPackage_11 = this.getApiPackage(graphmodel);
            _builder.append(_apiPackage_11, "\t\t\t");
            _builder.append(".");
            String _name_5 = n.getName();
            _builder.append(_name_5, "\t\t\t");
            _builder.append("OuterLevelState)pattern,foundMatches,ltsMatch);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("if(connectorMatch != null){");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("match.unionMatch(connectorMatch);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("return match;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(pattern instanceof ExecutableNode){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("connectorMatch = nodeSimulator.simulatePatternFromNode(node, (ExecutableNode)pattern,foundMatches,ltsMatch);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(connectorMatch != null){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("match.unionMatch(connectorMatch);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return match;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(pattern instanceof ExecutableContainer){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("connectorMatch = containerSimulator.simulatePatternFromContainer((Container)node, (ExecutableContainer)pattern,foundMatches,ltsMatch);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(connectorMatch != null){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("match.unionMatch(connectorMatch);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return match;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setNodeSimulator(NodeSimulator nodeSimulator) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.nodeSimulator = nodeSimulator;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setContainerSimulator(ContainerSimulator containerSimulator) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.containerSimulator = containerSimulator;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

