/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.executer.generator.tracer;

import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel;
import de.jabc.cinco.meta.plugin.executer.generator.tracer.MainTemplate;
import org.eclipse.xtend2.lib.StringConcatenation;

public class AbstractSemanticTemplate
extends MainTemplate {
    public AbstractSemanticTemplate(ExecutableGraphmodel graphmodel) {
        super(graphmodel);
    }

    @Override
    public String fileName() {
        return "AbstractSemantic.java";
    }

    @Override
    public CharSequence create(ExecutableGraphmodel graphmodel) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _tracerPackage = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage);
        _builder.append(".extension;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import graphmodel.ModelElementContainer;");
        _builder.newLine();
        _builder.append("import ");
        String _apiPackage = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage);
        _builder.append(".Default;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_1 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_1);
        _builder.append(".Initializing;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _apiPackage_2 = this.getApiPackage(graphmodel);
        _builder.append(_apiPackage_2);
        _builder.append(".Terminating;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_1 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_1);
        _builder.append(".match.model.LTSMatch;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_2 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_2);
        _builder.append(".match.model.Match;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_3 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_3);
        _builder.append(".match.model.StateMatch;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_4 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_4);
        _builder.append(".match.model.TransitionMatch;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_5 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_5);
        _builder.append(".stepper.model.Level;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_6 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_6);
        _builder.append(".stepper.model.NextTransition;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_7 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_7);
        _builder.append(".stepper.model.StepResult;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_8 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_8);
        _builder.append(".stepper.model.StepType;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_9 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_9);
        _builder.append(".stepper.model.Thread;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_10 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_10);
        _builder.append(".stepper.utils.TracerException;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_11 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_11);
        _builder.append(".stepper.utils.WaitingException;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The abstract semantic defines an extension point for the semantic");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* of a given tracer. Multiple semantic implementations can be applied");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* to a tracer.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The semantic provides methods to decide which transition shouls be taken");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* and what should happen on a transition.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* In addition to this, multiple hooks can be used for i.e. logging");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author zweihoff");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public abstract class AbstractSemantic {");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* After the calculation of a possible step, the step is executed on the model");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* This includes the setting of a new current element.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param stepResult");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @throws TracerException");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final StepResult doPostProcessingStep(StepResult stepResult,AbstractContext context) throws TracerException");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// get the element which should be the next current element");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Match element = stepResult.getFollowingElement();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// hooks");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// is a state");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(element instanceof StateMatch){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(element.getPattern() instanceof Initializing){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("this.postExecuteStartStateHook((StateMatch) element, context);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(element.getPattern() instanceof Default){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("this.postExecuteDefaultStateHook((StateMatch)element, context);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(element.getPattern() instanceof Terminating){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("this.postExecuteTerminatingStateHook((StateMatch)element, context);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//New Level State");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(element.getLevel() != null){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("//if container has interlevel state");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("//get start of container");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("LTSMatch nextLevel = element.getLevel();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("List<StateMatch> startStates = nextLevel.getStartStates();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(startStates.isEmpty()){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("throw new TracerException(\"No Start State found in \"+this.displayLevel(nextLevel.getContainer()));");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("StateMatch startState = startStates.get(0);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("stepResult.setPostElement(startState);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("stepResult.setNewElements(startStates.subList(1, startStates.size()));");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("stepResult.setPreElement(element);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("stepResult.setStepType(StepType.Level);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return stepResult;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(element instanceof Terminating){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("//if container has interlevel state");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("//get level up");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("stepResult.setStepType(StepType.Terminating);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return stepResult;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return stepResult;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Determines the next and previous ModelElement which will be the current modelelement, after the execution");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param element");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param context");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param threads");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @throws TracerException");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @throws WaitingException");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final StepResult doStep(Match element,AbstractContext context,List<Thread> threads) throws TracerException, WaitingException");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("StepResult stepResult = new StepResult();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stepResult.setPreElement(element);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Default State");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(element instanceof StateMatch){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("NextTransition nextTransition = executeState((StateMatch) element,context,threads);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(nextTransition == null){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(nextTransition.getNextEdge() != null) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("stepResult.setFollowingElement(nextTransition.getNextEdge());");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("stepResult.setNewElements(nextTransition.getForkEdges());");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("stepResult.setStepType(StepType.Default);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return stepResult;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("else if(nextTransition.getForkEdges() != null){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if(!nextTransition.getForkEdges().isEmpty())");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("stepResult.setFollowingElement(null);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("stepResult.setNewElements(nextTransition.getForkEdges());");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("stepResult.setStepType(StepType.Terminating);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("return stepResult;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Default Transition");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(element instanceof TransitionMatch){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("stepResult.setFollowingElement(executeEdge((TransitionMatch) element,context,threads));");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// pre state hooks");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("StateMatch state = (StateMatch) stepResult.getFollowingElement();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(state == null){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(state.getPattern() instanceof Initializing){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("this.preExecuteStartStateHook(state, context);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(state.getPattern() instanceof Default){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("this.preExecuteDefaultStateHook(state, context);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(state.getPattern() instanceof Terminating){");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("this.preExecuteTerminatingStateHook(state, context);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("stepResult.setStepType(StepType.Terminating);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return stepResult;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("stepResult.setStepType(StepType.Default);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return stepResult;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Terminated");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stepResult.setStepType(StepType.Terminating);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return stepResult;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* The callback to decide which edge will be taken in this step");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param state The current State");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param context The context");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return the next edge to be taken");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public abstract NextTransition executeState(StateMatch state,AbstractContext context,List<Thread> threads) throws TracerException, WaitingException;\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* The callback to be executed when an edge is taken in the next step");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param edge The current Edge");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param context The Abstract Context");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public StateMatch executeEdge(TransitionMatch edge,AbstractContext context,List<Thread> threads) throws TracerException, WaitingException");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return edge.getTarget();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// -- STATE HOOKS");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Is executed before a default state is reached");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param state");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param context");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void preExecuteDefaultStateHook(StateMatch state,AbstractContext context) {}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Is executed after a default state has been reached");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param state");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param context");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void postExecuteDefaultStateHook(StateMatch state,AbstractContext context) {}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Is executed before a start state is reached");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param state");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param context");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void preExecuteStartStateHook(StateMatch state,AbstractContext context) {}\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Is executed after a start state has been reached");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param state");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param context");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void postExecuteStartStateHook(StateMatch state,AbstractContext context) {}\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Is executed before a terminating state is reached");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param state");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param context");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void preExecuteTerminatingStateHook(StateMatch state,AbstractContext context) {}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Is executed after a temrinating state is reached");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param state");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param context");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void postExecuteTerminatingStateHook(StateMatch state,AbstractContext context) {}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// -- THREAD HOOKS");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Is executed before a new thread is spawned");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param thread The spawning thread");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void preSpawnNewThread(Thread thread) {}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Is executed after a new thread has been spawned");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param thread The spawning thread");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void postSpawnNewThread(Thread thread) {}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Is executed before a thread is terminated");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param thread The spawning thread");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void preTerminateThread(Thread thread) {}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// -- LEVEL HOOKS");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Is executed before a new level is reached");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param thread");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param level");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void preEnterNewLevel(Thread thread,Level level) {}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Is executed after a new level has been reached");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param thread");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param level");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void postEnterNewLevel(Thread thread,Level level) {}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Is executed before a level is left");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param thread");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param level");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void preLeaveLevel(Thread thread,Level level) {}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// -- Display");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Returns the name of the semantic.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Is used to display it to the UI, so that the user can choose");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* a semantic");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public abstract String getName();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Returns the visual representation for a level");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param container");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public abstract String displayLevel(ModelElementContainer container);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Returns the visual representation for an element");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param element");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public abstract String displayElement(Match element);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}\t");
        _builder.newLine();
        return _builder;
    }
}

