/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.executer.generator.tracer;

import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel;
import de.jabc.cinco.meta.plugin.executer.generator.tracer.MainTemplate;
import org.eclipse.xtend2.lib.StringConcatenation;

public class AbstractRunnerTemplate
extends MainTemplate {
    public AbstractRunnerTemplate(ExecutableGraphmodel graphmodel) {
        super(graphmodel);
    }

    @Override
    public CharSequence create(ExecutableGraphmodel graphmodel) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _tracerPackage = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage);
        _builder.append(".extension;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.Arrays;");
        _builder.newLine();
        _builder.append("import java.util.Collections;");
        _builder.newLine();
        _builder.append("import java.util.LinkedList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import java.util.stream.Collectors;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import org.eclipse.swt.widgets.Shell;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import de.jabc.cinco.meta.core.utils.job.JobFactory;");
        _builder.newLine();
        _builder.append("import ");
        String _tracerPackage_1 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_1);
        _builder.append(".match.model.LTSMatch;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_2 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_2);
        _builder.append(".runner.model.ExceptionRunLog;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_3 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_3);
        _builder.append(".runner.model.MessageRunLog;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_4 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_4);
        _builder.append(".runner.model.Run;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_5 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_5);
        _builder.append(".runner.model.RunCallback;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_6 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_6);
        _builder.append(".runner.model.RunLog;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_7 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_7);
        _builder.append(".runner.model.RunResult;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_8 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_8);
        _builder.append(".runner.model.RunStepper;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_9 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_9);
        _builder.append(".stepper.model.Stepper;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_10 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_10);
        _builder.append(".stepper.model.Thread;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_11 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_11);
        _builder.append(".stepper.utils.JointTracerException;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        String _tracerPackage_12 = MainTemplate.getTracerPackage(graphmodel);
        _builder.append(_tracerPackage_12);
        _builder.append(".stepper.utils.TracerException;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The abstract runner class defines an extension point class");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* which can be used to define a Runner.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* A Runner describes a bunch of different execution runs.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Every run is given by a context, a semantic and a model which will");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* be executed.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author zweihoff");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public abstract class AbstractRunner {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* The start runner method starts the Runner for a given model.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* The shell is used, if the context initialization requires user interaction.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* The runnable callback method is called when all runs has ended.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* The getRuns method, which is to be overridden, is used to receive all runs of this ");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Runner implementation.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param shell");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param graph");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param callback");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public final void startRunner(Shell shell,LTSMatch matchGraph,RunCallback callback)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// receive runs");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<Run> runs = getRuns(matchGraph);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<RunStepper> runSteppers = new LinkedList<RunStepper>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//prepare the runs");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//create a semantic and a context for each run");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//initialize the context");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(Run r:runs){");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// determine the context for each run");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("AbstractContext context = r.getContext();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("AbstractSemantic semantic = r.getSemantic();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// create the stepper");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Stepper stepper;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("stepper = new Stepper(matchGraph,r.getStartingElements(),shell,context,semantic);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} catch (TracerException e) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("continue;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// and combine it with the run ");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("runSteppers.add(new RunStepper(r,stepper));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("long startTime = System.nanoTime();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("System.err.println(\"Starting at: \"+startTime);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// asynchronously and in parallel concurrent execution");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// of each run stepper");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("JobFactory.job(\"Executing Runner\")");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(".consumeConcurrent(runSteppers.size(), \"executing...\")");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// for each run stepper, the execute run method is called");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// which executes the entire run");
        _builder.newLine();
        _builder.append("\t\t\t    ");
        _builder.append(".taskForEach(() -> runSteppers.stream(), this::executeRun)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(".onCanceledShowMessage(\"Runner Execution has been canceled\")");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(".onFinished(() -> System.err.println(\"Time to finfish all runs: \"+(System.nanoTime()-startTime)*Math.pow(10,-9)/60))");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(".onFinishedShowMessage(\"Runner Execution completed successfully\")");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// when all run execute run methods has terminated");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// the given callback runnable is called");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(".onDone(() -> this.onDone(runSteppers,callback))");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(".schedule();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* The on done method summarizes the results finihsed execution of");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* all run steppers and finally calls the runnable callback.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param runSteppers");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param runnable");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private void onDone(List<RunStepper> runSteppers,RunCallback runnable)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// trigger hook");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("postAllRunsTerminated();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//divide the run steppers depedned on their status");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<RunStepper> active = runSteppers.stream().filter(n->n.isActive()).collect(Collectors.toList());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<RunStepper> inactive = runSteppers.stream().filter(n->!n.isActive()).collect(Collectors.toList());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("System.out.println(displayResults(active, inactive));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// create the run result");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("RunResult rr = new RunResult();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("rr.setActiveRunSteppers(active);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("rr.setInactiveRunSteppers(inactive);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// prepare the callback");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("runnable.setResult(rr);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// and execute it");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("runnable.run();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Executes the given run stepper until it is terminated or interrupted");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* by an exception");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param rs");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private void executeRun(RunStepper rs)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//execute until it is terminated or interrupted");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("while(true)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("List<RunLog> logging = rs.getLogging();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Stepper s = rs.getStepper();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("//hook");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("logging.addAll(preStepExecution(s.getActiveThreads(),rs.getRun()));");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// execute step of run");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if(!s.doStep())");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("//Run has successfully completed a step");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("logging.addAll(postStepExecution(s.getActiveThreads(),rs.getRun()));");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("else{");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("//Stepper has terminated");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("//Run is finished");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("logging.addAll(postExecutionTerminated(s.getActiveThreads(),rs.getRun()));");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("rs.setStatus(RunStepper.STATUS_INACTIVE);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("catch (JointTracerException e) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// interrupted by exception");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("logging.add(new ExceptionRunLog(e));");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("logging.addAll(postExecutionAborted(s.getActiveThreads(),rs.getRun(),e));");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("System.err.println(e.getMessages());");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Displays the results after all runs have terminated their execution.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Shows all logging messages of all runs grouped by their status: inactive / active");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param activeRunSteppers");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param inactiveRunSteppers");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String displayResults(List<RunStepper> activeRunSteppers,List<RunStepper> inactiveRunSteppers)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("String s = \"\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("s+= \"Inactive:\\n\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// all inactive runs after termination");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(RunStepper n:inactiveRunSteppers)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("s += n.getRun().toString() + \"\\n\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// all logging information");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("for(RunLog e:n.getLogging())");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("s += e.toString()+\"\\n\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("s += \"Active:\\n\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// all active runs after termination");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(RunStepper n:activeRunSteppers)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("s += n.getRun().toString() + \"\\n\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// all logging information");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("for(RunLog e:n.getLogging())");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("s += e.toString() + \"\\n\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return s;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Monitoring hooks");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param graph");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public abstract List<Run> getRuns(LTSMatch graph);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Executed before each step of each run");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param allThreads");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param run");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<RunLog> preStepExecution(List<Thread> allThreads,Run run) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return Collections.emptyList();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Executed after each step of each run");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param activeThreads");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param run");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<RunLog> postStepExecution(List<Thread> activeThreads,Run run) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return Collections.emptyList();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Executed after a run has finished");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param inactiveThreads");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param run");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<RunLog> postExecutionTerminated(List<Thread> inactiveThreads,Run run) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return Arrays.asList(new MessageRunLog(\"Successfully completed execution\"));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Executed after a run is interrupted by an exception");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param inactiveThreads");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param run");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param e");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<RunLog> postExecutionAborted(List<Thread> inactiveThreads,Run run,JointTracerException e) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return Arrays.asList(new MessageRunLog(\"Aborted execution\"));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Hook");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Executed after all runs are finished");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void postAllRunsTerminated() {}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Returns the name of the runner, which is displayed in UI");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* to be selected by the user.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String getName()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return \"Abstract Runner\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    @Override
    public String fileName() {
        return "AbstractRunner.java";
    }
}

