/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.executer.generator.model;

import de.jabc.cinco.meta.plugin.executer.collector.GraphmodelCollector;
import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel;
import de.jabc.cinco.meta.plugin.executer.generator.TracerProjectGenerator;
import de.jabc.cinco.meta.plugin.executer.generator.model.CPDGeneratorTemplate;
import de.jabc.cinco.meta.plugin.executer.generator.model.MGLGenerator;
import de.jabc.cinco.meta.plugin.executer.generator.model.StyleGeneratorTemplate;
import de.jabc.cinco.meta.plugin.executer.service.ProjectCreator;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.LinkedList;
import mgl.Annotation;
import mgl.GraphModel;
import mgl.MGLModel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;

public class CreateExecuterPlugin {
    public static final String EXECUTER = "execsem";
    public String basePath;

    public void execute(GraphModel graphModel) throws IOException, URISyntaxException {
        IProject project = de.jabc.cinco.meta.core.utils.projects.ProjectCreator.getProject((Resource)graphModel.eResource());
        if (project == null) {
            throw new IllegalStateException("Project cannot be found");
        }
        String pluginPath = ".plugin.esdsl";
        String projectName = String.valueOf(((MGLModel)graphModel.eContainer()).getPackage()) + pluginPath;
        LinkedList<String> srcFolders = new LinkedList<String>();
        srcFolders.add("src");
        LinkedList<IProject> referencedProjects = new LinkedList<IProject>();
        HashSet<String> requiredBundles = new HashSet<String>();
        requiredBundles.add(((MGLModel)graphModel.eContainer()).getPackage());
        requiredBundles.add("org.eclipse.core.resources");
        requiredBundles.add("org.eclipse.xtext");
        requiredBundles.add("de.jabc.cinco.meta.core.ge.style.model");
        requiredBundles.add("de.jabc.cinco.meta.core.referenceregistry");
        requiredBundles.add("de.jabc.cinco.meta.runtime");
        LinkedList<String> exportedPackages = new LinkedList<String>();
        LinkedList<String> additionalNatures = new LinkedList<String>();
        additionalNatures.add("org.eclipse.xtext.ui.shared.xtextNature");
        LinkedList<String> cleanDirs = new LinkedList<String>();
        cleanDirs.add("model");
        cleanDirs.add("scr");
        String pluginXML = "";
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        for (Annotation anno : graphModel.getAnnotations()) {
            if (!anno.getName().equals(EXECUTER)) continue;
            if (anno.getValue().size() != 0) {
                System.out.println("Executer MGL creation finished");
                return;
            }
            System.out.println("Executer MGL creation running");
            GraphmodelCollector gc = new GraphmodelCollector();
            ExecutableGraphmodel exg = gc.transfrom(graphModel);
            IProject esdslProject = ProjectCreator.createProject(projectName, srcFolders, referencedProjects, requiredBundles, exportedPackages, additionalNatures, (IProgressMonitor)progressMonitor, cleanDirs, false, pluginXML);
            new MGLGenerator(exg).generate("model/", esdslProject);
            new StyleGeneratorTemplate(exg, project).generate("model/", esdslProject);
            new CPDGeneratorTemplate(exg).generate("model/", esdslProject);
            new TracerProjectGenerator().create(exg);
            System.out.println("Executer MGL creation finished");
            return;
        }
    }

    public static String toFirstUpper(String s) {
        return String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1);
    }

    public static String toFirstLower(String s) {
        return String.valueOf(Character.toLowerCase(s.charAt(0))) + s.substring(1);
    }
}

