/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.executer.collector;

import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableContainer;
import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableEdge;
import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableGraphmodel;
import de.jabc.cinco.meta.plugin.executer.compounds.ExecutableNode;
import de.jabc.cinco.meta.plugin.executer.compounds.impl.ExecutableContainerImpl;
import de.jabc.cinco.meta.plugin.executer.compounds.impl.ExecutableEdgeImpl;
import de.jabc.cinco.meta.plugin.executer.compounds.impl.ExecutableGraphmodelImpl;
import de.jabc.cinco.meta.plugin.executer.compounds.impl.ExecutableNodeImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mgl.Edge;
import mgl.GraphModel;
import mgl.MGLModel;
import mgl.ModelElement;
import mgl.Node;
import mgl.NodeContainer;

public class GraphmodelCollector {
    private Map<String, ExecutableEdge> edges = new HashMap<String, ExecutableEdge>();
    private Map<String, ExecutableNode> nodes = new HashMap<String, ExecutableNode>();
    private Map<String, ExecutableContainer> container = new HashMap<String, ExecutableContainer>();
    private Map<String, Set<ExecutableNode>> sources = new HashMap<String, Set<ExecutableNode>>();
    private Map<String, Set<ExecutableNode>> targets = new HashMap<String, Set<ExecutableNode>>();

    public ExecutableGraphmodel transfrom(GraphModel graphModel) {
        ExecutableGraphmodelImpl eg = new ExecutableGraphmodelImpl();
        eg.setGraphModel(graphModel);
        eg.getModelElements().addAll(((MGLModel)graphModel.eContainer()).getEdges().stream().map(n -> this.convertEdge((Edge)n)).collect(Collectors.toList()));
        eg.getModelElements().addAll(((MGLModel)graphModel.eContainer()).getNodes().stream().map(n -> this.convertNode((Node)n)).collect(Collectors.toList()));
        return eg;
    }

    public ExecutableEdge convertEdge(Edge edge) {
        if (this.edges.containsKey(edge.getName())) {
            return this.edges.get(edge.getName());
        }
        ExecutableEdgeImpl ee = new ExecutableEdgeImpl();
        this.edges.put(edge.getName(), ee);
        ee.setModelElement((ModelElement)edge);
        if (edge.getExtends() != null) {
            String key = edge.getExtends().getName();
            if (this.edges.containsKey(key)) {
                ee.setParent(this.edges.get(key));
            } else {
                ee.setParent(this.convertEdge(edge.getExtends()));
            }
        }
        return ee;
    }

    public ExecutableNode convertNode(Node node) {
        ExecutableNode en = null;
        if (node instanceof NodeContainer) {
            if (this.container.containsKey(node.getName())) {
                return this.container.get(node.getName());
            }
            en = new ExecutableContainerImpl();
            this.container.put(node.getName(), (ExecutableContainer)en);
            NodeContainer nodeContainer = (NodeContainer)node;
            ExecutableContainer ec = (ExecutableContainer)en;
            ec.getContainableNodes().addAll(nodeContainer.getContainableElements().stream().flatMap(n -> n.getTypes().stream().map(e -> this.convertNode((Node)e))).collect(Collectors.toList()));
        } else {
            if (this.nodes.containsKey(node.getName())) {
                return this.nodes.get(node.getName());
            }
            en = new ExecutableNodeImpl();
        }
        this.nodes.put(node.getName(), en);
        en.setModelElement(node);
        if (node.getExtends() != null) {
            String key = node.getExtends().getName();
            if (this.nodes.containsKey(key)) {
                en.setParent(this.nodes.get(key));
            } else {
                en.setParent(this.convertNode(node.getExtends()));
            }
        }
        if (en.getParent() != null) {
            en.getIncoming().addAll(en.getParent().getIncoming());
            en.getOutgoing().addAll(en.getParent().getOutgoing());
        }
        en.getIncoming().addAll(node.getIncomingEdgeConnections().stream().flatMap(n -> n.getConnectingEdges().stream().map(e -> this.convertEdge((Edge)e))).collect(Collectors.toSet()));
        en.getOutgoing().addAll(node.getOutgoingEdgeConnections().stream().flatMap(n -> n.getConnectingEdges().stream().map(e -> this.convertEdge((Edge)e))).collect(Collectors.toSet()));
        return en;
    }

    public Map<String, ExecutableEdge> getEdges() {
        return this.edges;
    }

    public void setEdges(Map<String, ExecutableEdge> edges) {
        this.edges = edges;
    }

    public Map<String, ExecutableNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(Map<String, ExecutableNode> nodes) {
        this.nodes = nodes;
    }

    public Map<String, ExecutableContainer> getContainer() {
        return this.container;
    }

    public void setContainer(Map<String, ExecutableContainer> container) {
        this.container = container;
    }

    public Map<String, Set<ExecutableNode>> getSources() {
        return this.sources;
    }

    public void setSources(Map<String, Set<ExecutableNode>> sources) {
        this.sources = sources;
    }

    public Map<String, Set<ExecutableNode>> getTargets() {
        return this.targets;
    }

    public void setTargets(Map<String, Set<ExecutableNode>> targets) {
        this.targets = targets;
    }
}

