/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.gui.preview;

import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import graphmodel.GraphModel;
import info.scce.dime.gui.gui.GUI;
import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class ResourceChangeListener
implements IResourceChangeListener {
    private Set<ListenerEvents> events;

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            this.processAffectedFiles(delta);
        }
    }

    public void processAffectedFiles(IResourceDelta delta) {
    }

    private void handleGuiChanged(IFile iFile) {
    }

    private boolean hasChanged(IResourceDelta child) {
        return child.getKind() == 4 && (child.getFlags() & 0x100) != 0;
    }

    public GUI loadModel(IResource res) {
        long timeStart = System.currentTimeMillis();
        File file = new File(res.getLocation().toOSString());
        ResourceSetImpl resSet = new ResourceSetImpl();
        URI uri = URI.createFileURI((String)file.getAbsolutePath());
        GraphModel eObj = ReferenceRegistry.getInstance().getGraphModelFromURI(uri);
        if (eObj != null && eObj instanceof GUI) {
            return (GUI)eObj;
        }
        Resource resource = resSet.getResource(uri, true);
        for (EObject obj : resource.getContents()) {
            if (!(obj instanceof GUI)) continue;
            ReferenceRegistry.getInstance().addElement((EObject)((GraphModel)obj));
            return (GUI)obj;
        }
        System.out.println("Model " + file.getName() + " not found");
        return null;
    }

    private IFile getFileFromDelta(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        if (iResourceDeltaArray.length != 0) {
            IResourceDelta child = iResourceDeltaArray[0];
            IResource res = child.getResource();
            if (res instanceof IFile) {
                IFile file = (IFile)res;
                return file;
            }
            return this.getFileFromDelta(child);
        }
        return null;
    }

    static /* synthetic */ Set access$0(ResourceChangeListener resourceChangeListener) {
        return resourceChangeListener.events;
    }

    public class DeltaPrinter
    implements IResourceDeltaVisitor {
        public boolean visit(IResourceDelta delta) {
            IResource res = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    ResourceChangeListener.this.events.add(ListenerEvents.ADDED);
                    break;
                }
                case 2: {
                    ResourceChangeListener.this.events.add(ListenerEvents.REMOVED);
                    break;
                }
                case 4: {
                    int flags = delta.getFlags();
                    if ((flags & 0x100) != 0) {
                        ResourceChangeListener.this.events.add(ListenerEvents.CONTENT_CHANGE);
                    }
                    if ((flags & 0x20000) == 0) break;
                    IMarkerDelta[] iMarkerDeltaArray = delta.getMarkerDeltas();
                }
            }
            return true;
        }
    }

    public static enum ListenerEvents {
        ADDED,
        REMOVED,
        CONTENT_CHANGE;

    }
}

