/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.event.api.util;

import com.google.common.base.Objects;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Accessors(value={AccessorType.PUBLIC_GETTER})
public class Fqn
implements Cloneable {
    private static final Pattern CONSTRAINT_PATTERN = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("^ ?(?<primary>\\?|[a-zA-Z0-9_.]+( ?<.*?>)?)( (?<constraint>extends|super) (?<secondary>[a-zA-Z0-9_.]+( ?<.*?>)?))? ?$");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final Pattern GENERICS_PATTERN = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("^(?<fqn>\\?|[a-zA-Z0-9_.]+)( ?< ?(?<generics>.*?) ?>)?$");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private static final Pattern FQN_PATTERN = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("^((?<package>[a-zA-Z_][a-zA-Z0-9_]*(\\.[a-zA-Z_][a-zA-Z0-9_]*)*)\\.)?(?<class>\\?|[a-zA-Z_][a-zA-Z0-9_]*)$");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private String fullyQualifiedName;
    private String packageName;
    private String className;
    private Fqn[] generics;
    private Fqn extendsConstraint;
    private Fqn superConstraint;

    public Fqn(CharSequence fqn) {
        try {
            if (fqn == null) {
                throw new NullPointerException("The parameter \"fqn\" may not be null!");
            }
            try {
                boolean _isEmpty;
                boolean _not_1;
                boolean _not;
                String _string = fqn.toString();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("\\s+");
                String _replaceAll = _string.replaceAll(_builder.toString(), " ");
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("\\$");
                String cleanFqn = _replaceAll.replaceAll(_builder_1.toString(), ".");
                Matcher constraintMatcher = CONSTRAINT_PATTERN.matcher(cleanFqn);
                boolean _matches = constraintMatcher.matches();
                boolean bl = _not = !_matches;
                if (_not) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Constraint regex did not match FQN \"");
                    _builder_2.append((Object)fqn);
                    _builder_2.append("\".");
                    throw new FqnFormatException(_builder_2.toString());
                }
                String primaryFqn = constraintMatcher.group("primary");
                String constraint = constraintMatcher.group("constraint");
                String secondaryFqn = constraintMatcher.group("secondary");
                Matcher genericsMatcher = GENERICS_PATTERN.matcher(primaryFqn);
                boolean _matches_1 = genericsMatcher.matches();
                boolean bl2 = _not_1 = !_matches_1;
                if (_not_1) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("Generics regex did not match FQN \"");
                    _builder_3.append((Object)fqn);
                    _builder_3.append("\".");
                    throw new FqnFormatException(_builder_3.toString());
                }
                this.fullyQualifiedName = genericsMatcher.group("fqn");
                String generics = genericsMatcher.group("generics");
                boolean _equals = Objects.equal((Object)this.fullyQualifiedName, (Object)"?");
                if (_equals) {
                    this.packageName = null;
                    this.className = "?";
                } else {
                    boolean _not_2;
                    Matcher fqnMatcher = FQN_PATTERN.matcher(this.fullyQualifiedName);
                    boolean _matches_2 = fqnMatcher.matches();
                    boolean bl3 = _not_2 = !_matches_2;
                    if (_not_2) {
                        StringConcatenation _builder_4 = new StringConcatenation();
                        _builder_4.append("FQN regex did not match FQN \"");
                        _builder_4.append((Object)fqn);
                        _builder_4.append("\".");
                        throw new FqnFormatException(_builder_4.toString());
                    }
                    this.packageName = fqnMatcher.group("package");
                    this.className = fqnMatcher.group("class");
                }
                Fqn[] _switchResult = null;
                String it = generics;
                boolean _matched = false;
                if (Objects.equal((Object)it, null)) {
                    _matched = true;
                    _switchResult = null;
                }
                if (!_matched && (_isEmpty = it.isEmpty())) {
                    _matched = true;
                    _switchResult = new Fqn[]{};
                }
                if (!_matched) {
                    Functions.Function1<String, Fqn> _function = new Functions.Function1<String, Fqn>(){

                        public Fqn apply(String it) {
                            return new Fqn(it);
                        }
                    };
                    _switchResult = (Fqn[])Conversions.unwrapArray((Object)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)this.splitGenerics(it))), (Functions.Function1)_function), Fqn.class);
                }
                this.generics = _switchResult;
                boolean _matched_1 = false;
                if (Objects.equal((Object)constraint, (Object)"extends")) {
                    Fqn _fqn;
                    _matched_1 = true;
                    this.extendsConstraint = _fqn = new Fqn(secondaryFqn);
                    this.superConstraint = null;
                }
                if (!_matched_1 && Objects.equal((Object)constraint, (Object)"super")) {
                    Fqn _fqn_1;
                    _matched_1 = true;
                    this.extendsConstraint = null;
                    this.superConstraint = _fqn_1 = new Fqn(secondaryFqn);
                }
                if (!_matched_1) {
                    this.extendsConstraint = null;
                    this.superConstraint = null;
                }
                if (this.hasGenerics() && this.hasConstraint()) {
                    StringConcatenation _builder_5 = new StringConcatenation();
                    _builder_5.append("FQN \"");
                    _builder_5.append((Object)fqn);
                    _builder_5.append("\" must not have generics and a constraint at the same time.");
                    throw new FqnFormatException(_builder_5.toString());
                }
                if (this.isWildcard() && this.hasGenerics()) {
                    StringConcatenation _builder_6 = new StringConcatenation();
                    _builder_6.append("FQN \"");
                    _builder_6.append((Object)fqn);
                    _builder_6.append("\" must not be a wildcard and have generics at the same time.");
                    throw new FqnFormatException(_builder_6.toString());
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    throw new FqnFormatException(e, fqn);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Fqn(Type type) {
        if (type == null) {
            throw new NullPointerException("The parameter \"type\" may not be null.");
        }
        String _typeName = type.getTypeName();
        Fqn fqn = new Fqn(_typeName);
        this.fullyQualifiedName = fqn.fullyQualifiedName;
        this.packageName = fqn.packageName;
        this.className = fqn.className;
        this.generics = fqn.generics;
        this.extendsConstraint = fqn.extendsConstraint;
        this.superConstraint = fqn.superConstraint;
    }

    private String[] splitGenerics(String generics) {
        ArrayList separatorIndices = CollectionLiterals.newArrayList((Object[])new Integer[]{-1});
        int openBrackets = 0;
        Iterable _indexed = IterableExtensions.indexed((Iterable)((Iterable)Conversions.doWrapArray((Object)generics.toCharArray())));
        for (Pair pair : _indexed) {
            String _string = ((Character)pair.getValue()).toString();
            boolean _matched = false;
            if (Objects.equal((Object)_string, (Object)"<")) {
                _matched = true;
                int _openBrackets = openBrackets;
                openBrackets = _openBrackets + 1;
            }
            if (!_matched && Objects.equal((Object)_string, (Object)">")) {
                _matched = true;
                int _openBrackets_1 = openBrackets;
                openBrackets = _openBrackets_1 - 1;
            }
            if (_matched || !Objects.equal((Object)_string, (Object)",")) continue;
            _matched = true;
            if (openBrackets != 0) continue;
            separatorIndices.add((Integer)pair.getKey());
        }
        separatorIndices.add(generics.length());
        int _size = separatorIndices.size();
        int _minus = _size - 1;
        String[] result = new String[_minus];
        int _size_1 = separatorIndices.size();
        int _minus_1 = _size_1 - 1;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _minus_1, true);
        for (Integer i : _doubleDotLessThan) {
            String substring;
            Integer _get = (Integer)separatorIndices.get(i);
            int start = _get + 1;
            Integer end = (Integer)separatorIndices.get(i + 1);
            result[i.intValue()] = substring = generics.substring(start, end);
        }
        return result;
    }

    public Fqn clone() {
        String _fullyQualifiedNameWithSuffix = this.getFullyQualifiedNameWithSuffix();
        return new Fqn(_fullyQualifiedNameWithSuffix);
    }

    public void setFullyQualifiedName(String newValue) {
        try {
            if (newValue == null) {
                throw new NullPointerException("The fully qualified name may not be null.");
            }
            boolean _isEmpty = newValue.isEmpty();
            if (_isEmpty) {
                throw new FqnFormatException("The fully qualified name may not be empty.");
            }
            boolean _equals = Objects.equal((Object)newValue, (Object)"?");
            if (_equals) {
                this.fullyQualifiedName = "?";
                this.packageName = null;
                this.className = "?";
                this.generics = null;
            } else {
                boolean _not;
                Matcher fqnMatcher = FQN_PATTERN.matcher(newValue);
                boolean _matches = fqnMatcher.matches();
                boolean bl = _not = !_matches;
                if (_not) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("FQN regex did not match FQN \"");
                    _builder.append(newValue);
                    _builder.append("\".");
                    throw new FqnFormatException(_builder.toString());
                }
                this.fullyQualifiedName = newValue;
                this.packageName = fqnMatcher.group("package");
                this.className = fqnMatcher.group("class");
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void setPackageName(String newValue) {
        try {
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)newValue);
            if (_isNullOrEmpty) {
                this.fullyQualifiedName = this.className;
                this.packageName = null;
            } else {
                boolean _isWildcard = this.isWildcard();
                if (_isWildcard) {
                    throw new FqnFormatException("The package name must be null, because this FQN is a wildcard (\"?\").");
                }
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(newValue);
                _builder.append(".");
                _builder.append(this.className);
                this.setFullyQualifiedName(_builder.toString());
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void setClassName(String newValue) {
        try {
            if (newValue == null) {
                throw new NullPointerException("The class name may not be null.");
            }
            boolean _isEmpty = newValue.isEmpty();
            if (_isEmpty) {
                throw new FqnFormatException("The class name may not be empty.");
            }
            boolean _equals = Objects.equal((Object)newValue, (Object)"?");
            if (_equals) {
                this.setFullyQualifiedName("?");
            } else {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(this.packageName);
                _builder.append(".");
                _builder.append(newValue);
                this.setFullyQualifiedName(_builder.toString());
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void setGenerics(Fqn[] newValue) {
        try {
            if (newValue == null) {
                this.generics = null;
            } else {
                boolean _isWildcard = this.isWildcard();
                if (_isWildcard) {
                    throw new FqnFormatException("The generics must be null, because this FQN is a wildcard (\"?\").");
                }
                Functions.Function1<Fqn, Boolean> _function = new Functions.Function1<Fqn, Boolean>(){

                    public Boolean apply(Fqn it) {
                        return it.isPrimitive();
                    }
                };
                boolean _exists = IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)newValue)), (Functions.Function1)_function);
                if (_exists) {
                    throw new FqnFormatException("The generics must not contain primitive types.");
                }
                this.generics = newValue;
                this.extendsConstraint = null;
                this.superConstraint = null;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void setExtendsConstraint(Fqn newValue) {
        try {
            if (newValue == null) {
                this.extendsConstraint = null;
            } else {
                boolean _isWildcard = newValue.isWildcard();
                if (_isWildcard) {
                    throw new FqnFormatException("The constraint must not be a wildcard (\"?\").");
                }
                boolean _isPrimitive = newValue.isPrimitive();
                if (_isPrimitive) {
                    throw new FqnFormatException("The constraint must not be a primitive type.");
                }
                boolean _hasConstraint = newValue.hasConstraint();
                if (_hasConstraint) {
                    throw new FqnFormatException("The constraint must not have a constraint itself.");
                }
                this.generics = null;
                this.extendsConstraint = newValue;
                this.superConstraint = null;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void setSuperConstraint(Fqn newValue) {
        try {
            if (newValue == null) {
                this.superConstraint = null;
            } else {
                boolean _isWildcard = newValue.isWildcard();
                if (_isWildcard) {
                    throw new FqnFormatException("The constraint must not be a wildcard (\"?\").");
                }
                boolean _isPrimitive = newValue.isPrimitive();
                if (_isPrimitive) {
                    throw new FqnFormatException("The constraint must not be a primitive type.");
                }
                boolean _hasConstraint = newValue.hasConstraint();
                if (_hasConstraint) {
                    throw new FqnFormatException("The constraint must not have a constraint itself.");
                }
                this.generics = null;
                this.extendsConstraint = null;
                this.superConstraint = newValue;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void replaceAll(final String search, final String replacement) {
        boolean _equals = Objects.equal((Object)this.fullyQualifiedName, (Object)search);
        if (_equals) {
            this.setFullyQualifiedName(replacement);
        }
        if ((List)Conversions.doWrapArray((Object)this.generics) != null) {
            Consumer<Fqn> _function = new Consumer<Fqn>(){

                @Override
                public void accept(Fqn it) {
                    it.replaceAll(search, replacement);
                }
            };
            ((List)Conversions.doWrapArray((Object)this.generics)).forEach(_function);
        }
        if (this.extendsConstraint != null) {
            this.extendsConstraint.replaceAll(search, replacement);
        }
        if (this.superConstraint != null) {
            this.superConstraint.replaceAll(search, replacement);
        }
    }

    public String getFullyQualifiedNameWithSuffix() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(this.fullyQualifiedName);
        String _genericsSuffix = this.getGenericsSuffix();
        _builder.append(_genericsSuffix);
        String _constraintSuffix = this.getConstraintSuffix();
        _builder.append(_constraintSuffix);
        return _builder.toString();
    }

    public String getFullyQualifiedNameWithGenerics() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(this.fullyQualifiedName);
        String _genericsSuffix = this.getGenericsSuffix();
        _builder.append(_genericsSuffix);
        return _builder.toString();
    }

    public String getFullyQualifiedNameWithConstraint() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(this.fullyQualifiedName);
        String _constraintSuffix = this.getConstraintSuffix();
        _builder.append(_constraintSuffix);
        return _builder.toString();
    }

    public String getGenericsSuffix() {
        String _xifexpression = null;
        boolean _hasGenerics = this.hasGenerics();
        if (_hasGenerics) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<");
            Functions.Function1<Fqn, CharSequence> _function = new Functions.Function1<Fqn, CharSequence>(){

                public CharSequence apply(Fqn it) {
                    return it.getFullyQualifiedNameWithSuffix();
                }
            };
            String _join = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)this.generics)), (CharSequence)", ", (Functions.Function1)_function);
            _builder.append(_join);
            _builder.append(">");
            _xifexpression = _builder.toString();
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    public String getConstraintSuffix() {
        String _xifexpression = null;
        boolean _hasExtendsConstraint = this.hasExtendsConstraint();
        if (_hasExtendsConstraint) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(" ");
            _builder.append("extends ");
            String _fullyQualifiedNameWithSuffix = this.extendsConstraint.getFullyQualifiedNameWithSuffix();
            _builder.append(_fullyQualifiedNameWithSuffix, " ");
            _xifexpression = _builder.toString();
        } else {
            String _xifexpression_1 = null;
            boolean _hasSuperConstraint = this.hasSuperConstraint();
            if (_hasSuperConstraint) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(" ");
                _builder_1.append("super ");
                String _fullyQualifiedNameWithSuffix_1 = this.superConstraint.getFullyQualifiedNameWithSuffix();
                _builder_1.append(_fullyQualifiedNameWithSuffix_1, " ");
                _xifexpression_1 = _builder_1.toString();
            } else {
                _xifexpression_1 = "";
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public boolean hasPackageName() {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.packageName);
        return !_isNullOrEmpty;
    }

    public boolean isWildcard() {
        return Objects.equal((Object)this.className, (Object)"?");
    }

    public boolean hasGenerics() {
        return this.generics != null;
    }

    public boolean hasDiamond() {
        return this.hasGenerics() && ((List)Conversions.doWrapArray((Object)this.generics)).isEmpty();
    }

    public boolean hasConstraint() {
        return this.hasExtendsConstraint() || this.hasSuperConstraint();
    }

    public boolean hasExtendsConstraint() {
        return this.extendsConstraint != null;
    }

    public boolean hasSuperConstraint() {
        return this.superConstraint != null;
    }

    public boolean isJavaLangPackage() {
        return Objects.equal((Object)this.packageName, (Object)"java.lang");
    }

    public boolean isPrimitive() {
        boolean _xblockexpression = false;
        List primitives = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"byte", "short", "int", "long", "float", "double", "char", "boolean", "void"}));
        _xblockexpression = primitives.contains(this.fullyQualifiedName);
        return _xblockexpression;
    }

    public boolean isPrimitiveWrapper() {
        boolean _xblockexpression = false;
        List primitiveWrappers = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"Byte", "Short", "Integer", "Long", "Float", "Double", "Character", "Boolean", "Void"}));
        _xblockexpression = primitiveWrappers.contains(this.className) && (StringExtensions.isNullOrEmpty((String)this.packageName) || this.isJavaLangPackage());
        return _xblockexpression;
    }

    public Fqn wrapped() {
        Fqn _xifexpression = null;
        boolean _isPrimitive = this.isPrimitive();
        if (_isPrimitive) {
            Fqn _switchResult = null;
            String className = this.className;
            boolean _matched = false;
            if (Objects.equal((Object)className, (Object)"byte")) {
                _matched = true;
                _switchResult = new Fqn((Type)((Object)Byte.class));
            }
            if (!_matched && Objects.equal((Object)className, (Object)"short")) {
                _matched = true;
                _switchResult = new Fqn((Type)((Object)Short.class));
            }
            if (!_matched && Objects.equal((Object)className, (Object)"int")) {
                _matched = true;
                _switchResult = new Fqn((Type)((Object)Integer.class));
            }
            if (!_matched && Objects.equal((Object)className, (Object)"long")) {
                _matched = true;
                _switchResult = new Fqn((Type)((Object)Long.class));
            }
            if (!_matched && Objects.equal((Object)className, (Object)"float")) {
                _matched = true;
                _switchResult = new Fqn((Type)((Object)Float.class));
            }
            if (!_matched && Objects.equal((Object)className, (Object)"double")) {
                _matched = true;
                _switchResult = new Fqn((Type)((Object)Double.class));
            }
            if (!_matched && Objects.equal((Object)className, (Object)"char")) {
                _matched = true;
                _switchResult = new Fqn((Type)((Object)Character.class));
            }
            if (!_matched && Objects.equal((Object)className, (Object)"boolean")) {
                _matched = true;
                _switchResult = new Fqn((Type)((Object)Boolean.class));
            }
            if (!_matched && Objects.equal((Object)className, (Object)"void")) {
                _matched = true;
                _switchResult = new Fqn((Type)((Object)Void.class));
            }
            _xifexpression = _switchResult;
        } else {
            _xifexpression = this.clone();
        }
        return _xifexpression;
    }

    public Fqn unwrapped() {
        Fqn _xifexpression = null;
        boolean _isPrimitiveWrapper = this.isPrimitiveWrapper();
        if (_isPrimitiveWrapper) {
            Fqn _switchResult = null;
            String className = this.className;
            boolean _matched = false;
            if (Objects.equal((Object)className, (Object)"Byte")) {
                _matched = true;
                _switchResult = new Fqn(Byte.TYPE);
            }
            if (!_matched && Objects.equal((Object)className, (Object)"Short")) {
                _matched = true;
                _switchResult = new Fqn(Short.TYPE);
            }
            if (!_matched && Objects.equal((Object)className, (Object)"Integer")) {
                _matched = true;
                _switchResult = new Fqn(Integer.TYPE);
            }
            if (!_matched && Objects.equal((Object)className, (Object)"Long")) {
                _matched = true;
                _switchResult = new Fqn(Long.TYPE);
            }
            if (!_matched && Objects.equal((Object)className, (Object)"Float")) {
                _matched = true;
                _switchResult = new Fqn(Float.TYPE);
            }
            if (!_matched && Objects.equal((Object)className, (Object)"Double")) {
                _matched = true;
                _switchResult = new Fqn(Double.TYPE);
            }
            if (!_matched && Objects.equal((Object)className, (Object)"Character")) {
                _matched = true;
                _switchResult = new Fqn(Character.TYPE);
            }
            if (!_matched && Objects.equal((Object)className, (Object)"Boolean")) {
                _matched = true;
                _switchResult = new Fqn(Boolean.TYPE);
            }
            if (!_matched && Objects.equal((Object)className, (Object)"Void")) {
                _matched = true;
                _switchResult = new Fqn(Void.TYPE);
            }
            _xifexpression = _switchResult;
        } else {
            _xifexpression = this.clone();
        }
        return _xifexpression;
    }

    public boolean check() {
        return this.operator_doubleArrow(this.isWildcard(), !this.hasPackageName() && !this.hasGenerics()) && this.operator_doubleArrow(this.isPrimitive() || this.isPrimitiveWrapper(), !this.hasGenerics() && !this.hasConstraint()) && this.operator_doubleArrow(this.hasGenerics(), !this.isWildcard() && !this.hasConstraint() && IterableExtensions.forall((Iterable)((Iterable)Conversions.doWrapArray((Object)this.generics)), (Functions.Function1)new Functions.Function1<Fqn, Boolean>(){

            public Boolean apply(Fqn it) {
                boolean _isPrimitive = it.isPrimitive();
                return !_isPrimitive;
            }
        }) && IterableExtensions.forall((Iterable)((Iterable)Conversions.doWrapArray((Object)this.generics)), (Functions.Function1)new Functions.Function1<Fqn, Boolean>(){

            public Boolean apply(Fqn it) {
                return it.check();
            }
        })) && this.operator_doubleArrow(this.hasExtendsConstraint(), !this.hasGenerics() && !this.hasSuperConstraint() && !this.extendsConstraint.isWildcard() && !this.extendsConstraint.isPrimitive() && !this.extendsConstraint.hasConstraint() && this.extendsConstraint.check()) && this.operator_doubleArrow(this.hasSuperConstraint(), !this.hasGenerics() && !this.hasExtendsConstraint() && !this.superConstraint.isWildcard() && !this.superConstraint.isPrimitive() && !this.superConstraint.hasConstraint() && this.superConstraint.check());
    }

    private boolean operator_doubleArrow(boolean left, boolean right) {
        return !left || right;
    }

    @Pure
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Pure
    public String getPackageName() {
        return this.packageName;
    }

    @Pure
    public String getClassName() {
        return this.className;
    }

    @Pure
    public Fqn[] getGenerics() {
        return this.generics;
    }

    @Pure
    public Fqn getExtendsConstraint() {
        return this.extendsConstraint;
    }

    @Pure
    public Fqn getSuperConstraint() {
        return this.superConstraint;
    }

    @Accessors
    public static class FqnFormatException
    extends Exception {
        private final Exception originalException;

        public FqnFormatException(String message) {
            super(message);
            this.originalException = this;
        }

        public FqnFormatException(final Exception originalException, final CharSequence fqn) {
            super(new Functions.Function0<String>(){

                public String apply() {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Could not parse FQN \"");
                    _builder.append((Object)fqn);
                    _builder.append("\" because of a subseqent exception:");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _xifexpression = null;
                    _xifexpression = originalException instanceof FqnFormatException ? ((FqnFormatException)originalException).originalException.getMessage() : originalException.getMessage();
                    _builder.append(_xifexpression, "\t");
                    _builder.newLineIfNotEmpty();
                    return _builder.toString();
                }
            }.apply());
            this.originalException = originalException instanceof FqnFormatException ? ((FqnFormatException)originalException).originalException : originalException;
        }

        @Pure
        public Exception getOriginalException() {
            return this.originalException;
        }
    }
}

