/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.event.api.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import de.jabc.cinco.meta.core.event.util.EventCoreExtension;
import de.jabc.cinco.meta.plugin.event.api.event.ContainerEvent;
import de.jabc.cinco.meta.plugin.event.api.event.EdgeEvent;
import de.jabc.cinco.meta.plugin.event.api.event.Event;
import de.jabc.cinco.meta.plugin.event.api.event.GraphModelEvent;
import de.jabc.cinco.meta.plugin.event.api.event.NodeEvent;
import de.jabc.cinco.meta.plugin.event.api.payload.Payload;
import de.jabc.cinco.meta.plugin.event.api.util.Color;
import de.jabc.cinco.meta.plugin.event.api.util.DayOfWeek;
import de.jabc.cinco.meta.plugin.event.api.util.EventEnum;
import de.jabc.cinco.meta.plugin.event.api.util.Fqn;
import de.jabc.cinco.meta.plugin.event.api.util.Month;
import de.jabc.cinco.meta.plugin.event.api.util.ResizeDirectionSet;
import graphmodel.Container;
import graphmodel.Direction;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.Node;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mgl.Annotatable;
import mgl.Annotation;
import mgl.Edge;
import mgl.MGLModel;
import mgl.ModelElement;
import mgl.NodeContainer;
import mgl.UserDefinedType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class EventApiExtension
extends EventCoreExtension {
    public static final String EVENT_ANNOTATION_NAME = "event";
    public static final String EVENT_API_PACKAGE_SUFFIX = "event";
    public static final String PAYLOAD_API_PACKAGE_SUFFIX = "payload";
    private static final Pattern MGL_FILE_NAME_PATTERN = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("^.*?(?<fileName>[\\w\\-. ]+)\\.mgl$");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();

    public String getEventApiPluginID() {
        return "de.jabc.cinco.meta.plugin.event.api";
    }

    public String getEventAnnotationName() {
        return "event";
    }

    public boolean isEventAnnotation(Annotation annotation) {
        String _name = annotation.getName();
        return Objects.equal((Object)_name, (Object)"event");
    }

    public boolean hasEventAnnotation(Annotatable element) {
        Functions.Function1<Annotation, Boolean> _function = new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation it) {
                return EventApiExtension.this.isEventAnnotation(it);
            }
        };
        return IterableExtensions.exists((Iterable)element.getAnnotations(), (Functions.Function1)_function);
    }

    public Annotation getEventAnnotation(Annotatable element) {
        Functions.Function1<Annotation, Boolean> _function = new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation it) {
                return EventApiExtension.this.isEventAnnotation(it);
            }
        };
        return (Annotation)IterableExtensions.findFirst((Iterable)element.getAnnotations(), (Functions.Function1)_function);
    }

    public boolean isEventEnabled(ModelElement element) {
        boolean _hasEventAnnotation = this.hasEventAnnotation((Annotatable)element);
        if (_hasEventAnnotation) {
            return true;
        }
        ModelElement superElement = this.getSuperElement(element);
        if (superElement == null) {
            return false;
        }
        return this.isEventEnabled(superElement);
    }

    public String getPayloadApiProjectName() {
        return this.getEventApiPluginID();
    }

    public Class<?> getPayloadApiClass() {
        return Payload.class;
    }

    public Fqn getPayloadApiFqn() {
        return this.toFqn(this.getPayloadApiClass());
    }

    public String getEventApiProjectName() {
        return this.getEventApiPluginID();
    }

    public Class<?> getEventApiClass() {
        return Event.class;
    }

    public Class<?> getEventApiClass(IdentifiableElement element) {
        Class _switchResult = null;
        boolean _matched = false;
        if (element instanceof GraphModel) {
            _matched = true;
            _switchResult = GraphModelEvent.class;
        }
        if (!_matched && element instanceof Container) {
            _matched = true;
            _switchResult = ContainerEvent.class;
        }
        if (!_matched && element instanceof Node) {
            _matched = true;
            _switchResult = NodeEvent.class;
        }
        if (!_matched && element instanceof graphmodel.Edge) {
            _matched = true;
            _switchResult = EdgeEvent.class;
        }
        if (!_matched) {
            throw new IllegalArgumentException();
        }
        return _switchResult;
    }

    public Class<?> getEventApiClass(ModelElement element) {
        Class _switchResult = null;
        boolean _matched = false;
        if (element instanceof mgl.GraphModel) {
            _matched = true;
            _switchResult = GraphModelEvent.class;
        }
        if (!_matched && element instanceof NodeContainer) {
            _matched = true;
            _switchResult = ContainerEvent.class;
        }
        if (!_matched && element instanceof mgl.Node) {
            _matched = true;
            _switchResult = NodeEvent.class;
        }
        if (!_matched && element instanceof Edge) {
            _matched = true;
            _switchResult = EdgeEvent.class;
        }
        if (!_matched) {
            throw new IllegalArgumentException();
        }
        return _switchResult;
    }

    public Fqn getEventApiFqn() {
        return this.toFqn(this.getEventApiClass());
    }

    public Fqn getEventApiFqn(IdentifiableElement element) {
        return this.toFqn(this.getEventApiClass(element));
    }

    public Fqn getEventApiFqn(ModelElement element) {
        return this.toFqn(this.getEventApiClass(element));
    }

    public boolean hasCreateEvent(ModelElement element) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (element instanceof mgl.GraphModel) {
            _matched = true;
        }
        if (!_matched && element instanceof mgl.Node) {
            _matched = true;
        }
        if (!_matched && element instanceof Edge) {
            _matched = true;
        }
        if (_matched) {
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public EventEnum getCanCreateEvent(ModelElement element) {
        EventEnum _switchResult = null;
        boolean _matched = false;
        if (element instanceof mgl.GraphModel) {
            _matched = true;
            _switchResult = EventEnum.CAN_CREATE_GRAPH_MODEL;
        }
        if (!_matched && element instanceof mgl.Node) {
            _matched = true;
            _switchResult = EventEnum.CAN_CREATE_NODE;
        }
        if (!_matched && element instanceof Edge) {
            _matched = true;
            _switchResult = EventEnum.CAN_CREATE_EDGE;
        }
        if (!_matched) {
            throw new IllegalArgumentException();
        }
        return _switchResult;
    }

    public EventEnum getPreCreateEvent(ModelElement element) {
        EventEnum _switchResult = null;
        boolean _matched = false;
        if (element instanceof mgl.GraphModel) {
            _matched = true;
            _switchResult = EventEnum.PRE_CREATE_GRAPH_MODEL;
        }
        if (!_matched && element instanceof mgl.Node) {
            _matched = true;
            _switchResult = EventEnum.PRE_CREATE_NODE;
        }
        if (!_matched && element instanceof Edge) {
            _matched = true;
            _switchResult = EventEnum.PRE_CREATE_EDGE;
        }
        if (!_matched) {
            throw new IllegalArgumentException();
        }
        return _switchResult;
    }

    public EventEnum getPostCreateEvent(ModelElement element) {
        EventEnum _switchResult = null;
        boolean _matched = false;
        if (element instanceof mgl.GraphModel) {
            _matched = true;
            _switchResult = EventEnum.POST_CREATE_GRAPH_MODEL;
        }
        if (!_matched && element instanceof mgl.Node) {
            _matched = true;
            _switchResult = EventEnum.POST_CREATE_NODE;
        }
        if (!_matched && element instanceof Edge) {
            _matched = true;
            _switchResult = EventEnum.POST_CREATE_EDGE;
        }
        if (!_matched) {
            throw new IllegalArgumentException();
        }
        return _switchResult;
    }

    public ModelElement getSuperElement(ModelElement element) {
        mgl.GraphModel _switchResult = null;
        ModelElement it = element;
        boolean _matched = false;
        if (it instanceof mgl.GraphModel) {
            _matched = true;
            _switchResult = ((mgl.GraphModel)it).getExtends();
        }
        if (!_matched && it instanceof NodeContainer) {
            _matched = true;
            _switchResult = ((NodeContainer)it).getExtends();
        }
        if (!_matched && it instanceof mgl.Node) {
            _matched = true;
            _switchResult = ((mgl.Node)it).getExtends();
        }
        if (!_matched && it instanceof Edge) {
            _matched = true;
            _switchResult = ((Edge)it).getExtends();
        }
        if (!_matched && it instanceof UserDefinedType) {
            _matched = true;
            _switchResult = ((UserDefinedType)it).getExtends();
        }
        if (!_matched) {
            throw new IllegalArgumentException();
        }
        return _switchResult;
    }

    public Iterable<EventEnum> getEvents() {
        return EventEnum.EVENTS;
    }

    public Iterable<EventEnum> getEvents(final ModelElement element) {
        Functions.Function1<EventEnum, Boolean> _function = new Functions.Function1<EventEnum, Boolean>(){

            public Boolean apply(EventEnum it) {
                return it.accepts(element);
            }
        };
        return IterableExtensions.filter(this.getEvents(), (Functions.Function1)_function);
    }

    public Iterable<EventEnum> getEvents(final IdentifiableElement element) {
        Functions.Function1<EventEnum, Boolean> _function = new Functions.Function1<EventEnum, Boolean>(){

            public Boolean apply(EventEnum it) {
                return it.accepts(element);
            }
        };
        return IterableExtensions.filter(this.getEvents(), (Functions.Function1)_function);
    }

    public Fqn toFqn(CharSequence fqn) {
        return new Fqn(fqn);
    }

    public Fqn toFqn(Type type) {
        return new Fqn(type);
    }

    public Class<?> getGraphmodelClass(Class<?> mglClass) {
        boolean _implementsOrExtends_7;
        boolean _implementsOrExtends_6;
        boolean _implementsOrExtends_5;
        boolean _implementsOrExtends_4;
        boolean _implementsOrExtends_3;
        boolean _implementsOrExtends_2;
        boolean _implementsOrExtends_1;
        Class<GraphModel> _switchResult = null;
        Class<?> it = mglClass;
        boolean _matched = false;
        boolean _implementsOrExtends = this.implementsOrExtends(it, (Type)((Object)mgl.GraphModel.class));
        if (_implementsOrExtends) {
            _matched = true;
            _switchResult = GraphModel.class;
        }
        if (!_matched && (_implementsOrExtends_1 = this.implementsOrExtends(it, (Type)((Object)NodeContainer.class)))) {
            _matched = true;
            _switchResult = Container.class;
        }
        if (!_matched && (_implementsOrExtends_2 = this.implementsOrExtends(it, (Type)((Object)mgl.Node.class)))) {
            _matched = true;
            _switchResult = Node.class;
        }
        if (!_matched && (_implementsOrExtends_3 = this.implementsOrExtends(it, (Type)((Object)Edge.class)))) {
            _matched = true;
            _switchResult = graphmodel.Edge.class;
        }
        if (!_matched && (_implementsOrExtends_4 = this.implementsOrExtends(it, (Type)((Object)GraphModel.class)))) {
            _matched = true;
            _switchResult = GraphModel.class;
        }
        if (!_matched && (_implementsOrExtends_5 = this.implementsOrExtends(it, (Type)((Object)Container.class)))) {
            _matched = true;
            _switchResult = Container.class;
        }
        if (!_matched && (_implementsOrExtends_6 = this.implementsOrExtends(it, (Type)((Object)Node.class)))) {
            _matched = true;
            _switchResult = Node.class;
        }
        if (!_matched && (_implementsOrExtends_7 = this.implementsOrExtends(it, (Type)((Object)graphmodel.Edge.class)))) {
            _matched = true;
            _switchResult = graphmodel.Edge.class;
        }
        if (!_matched) {
            throw new IllegalArgumentException();
        }
        return _switchResult;
    }

    public Class<?> getGraphmodelClass(IdentifiableElement element) {
        return this.getGraphmodelClass(element.getClass());
    }

    public Class<?> getGraphmodelClass(ModelElement element) {
        return this.getGraphmodelClass(element.getClass());
    }

    public Class<?> getMglClass(Class<?> graphmodelClass) {
        boolean _implementsOrExtends_7;
        boolean _implementsOrExtends_6;
        boolean _implementsOrExtends_5;
        boolean _implementsOrExtends_4;
        boolean _implementsOrExtends_3;
        boolean _implementsOrExtends_2;
        boolean _implementsOrExtends_1;
        Class<mgl.GraphModel> _switchResult = null;
        Class<?> it = graphmodelClass;
        boolean _matched = false;
        boolean _implementsOrExtends = this.implementsOrExtends(it, (Type)((Object)GraphModel.class));
        if (_implementsOrExtends) {
            _matched = true;
            _switchResult = mgl.GraphModel.class;
        }
        if (!_matched && (_implementsOrExtends_1 = this.implementsOrExtends(it, (Type)((Object)Container.class)))) {
            _matched = true;
            _switchResult = NodeContainer.class;
        }
        if (!_matched && (_implementsOrExtends_2 = this.implementsOrExtends(it, (Type)((Object)Node.class)))) {
            _matched = true;
            _switchResult = mgl.Node.class;
        }
        if (!_matched && (_implementsOrExtends_3 = this.implementsOrExtends(it, (Type)((Object)graphmodel.Edge.class)))) {
            _matched = true;
            _switchResult = Edge.class;
        }
        if (!_matched && (_implementsOrExtends_4 = this.implementsOrExtends(it, (Type)((Object)mgl.GraphModel.class)))) {
            _matched = true;
            _switchResult = mgl.GraphModel.class;
        }
        if (!_matched && (_implementsOrExtends_5 = this.implementsOrExtends(it, (Type)((Object)NodeContainer.class)))) {
            _matched = true;
            _switchResult = NodeContainer.class;
        }
        if (!_matched && (_implementsOrExtends_6 = this.implementsOrExtends(it, (Type)((Object)mgl.Node.class)))) {
            _matched = true;
            _switchResult = mgl.Node.class;
        }
        if (!_matched && (_implementsOrExtends_7 = this.implementsOrExtends(it, (Type)((Object)Edge.class)))) {
            _matched = true;
            _switchResult = Edge.class;
        }
        if (!_matched) {
            throw new IllegalArgumentException();
        }
        return _switchResult;
    }

    public Class<?> getMglClass(IdentifiableElement element) {
        return this.getMglClass(element.getClass());
    }

    public Class<?> getMglClass(ModelElement element) {
        return this.getMglClass(element.getClass());
    }

    public boolean implementsOrExtends(Class<?> subClass, final Type superClass) {
        boolean _equals = Objects.equal(subClass, (Object)superClass);
        if (_equals) {
            return true;
        }
        Class<?>[] interfaces = subClass.getInterfaces();
        if (!IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray(interfaces))) && IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray(interfaces)), (Functions.Function1)new Functions.Function1<Class<?>, Boolean>(){

            public Boolean apply(Class<?> it) {
                return EventApiExtension.this.implementsOrExtends(it, superClass);
            }
        })) {
            return true;
        }
        Class<?> superclass = subClass.getSuperclass();
        return superclass != null && this.implementsOrExtends(superclass, superClass);
    }

    public boolean implementsOrExtends(Class<?> subClass, final CharSequence superClass) {
        String _name = subClass.getName();
        boolean _equals = Objects.equal((Object)_name, (Object)superClass);
        if (_equals) {
            return true;
        }
        Class<?>[] interfaces = subClass.getInterfaces();
        if (!IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray(interfaces))) && IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray(interfaces)), (Functions.Function1)new Functions.Function1<Class<?>, Boolean>(){

            public Boolean apply(Class<?> it) {
                return EventApiExtension.this.implementsOrExtends(it, superClass);
            }
        })) {
            return true;
        }
        Class<?> superclass = subClass.getSuperclass();
        return superclass != null && this.implementsOrExtends(superclass, superClass);
    }

    public String getModelPackageName(MGLModel model) {
        StringConcatenation _builder = new StringConcatenation();
        String _package = model.getPackage();
        _builder.append(_package);
        _builder.append(".");
        String _lowerCase = this.getModelFileName(model).toLowerCase();
        _builder.append(_lowerCase);
        return _builder.toString();
    }

    public String getModelFileName(MGLModel model) {
        String _fileString;
        URI modelResourceUri = model.eResource().getURI();
        String platformString = modelResourceUri.toPlatformString(true);
        String _elvis = null;
        _elvis = platformString != null ? platformString : (_fileString = modelResourceUri.toFileString());
        String uriString = _elvis;
        Matcher matcher = MGL_FILE_NAME_PATTERN.matcher(uriString);
        boolean _matches = matcher.matches();
        if (_matches) {
            return matcher.group("fileName");
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The name of the MGL model \"");
        String _package = model.getPackage();
        _builder.append(_package);
        _builder.append("\" could not be resolved properly.");
        throw new IllegalStateException(_builder.toString());
    }

    public MGLModel getModel(ModelElement element) {
        EObject _eContainer;
        MGLModel _switchResult = null;
        ModelElement it = element;
        boolean _matched = false;
        if (it instanceof mgl.GraphModel) {
            _matched = true;
            _eContainer = ((mgl.GraphModel)it).eContainer();
            _switchResult = (MGLModel)_eContainer;
        }
        if (!_matched && it instanceof NodeContainer) {
            _matched = true;
            _eContainer = ((NodeContainer)it).eContainer();
            _switchResult = (MGLModel)_eContainer;
        }
        if (!_matched && it instanceof mgl.Node) {
            _matched = true;
            _eContainer = ((mgl.Node)it).eContainer();
            _switchResult = (MGLModel)_eContainer;
        }
        if (!_matched && it instanceof Edge) {
            _matched = true;
            _eContainer = ((Edge)it).eContainer();
            _switchResult = (MGLModel)_eContainer;
        }
        if (!_matched && it instanceof UserDefinedType) {
            _matched = true;
            _eContainer = ((UserDefinedType)it).eContainer();
            _switchResult = (MGLModel)_eContainer;
        }
        if (!_matched) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Can not determine MGLModel for ");
            _builder.append((Object)it);
            throw new RuntimeException(_builder.toString());
        }
        return _switchResult;
    }

    public String getElementPackageName(ModelElement element) {
        return this.getModelPackageName(this.getModel(element));
    }

    public String getElementClassName(ModelElement element) {
        return StringExtensions.toFirstUpper((String)element.getName());
    }

    public Fqn getElementFqn(ModelElement element) {
        StringConcatenation _builder = new StringConcatenation();
        String _elementPackageName = this.getElementPackageName(element);
        _builder.append(_elementPackageName);
        _builder.append(".");
        String _elementClassName = this.getElementClassName(element);
        _builder.append(_elementClassName);
        return this.toFqn((CharSequence)_builder);
    }

    public Iterable<ModelElement> getEventEnabledElements(MGLModel model) {
        EList _nodes = model.getNodes();
        EList _edges = model.getEdges();
        Iterable _plus = Iterables.concat((Iterable)_nodes, (Iterable)_edges);
        EList _graphModels = model.getGraphModels();
        Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                return EventApiExtension.this.isEventEnabled(it);
            }
        };
        return IterableExtensions.filter((Iterable)Iterables.concat((Iterable)_plus, (Iterable)_graphModels), (Functions.Function1)_function);
    }

    public Iterable<ModelElement> getEventEnabledElements(mgl.GraphModel graphModel) {
        return this.getEventEnabledElements(this.getModel((ModelElement)graphModel));
    }

    public Iterable<ModelElement> getEventEnabledElements(MGLModel model, final EventEnum event) {
        Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement element) {
                return event.accepts(element);
            }
        };
        return IterableExtensions.filter(this.getEventEnabledElements(model), (Functions.Function1)_function);
    }

    public Iterable<ModelElement> getEventEnabledElements(mgl.GraphModel graphModel, final EventEnum event) {
        Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement element) {
                return event.accepts(element);
            }
        };
        return IterableExtensions.filter(this.getEventEnabledElements(graphModel), (Functions.Function1)_function);
    }

    public HashSet<ModelElement> getAncestorElements(ModelElement element) {
        HashSet resultSet = CollectionLiterals.newHashSet();
        ModelElement currentElement = element;
        while (currentElement != null) {
            resultSet.add(currentElement);
            currentElement = this.getSuperElement(currentElement);
        }
        return resultSet;
    }

    public HashSet<ModelElement> getAncestorElements(Iterable<ModelElement> elements) {
        HashSet resultSet = CollectionLiterals.newHashSet();
        for (ModelElement element : elements) {
            resultSet.addAll(this.getAncestorElements(element));
        }
        return resultSet;
    }

    public ArrayList<ModelElement> sortByInheritance(Iterable<? extends ModelElement> elements) {
        int _size = IterableExtensions.size(elements);
        ArrayList<ModelElement> sortedList = new ArrayList<ModelElement>(_size);
        LinkedList<ModelElement> remainingQueue = new LinkedList<ModelElement>();
        Iterables.addAll(remainingQueue, elements);
        while (!remainingQueue.isEmpty()) {
            ModelElement current = (ModelElement)remainingQueue.pop();
            ModelElement superElement = this.getSuperElement(current);
            if (superElement == null || !remainingQueue.contains(superElement)) {
                sortedList.add(current);
                continue;
            }
            remainingQueue.add(current);
        }
        return sortedList;
    }

    public <T> CharSequence ifElseCascade(Iterable<T> it, final Functions.Function1<? super T, ? extends CharSequence> condition, final Functions.Function1<? super T, ? extends CharSequence> elseIfBody, Functions.Function0<? extends CharSequence> elseBody) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(it);
        if (_isNullOrEmpty) {
            return "";
        }
        CharSequence _apply = (CharSequence)elseBody.apply();
        String _string = null;
        if (_apply != null) {
            _string = _apply.toString();
        }
        String elseBodyResult = _string;
        String _xifexpression = null;
        boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)elseBodyResult);
        if (_isNullOrEmpty_1) {
            _xifexpression = null;
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("else {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(elseBodyResult, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _xifexpression = _builder.toString();
        }
        String elseBlock = _xifexpression;
        Functions.Function1 _function = new Functions.Function1<T, CharSequence>(){

            public CharSequence apply(T obj) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("(");
                CharSequence _apply = (CharSequence)condition.apply(obj);
                _builder.append((Object)_apply);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                CharSequence _apply_1 = (CharSequence)elseIfBody.apply(obj);
                _builder.append((Object)_apply_1, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
                return _builder.toString();
            }
        };
        return IterableExtensions.join(it, (CharSequence)"if ", (CharSequence)"else if ", elseBlock, (Functions.Function1)_function);
    }

    public <T> CharSequence ifElseCascade(Iterable<T> it, Functions.Function1<? super T, ? extends CharSequence> condition, Functions.Function1<? super T, ? extends CharSequence> elseIfBody) {
        Functions.Function0<CharSequence> _function = new Functions.Function0<CharSequence>(){

            public CharSequence apply() {
                return null;
            }
        };
        return this.ifElseCascade(it, condition, elseIfBody, (Functions.Function0<? extends CharSequence>)_function);
    }

    public ResizeDirectionSet getResizeDirectionSet(int oldWidth, int oldHeight, int oldX, int oldY, int newWidth, int newHeight, int newX, int newY) {
        return new ResizeDirectionSet(oldWidth, oldHeight, oldX, oldY, newWidth, newHeight, newX, newY);
    }

    public Direction getResizeDirection(int oldWidth, int oldHeight, int oldX, int oldY, int newWidth, int newHeight, int newX, int newY) {
        return this.getResizeDirectionSet(oldWidth, oldHeight, oldX, oldY, newWidth, newHeight, newX, newY).getDirection();
    }

    public Direction getResizeDirection(IResizeShapeContext context) {
        Direction _switchResult = null;
        int _direction = context.getDirection();
        switch (_direction) {
            case 1: {
                _switchResult = Direction.NORTH;
                break;
            }
            case 17: {
                _switchResult = Direction.NORTH_EAST;
                break;
            }
            case 16: {
                _switchResult = Direction.EAST;
                break;
            }
            case 20: {
                _switchResult = Direction.SOUTH_EAST;
                break;
            }
            case 4: {
                _switchResult = Direction.SOUTH;
                break;
            }
            case 12: {
                _switchResult = Direction.SOUTH_WEST;
                break;
            }
            case 8: {
                _switchResult = Direction.WEST;
                break;
            }
            case 9: {
                _switchResult = Direction.NORTH_WEST;
                break;
            }
            default: {
                _switchResult = Direction.UNSPECIFIED;
            }
        }
        return _switchResult;
    }

    public Color toColor(String colorString) throws IllegalArgumentException {
        return new Color(colorString);
    }

    public style.Color toStyleColor(String colorString) throws IllegalArgumentException {
        return this.toColor(colorString).toStyleColor();
    }

    public boolean isHex(String colorString) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)colorString);
        if (_isNullOrEmpty) {
            return false;
        }
        Matcher m = Color.HEX_PATTERN.matcher(colorString);
        return m.matches();
    }

    public boolean isRGB(String colorString) {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)colorString);
        if (_isNullOrEmpty) {
            return false;
        }
        Matcher m = Color.RGB_PATTERN.matcher(colorString);
        boolean _matches = m.matches();
        boolean bl = _not = !_matches;
        if (_not) {
            return false;
        }
        try {
            int r = Integer.parseInt(m.group(1));
            int g = Integer.parseInt(m.group(2));
            int b = Integer.parseInt(m.group(3));
            Functions.Function1<Integer, Boolean> _function = new Functions.Function1<Integer, Boolean>(){

                public Boolean apply(Integer v) {
                    return new IntegerRange(0, 255).contains(v.intValue());
                }
            };
            return IterableExtensions.forall(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{r, g, b})), (Functions.Function1)_function);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public boolean isRGBA(String colorString) {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)colorString);
        if (_isNullOrEmpty) {
            return false;
        }
        Matcher m = Color.RGBA_PATTERN.matcher(colorString);
        boolean _matches = m.matches();
        boolean bl = _not = !_matches;
        if (_not) {
            return false;
        }
        try {
            int r = Integer.parseInt(m.group(1));
            int g = Integer.parseInt(m.group(2));
            int b = Integer.parseInt(m.group(3));
            int a = Integer.parseInt(m.group(4));
            Functions.Function1<Integer, Boolean> _function = new Functions.Function1<Integer, Boolean>(){

                public Boolean apply(Integer v) {
                    return new IntegerRange(0, 255).contains(v.intValue());
                }
            };
            return IterableExtensions.forall(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{r, g, b, a})), (Functions.Function1)_function);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public boolean isCSSColor(String colorName) {
        String simpleName;
        boolean _isNullOrEmpty;
        String _lowerCase = null;
        if (colorName != null) {
            _lowerCase = colorName.toLowerCase();
        }
        String _replaceAll = null;
        if (_lowerCase != null) {
            _replaceAll = _lowerCase.replaceAll("[^a-z]", "");
        }
        if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(simpleName = _replaceAll)) {
            return false;
        }
        return Color.CSS_COLORS.containsKey(simpleName);
    }

    public <S extends ISetup> Resource getResource(String code, String fileExtension, Class<S> standaloneSetupClass) {
        block3: {
            try {
                if (code != null && !StringExtensions.isNullOrEmpty((String)fileExtension) && standaloneSetupClass != null) break block3;
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        byte[] _bytes = code.getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(_bytes);
        Functions.Function1 _function = new Functions.Function1<Constructor<?>, Boolean>(){

            public Boolean apply(Constructor<?> it) {
                int _parameterCount = it.getParameterCount();
                return _parameterCount == 0;
            }
        };
        Object _newInstance = ((Constructor)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray(standaloneSetupClass.getConstructors())), (Functions.Function1)_function)).newInstance(new Object[0]);
        ISetup standaloneSetup = (ISetup)_newInstance;
        Injector injector = standaloneSetup.createInjectorAndDoEMFRegistration();
        XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("dummy:/dummy.");
        _builder.append(fileExtension);
        URI dummyResourceURI = URI.createURI((String)_builder.toString());
        Resource resource = resourceSet.createResource(dummyResourceURI);
        resource.load((InputStream)stream, resourceSet.getLoadOptions());
        return resource;
    }

    public <M extends EObject, S extends ISetup> M getModel(String code, Class<M> modelClass, String fileExtension, Class<S> standaloneSetupClass) {
        EObject _head = (EObject)IterableExtensions.head((Iterable)this.getResource(code, fileExtension, standaloneSetupClass).getContents());
        return (M)_head;
    }

    public <S extends ISetup> EList<Resource.Diagnostic> getErrors(String code, String fileExtension, Class<S> standaloneSetupClass) {
        return this.getResource(code, fileExtension, standaloneSetupClass).getErrors();
    }

    public <S extends ISetup> EList<Resource.Diagnostic> getWarnings(String code, String fileExtension, Class<S> standaloneSetupClass) {
        return this.getResource(code, fileExtension, standaloneSetupClass).getWarnings();
    }

    public boolean hasErrors(Resource resource) {
        boolean _isEmpty = resource.getErrors().isEmpty();
        return !_isEmpty;
    }

    public boolean hasWarnings(Resource resource) {
        boolean _isEmpty = resource.getWarnings().isEmpty();
        return !_isEmpty;
    }

    public <S extends ISetup> boolean hasErrors(String code, String fileExtension, Class<S> standaloneSetupClass) {
        boolean _isEmpty = this.getErrors(code, fileExtension, standaloneSetupClass).isEmpty();
        return !_isEmpty;
    }

    public <S extends ISetup> boolean hasWarnings(String code, String fileExtension, Class<S> standaloneSetupClass) {
        boolean _isEmpty = this.getWarnings(code, fileExtension, standaloneSetupClass).isEmpty();
        return !_isEmpty;
    }

    public int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int _get = calendar.get(2);
        return _get + 1;
    }

    public Month getMonthLiteral(Date date) {
        Month _xblockexpression = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Month _switchResult = null;
        int _get = calendar.get(2);
        switch (_get) {
            case 0: {
                _switchResult = Month.JANUARY;
                break;
            }
            case 1: {
                _switchResult = Month.FEBRUARY;
                break;
            }
            case 2: {
                _switchResult = Month.MARCH;
                break;
            }
            case 3: {
                _switchResult = Month.APRIL;
                break;
            }
            case 4: {
                _switchResult = Month.MAY;
                break;
            }
            case 5: {
                _switchResult = Month.JUNE;
                break;
            }
            case 6: {
                _switchResult = Month.JULY;
                break;
            }
            case 7: {
                _switchResult = Month.AUGUST;
                break;
            }
            case 8: {
                _switchResult = Month.SEPTEMBER;
                break;
            }
            case 9: {
                _switchResult = Month.OCTOBER;
                break;
            }
            case 10: {
                _switchResult = Month.NOVEMBER;
                break;
            }
            case 11: {
                _switchResult = Month.DECEMBER;
            }
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public int getMinute(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public int getSecond(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(13);
    }

    public DayOfWeek getDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DayOfWeek _switchResult = null;
        int _get = calendar.get(7);
        switch (_get) {
            case 2: {
                _switchResult = DayOfWeek.MONDAY;
                break;
            }
            case 3: {
                _switchResult = DayOfWeek.TUESDAY;
                break;
            }
            case 4: {
                _switchResult = DayOfWeek.WEDNESDAY;
                break;
            }
            case 5: {
                _switchResult = DayOfWeek.THURSDAY;
                break;
            }
            case 6: {
                _switchResult = DayOfWeek.FRIDAY;
                break;
            }
            case 7: {
                _switchResult = DayOfWeek.SATURDAY;
                break;
            }
            case 1: {
                _switchResult = DayOfWeek.SUNDAY;
            }
        }
        return _switchResult;
    }

    public boolean isMonday(Date date) {
        DayOfWeek _dayOfWeek = this.getDayOfWeek(date);
        return _dayOfWeek == DayOfWeek.MONDAY;
    }

    public boolean isTuesday(Date date) {
        DayOfWeek _dayOfWeek = this.getDayOfWeek(date);
        return _dayOfWeek == DayOfWeek.TUESDAY;
    }

    public boolean isWednesday(Date date) {
        DayOfWeek _dayOfWeek = this.getDayOfWeek(date);
        return _dayOfWeek == DayOfWeek.WEDNESDAY;
    }

    public boolean isThursday(Date date) {
        DayOfWeek _dayOfWeek = this.getDayOfWeek(date);
        return _dayOfWeek == DayOfWeek.THURSDAY;
    }

    public boolean isFriday(Date date) {
        DayOfWeek _dayOfWeek = this.getDayOfWeek(date);
        return _dayOfWeek == DayOfWeek.FRIDAY;
    }

    public boolean isSaturday(Date date) {
        DayOfWeek _dayOfWeek = this.getDayOfWeek(date);
        return _dayOfWeek == DayOfWeek.SATURDAY;
    }

    public boolean isSunday(Date date) {
        DayOfWeek _dayOfWeek = this.getDayOfWeek(date);
        return _dayOfWeek == DayOfWeek.SUNDAY;
    }

    public boolean isWeekday(Date date) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DayOfWeek[]{DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY})).contains((Object)this.getDayOfWeek(date));
    }

    public boolean isWeekend(Date date) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DayOfWeek[]{DayOfWeek.SATURDAY, DayOfWeek.SUNDAY})).contains((Object)this.getDayOfWeek(date));
    }
}

