/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.event.api.util;

import de.jabc.cinco.meta.plugin.event.api.util.EventApiExtension;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import style.StyleFactory;

@Accessors(value={AccessorType.PUBLIC_GETTER})
public class Color {
    @Extension
    private EventApiExtension _eventApiExtension = new EventApiExtension();
    public static final Pattern HEX_PATTERN = Pattern.compile("^ *#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2}) *$");
    public static final Pattern RGB_PATTERN = Pattern.compile("^ *([0-9]{1,3}) *, *([0-9]{1,3}) *, *([0-9]{1,3}) *$");
    public static final Pattern RGBA_PATTERN = Pattern.compile("^ *([0-9]{1,3}) *, *([0-9]{1,3}) *, *([0-9]{1,3}) *, *([0-9]{1,3}) *$");
    public static final Map<String, String> CSS_COLORS = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"aliceblue", (Object)"#F0F8FF"), Pair.of((Object)"antiquewhite", (Object)"#FAEBD7"), Pair.of((Object)"aqua", (Object)"#00FFFF"), Pair.of((Object)"aquamarine", (Object)"#7FFFD4"), Pair.of((Object)"azure", (Object)"#F0FFFF"), Pair.of((Object)"beige", (Object)"#F5F5DC"), Pair.of((Object)"bisque", (Object)"#FFE4C4"), Pair.of((Object)"black", (Object)"#000000"), Pair.of((Object)"blanchedalmond", (Object)"#FFEBCD"), Pair.of((Object)"blue", (Object)"#0000FF"), Pair.of((Object)"blueviolet", (Object)"#8A2BE2"), Pair.of((Object)"brown", (Object)"#A52A2A"), Pair.of((Object)"burlywood", (Object)"#DEB887"), Pair.of((Object)"cadetblue", (Object)"#5F9EA0"), Pair.of((Object)"chocolate", (Object)"#D2691E"), Pair.of((Object)"coral", (Object)"#FF7F50"), Pair.of((Object)"cornflowerblue", (Object)"#6495ED"), Pair.of((Object)"cornsilk", (Object)"#FFF8DC"), Pair.of((Object)"crimson", (Object)"#DC143C"), Pair.of((Object)"cyan", (Object)"#00FFFF"), Pair.of((Object)"darkblue", (Object)"#00008B"), Pair.of((Object)"darkcyan", (Object)"#008B8B"), Pair.of((Object)"darkgoldenrod", (Object)"#B8860B"), Pair.of((Object)"darkgray", (Object)"#A9A9A9"), Pair.of((Object)"darkgreen", (Object)"#006400"), Pair.of((Object)"darkkhaki", (Object)"#BDB76B"), Pair.of((Object)"darkmagenta", (Object)"#8B008B"), Pair.of((Object)"darkolivegreen", (Object)"#556B2F"), Pair.of((Object)"darkorange", (Object)"#FF8C00"), Pair.of((Object)"darkorchid", (Object)"#9932CC"), Pair.of((Object)"darkred", (Object)"#8B0000"), Pair.of((Object)"darksalmon", (Object)"#E9967A"), Pair.of((Object)"darkseagreen", (Object)"#8FBC8F"), Pair.of((Object)"darkslateblue", (Object)"#483D8B"), Pair.of((Object)"darkslategray", (Object)"#2F4F4F"), Pair.of((Object)"darkturquoise", (Object)"#00CED1"), Pair.of((Object)"darkviolet", (Object)"#9400D3"), Pair.of((Object)"deeppink", (Object)"#FF1493"), Pair.of((Object)"deepskyblue", (Object)"#00BFFF"), Pair.of((Object)"dimgray", (Object)"#696969"), Pair.of((Object)"dodgerblue", (Object)"#1E90FF"), Pair.of((Object)"firebrick", (Object)"#B22222"), Pair.of((Object)"floralwhite", (Object)"#FFFAF0"), Pair.of((Object)"forestgreen", (Object)"#228B22"), Pair.of((Object)"fuchsia", (Object)"#FF00FF"), Pair.of((Object)"gainsboro", (Object)"#DCDCDC"), Pair.of((Object)"ghostwhite", (Object)"#F8F8FF"), Pair.of((Object)"gold", (Object)"#FFD700"), Pair.of((Object)"goldenrod", (Object)"#DAA520"), Pair.of((Object)"gray", (Object)"#808080"), Pair.of((Object)"green", (Object)"#008000"), Pair.of((Object)"greenyellow", (Object)"#ADFF2F"), Pair.of((Object)"honeydew", (Object)"#F0FFF0"), Pair.of((Object)"hotpink", (Object)"#FF69B4"), Pair.of((Object)"indianred", (Object)"#CD5C5C"), Pair.of((Object)"indigo", (Object)"#4B0082"), Pair.of((Object)"ivory", (Object)"#FFFFF0"), Pair.of((Object)"khaki", (Object)"#F0E68C"), Pair.of((Object)"lavender", (Object)"#E6E6FA"), Pair.of((Object)"lavenderblush", (Object)"#FFF0F5"), Pair.of((Object)"lawngreen", (Object)"#7CFC00"), Pair.of((Object)"lemonchiffon", (Object)"#FFFACD"), Pair.of((Object)"lightblue", (Object)"#ADD8E6"), Pair.of((Object)"lightcoral", (Object)"#F08080"), Pair.of((Object)"lightcyan", (Object)"#E0FFFF"), Pair.of((Object)"lightgoldenrodyellow", (Object)"#FAFAD2"), Pair.of((Object)"lightgray", (Object)"#D3D3D3"), Pair.of((Object)"lightgreen", (Object)"#90EE90"), Pair.of((Object)"lightpink", (Object)"#FFB6C1"), Pair.of((Object)"lightsalmon", (Object)"#FFA07A"), Pair.of((Object)"lightseagreen", (Object)"#20B2AA"), Pair.of((Object)"lightskyblue", (Object)"#87CEFA"), Pair.of((Object)"lightslategray", (Object)"#778899"), Pair.of((Object)"lightsteelblue", (Object)"#B0C4DE"), Pair.of((Object)"lightyellow", (Object)"#FFFFE0"), Pair.of((Object)"lime", (Object)"#00FF00"), Pair.of((Object)"limegreen", (Object)"#32CD32"), Pair.of((Object)"linen", (Object)"#FAF0E6"), Pair.of((Object)"magenta", (Object)"#FF00FF"), Pair.of((Object)"maroon", (Object)"#800000"), Pair.of((Object)"mediumaquamarine", (Object)"#66CDAA"), Pair.of((Object)"mediumblue", (Object)"#0000CD"), Pair.of((Object)"mediumorchid", (Object)"#BA55D3"), Pair.of((Object)"mediumpurple", (Object)"#9370DB"), Pair.of((Object)"mediumseagreen", (Object)"#3CB371"), Pair.of((Object)"mediumslateblue", (Object)"#7B68EE"), Pair.of((Object)"mediumspringgreen", (Object)"#00FA9A"), Pair.of((Object)"mediumturquoise", (Object)"#48D1CC"), Pair.of((Object)"mediumvioletred", (Object)"#C71585"), Pair.of((Object)"midnightblue", (Object)"#191970"), Pair.of((Object)"mintcream", (Object)"#F5FFFA"), Pair.of((Object)"mistyrose", (Object)"#FFE4E1"), Pair.of((Object)"moccasin", (Object)"#FFE4B5"), Pair.of((Object)"navajowhite", (Object)"#FFDEAD"), Pair.of((Object)"navy", (Object)"#000080"), Pair.of((Object)"oldlace", (Object)"#FDF5E6"), Pair.of((Object)"olive", (Object)"#808000"), Pair.of((Object)"olivedrab", (Object)"#6B8E23"), Pair.of((Object)"orange", (Object)"#FFA500"), Pair.of((Object)"orangered", (Object)"#FF4500"), Pair.of((Object)"orchid", (Object)"#DA70D6"), Pair.of((Object)"palegoldenrod", (Object)"#EEE8AA"), Pair.of((Object)"palegreen", (Object)"#98FB98"), Pair.of((Object)"paleturquoise", (Object)"#AFEEEE"), Pair.of((Object)"palevioletred", (Object)"#DB7093"), Pair.of((Object)"papayawhip", (Object)"#FFEFD5"), Pair.of((Object)"peachpuff", (Object)"#FFDAB9"), Pair.of((Object)"peru", (Object)"#CD853F"), Pair.of((Object)"pink", (Object)"#FFC0CB"), Pair.of((Object)"plum", (Object)"#DDA0DD"), Pair.of((Object)"powderblue", (Object)"#B0E0E6"), Pair.of((Object)"purple", (Object)"#800080"), Pair.of((Object)"red", (Object)"#FF0000"), Pair.of((Object)"rosybrown", (Object)"#BC8F8F"), Pair.of((Object)"royalblue", (Object)"#4169E1"), Pair.of((Object)"saddlebrown", (Object)"#8B4513"), Pair.of((Object)"salmon", (Object)"#FA8072"), Pair.of((Object)"sandybrown", (Object)"#F4A460"), Pair.of((Object)"seagreen", (Object)"#2E8B57"), Pair.of((Object)"seashell", (Object)"#FFF5EE"), Pair.of((Object)"sienna", (Object)"#A0522D"), Pair.of((Object)"silver", (Object)"#C0C0C0"), Pair.of((Object)"skyblue", (Object)"#87CEEB"), Pair.of((Object)"slateblue", (Object)"#6A5ACD"), Pair.of((Object)"slategray", (Object)"#708090"), Pair.of((Object)"snow", (Object)"#FFFAFA"), Pair.of((Object)"springgreen", (Object)"#00FF7F"), Pair.of((Object)"steelblue", (Object)"#4682B4"), Pair.of((Object)"tan", (Object)"#D2B48C"), Pair.of((Object)"teal", (Object)"#008080"), Pair.of((Object)"thistle", (Object)"#D8BFD8"), Pair.of((Object)"tomato", (Object)"#FF6347"), Pair.of((Object)"turquoise", (Object)"#40E0D0"), Pair.of((Object)"violet", (Object)"#EE82EE"), Pair.of((Object)"wheat", (Object)"#F5DEB3"), Pair.of((Object)"white", (Object)"#FFFFFF"), Pair.of((Object)"whitesmoke", (Object)"#F5F5F5"), Pair.of((Object)"yellow", (Object)"#FFFF00"), Pair.of((Object)"yellowgreen", (Object)"#9ACD32")}));
    private int red;
    private int green;
    private int blue;
    private int alpha;

    public Color(int red, int green, int blue, int alpha) {
        boolean _not;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        boolean _checkValues = this.checkValues();
        boolean bl = _not = !_checkValues;
        if (_not) {
            throw new IllegalArgumentException();
        }
    }

    public Color(int red, int green, int blue) {
        boolean _not;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = 255;
        boolean _checkValues = this.checkValues();
        boolean bl = _not = !_checkValues;
        if (_not) {
            throw new IllegalArgumentException();
        }
    }

    public Color(Color color) {
        this.red = color.red;
        this.green = color.green;
        this.blue = color.blue;
        this.alpha = color.alpha;
    }

    public Color(String colorString) throws IllegalArgumentException {
        boolean _isCSSColor;
        boolean _isRGBA;
        boolean _isRGB;
        String it = colorString;
        boolean _matched = false;
        boolean _isHex = this._eventApiExtension.isHex(it);
        if (_isHex) {
            _matched = true;
            Matcher m = HEX_PATTERN.matcher(colorString);
            m.matches();
            this.red = Integer.parseInt(m.group(1), 16);
            this.green = Integer.parseInt(m.group(2), 16);
            this.blue = Integer.parseInt(m.group(3), 16);
            this.alpha = 255;
        }
        if (!_matched && (_isRGB = this._eventApiExtension.isRGB(it))) {
            _matched = true;
            Matcher m_1 = RGB_PATTERN.matcher(colorString);
            m_1.matches();
            this.red = Integer.parseInt(m_1.group(1));
            this.green = Integer.parseInt(m_1.group(2));
            this.blue = Integer.parseInt(m_1.group(3));
            this.alpha = 255;
        }
        if (!_matched && (_isRGBA = this._eventApiExtension.isRGBA(it))) {
            _matched = true;
            Matcher m_2 = RGBA_PATTERN.matcher(colorString);
            m_2.matches();
            this.red = Integer.parseInt(m_2.group(1));
            this.green = Integer.parseInt(m_2.group(2));
            this.blue = Integer.parseInt(m_2.group(3));
            this.alpha = Integer.parseInt(m_2.group(4));
        }
        if (!_matched && (_isCSSColor = this._eventApiExtension.isCSSColor(it))) {
            _matched = true;
            String _lowerCase = null;
            if (colorString != null) {
                _lowerCase = colorString.toLowerCase();
            }
            String _replaceAll = null;
            if (_lowerCase != null) {
                _replaceAll = _lowerCase.replaceAll("[^a-z]", "");
            }
            String simpleName = _replaceAll;
            String hex = CSS_COLORS.get(simpleName);
            Color color = new Color(hex);
            this.red = color.red;
            this.green = color.green;
            this.blue = color.blue;
            this.alpha = color.alpha;
        }
        if (!_matched) {
            throw new IllegalArgumentException();
        }
    }

    private boolean checkValues() {
        Functions.Function1<Integer, Boolean> _function = new Functions.Function1<Integer, Boolean>(){

            public Boolean apply(Integer v) {
                return new IntegerRange(0, 255).contains(v.intValue());
            }
        };
        return IterableExtensions.forall(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{this.red, this.green, this.blue, this.alpha})), (Functions.Function1)_function);
    }

    public String toHex() {
        return String.format("#%02X%02X%02X", this.red, this.green, this.blue);
    }

    public String toRGB() {
        return String.format("%d,%d,%d", this.red, this.green, this.blue);
    }

    public String toRGBA() {
        return String.format("%d,%d,%d,%d", this.red, this.green, this.blue, this.alpha);
    }

    public style.Color toStyleColor() {
        style.Color _createColor = StyleFactory.eINSTANCE.createColor();
        Procedures.Procedure1<style.Color> _function = new Procedures.Procedure1<style.Color>(){

            public void apply(style.Color it) {
                it.setR(Color.this.red);
                it.setG(Color.this.green);
                it.setB(Color.this.blue);
            }
        };
        return (style.Color)ObjectExtensions.operator_doubleArrow((Object)_createColor, (Procedures.Procedure1)_function);
    }

    public Color getContrastingColor() {
        boolean _lessThan;
        double _relativeLuminance = this.getRelativeLuminance();
        boolean bl = _lessThan = _relativeLuminance < 0.5;
        if (_lessThan) {
            return new Color(255, 255, 255);
        }
        return new Color(0, 0, 0);
    }

    public double getRelativeLuminance() {
        double _relativeLuminance = this.getRelativeLuminance(this.red);
        double _multiply = 0.2126 * _relativeLuminance;
        double _relativeLuminance_1 = this.getRelativeLuminance(this.green);
        double _multiply_1 = 0.7152 * _relativeLuminance_1;
        double _plus = _multiply + _multiply_1;
        double _relativeLuminance_2 = this.getRelativeLuminance(this.blue);
        double _multiply_2 = 0.0722 * _relativeLuminance_2;
        return _plus + _multiply_2;
    }

    private double getRelativeLuminance(int value) {
        if (value <= 10) {
            return (double)value / 3294.6;
        }
        return Math.pow(((double)value + 14.025) / 269.025, 2.4);
    }

    @Pure
    public EventApiExtension get_eventApiExtension() {
        return this._eventApiExtension;
    }

    @Pure
    public int getRed() {
        return this.red;
    }

    @Pure
    public int getGreen() {
        return this.green;
    }

    @Pure
    public int getBlue() {
        return this.blue;
    }

    @Pure
    public int getAlpha() {
        return this.alpha;
    }
}

