/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.event.api.test;

import de.jabc.cinco.meta.plugin.event.api.util.Fqn;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class FqnTest {
    @Test
    public void test() {
        new Fqn("java.util.List<? extends bar.Foo>");
    }

    @Test
    public void testExceptions() {
        Executable _function = new Executable(){

            public void execute() throws Throwable {
                new Fqn(null);
            }
        };
        Assertions.assertThrows(NullPointerException.class, (Executable)_function);
        Executable _function_1 = new Executable(){

            public void execute() throws Throwable {
                new Fqn(null);
            }
        };
        Assertions.assertThrows(NullPointerException.class, (Executable)_function_1);
        Executable _function_2 = new Executable(){

            public void execute() throws Throwable {
                new Fqn("");
            }
        };
        Assertions.assertThrows(Fqn.FqnFormatException.class, (Executable)_function_2);
        Executable _function_3 = new Executable(){

            public void execute() throws Throwable {
                new Fqn("java.lang.");
            }
        };
        Assertions.assertThrows(Fqn.FqnFormatException.class, (Executable)_function_3);
        Executable _function_4 = new Executable(){

            public void execute() throws Throwable {
                new Fqn("List<Integer");
            }
        };
        Assertions.assertThrows(Fqn.FqnFormatException.class, (Executable)_function_4);
        Executable _function_5 = new Executable(){

            public void execute() throws Throwable {
                new Fqn("ListInteger>");
            }
        };
        Assertions.assertThrows(Fqn.FqnFormatException.class, (Executable)_function_5);
        Executable _function_6 = new Executable(){

            public void execute() throws Throwable {
                new Fqn("List<Integer>>");
            }
        };
        Assertions.assertThrows(Fqn.FqnFormatException.class, (Executable)_function_6);
        Executable _function_7 = new Executable(){

            public void execute() throws Throwable {
                new Fqn("List<<Integer>");
            }
        };
        Assertions.assertThrows(Fqn.FqnFormatException.class, (Executable)_function_7);
        Executable _function_8 = new Executable(){

            public void execute() throws Throwable {
                new Fqn("List Integer");
            }
        };
        Assertions.assertThrows(Fqn.FqnFormatException.class, (Executable)_function_8);
    }

    @Test
    public void testConstructor() {
        this.check(null, "A", null, null, null);
        this.check("b", "A", null, null, null);
        this.check(null, "?", null, "b.A", null);
        this.check(null, "A", new String[0], null, null);
        this.check("b", "A", new String[0], null, null);
        this.check(null, "?", null, "b.A<>", null);
        this.check(null, "A", new String[]{"c.D"}, null, null);
        this.check("b", "A", new String[]{"c.D"}, null, null);
        this.check(null, "?", null, "b.A<c.D>", null);
        this.check(null, "A", new String[]{"c.D", "e.F"}, null, null);
        this.check("b", "A", new String[]{"c.D", "e.F"}, null, null);
        this.check(null, "?", null, "b.A<c.D, e.F>", null);
        this.check(null, "A", new String[]{"c.D", "e.F", "g.H"}, null, null);
        this.check("b", "A", new String[]{"c.D", "e.F", "g.H"}, null, null);
        this.check(null, "?", null, "b.A<c.D, e.F, g.H>", null);
    }

    private void check(String packageName, String className, String[] generics, String extendsConstraint, String superConstraint) {
        try {
            boolean _not;
            if (extendsConstraint != null && superConstraint != null) {
                throw new Exception("Test error: At either extendsConstraint or superConstraint or both must be null!");
            }
            if (this.notNullAndEmpty(extendsConstraint) || this.notNullAndEmpty(superConstraint)) {
                throw new Exception("Test error: extendsConstraint and superConstraint may not be empty!");
            }
            StringConcatenation _builder = new StringConcatenation();
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)packageName);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                _builder.append(packageName);
                _builder.append(".");
            }
            _builder.append(className);
            String fullyQualifiedName = _builder.toString();
            StringConcatenation _builder_1 = new StringConcatenation();
            String _w = this.w();
            _builder_1.append(_w);
            _builder_1.append(fullyQualifiedName);
            String _w_1 = this.w();
            _builder_1.append(_w_1);
            if (generics != null) {
                _builder_1.append("<");
                boolean _hasElements = false;
                String[] stringArray = generics;
                int n = generics.length;
                int n2 = 0;
                while (n2 < n) {
                    String g = stringArray[n2];
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder_1.appendImmediate((Object)",", "");
                    }
                    String _w_2 = this.w();
                    _builder_1.append(_w_2);
                    _builder_1.append(g);
                    String _w_3 = this.w();
                    _builder_1.append(_w_3);
                    ++n2;
                }
                _builder_1.append(">");
                String _w_4 = this.w();
                _builder_1.append(_w_4);
            }
            if (extendsConstraint != null) {
                String _w1 = this.w1();
                _builder_1.append(_w1);
                _builder_1.append("extends");
                String _w1_1 = this.w1();
                _builder_1.append(_w1_1);
                _builder_1.append(extendsConstraint);
            }
            if (superConstraint != null) {
                String _w1_2 = this.w1();
                _builder_1.append(_w1_2);
                _builder_1.append("super");
                String _w1_3 = this.w1();
                _builder_1.append(_w1_3);
                _builder_1.append(superConstraint);
            }
            Fqn fqn = new Fqn((CharSequence)_builder_1);
            Assertions.assertEquals((Object)fullyQualifiedName, (Object)fqn.getFullyQualifiedName());
            Assertions.assertEquals((Object)packageName, (Object)fqn.getPackageName());
            Assertions.assertEquals((Object)className, (Object)fqn.getClassName());
            Fqn[] _generics = fqn.getGenerics();
            boolean _tripleEquals = _generics == null;
            Assertions.assertEquals((Object)(generics == null ? 1 : 0), (Object)_tripleEquals);
            Assertions.assertEquals((Object)(generics != null ? 1 : 0), (Object)fqn.hasGenerics());
            if (generics != null) {
                Assertions.assertEquals((int)generics.length, (int)fqn.getGenerics().length);
                Functions.Function1<Fqn, String> _function = new Functions.Function1<Fqn, String>(){

                    public String apply(Fqn it) {
                        return it.getFullyQualifiedNameWithSuffix();
                    }
                };
                Assertions.assertIterableEquals((Iterable)((Iterable)Conversions.doWrapArray((Object)generics)), (Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)fqn.getGenerics())), (Functions.Function1)_function));
            }
            Fqn _extendsConstraint = fqn.getExtendsConstraint();
            String _fullyQualifiedNameWithSuffix = null;
            if (_extendsConstraint != null) {
                _fullyQualifiedNameWithSuffix = _extendsConstraint.getFullyQualifiedNameWithSuffix();
            }
            Assertions.assertEquals((Object)extendsConstraint, (Object)_fullyQualifiedNameWithSuffix);
            Assertions.assertEquals((Object)(extendsConstraint != null ? 1 : 0), (Object)fqn.hasExtendsConstraint());
            Fqn _superConstraint = fqn.getSuperConstraint();
            String _fullyQualifiedNameWithSuffix_1 = null;
            if (_superConstraint != null) {
                _fullyQualifiedNameWithSuffix_1 = _superConstraint.getFullyQualifiedNameWithSuffix();
            }
            Assertions.assertEquals((Object)superConstraint, (Object)_fullyQualifiedNameWithSuffix_1);
            Assertions.assertEquals((Object)(superConstraint != null ? 1 : 0), (Object)fqn.hasSuperConstraint());
            Assertions.assertEquals((Object)(extendsConstraint != null || superConstraint != null ? 1 : 0), (Object)fqn.hasConstraint());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean notNullAndEmpty(String str) {
        return str != null && str.isEmpty();
    }

    public String w() {
        return this.randomWhitespace();
    }

    public String w1() {
        return this.randomWhitespace1();
    }

    public String randomWhitespace() {
        boolean _equals;
        ThreadLocalRandom randGen = ThreadLocalRandom.current();
        String result = "";
        int _nextInt = randGen.nextInt(0, 3);
        boolean bl = _equals = _nextInt == 0;
        if (_equals) {
            List whitespace = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{" ", "\t", "\n", "\r", "\f"}));
            int count = randGen.nextInt(1, 4);
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, count, true);
            Iterator iterator = _doubleDotLessThan.iterator();
            while (iterator.hasNext()) {
                Integer cfr_ignored_0 = (Integer)iterator.next();
                int random = randGen.nextInt(0, ((Object[])Conversions.unwrapArray(whitespace, Object.class)).length);
                String _result = result;
                String _get = (String)whitespace.get(random);
                result = String.valueOf(_result) + _get;
            }
        }
        return result;
    }

    public String randomWhitespace1() {
        ThreadLocalRandom randGen = ThreadLocalRandom.current();
        String result = "";
        List whitespace = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{" ", "\t", "\n", "\r", "\f"}));
        int count = randGen.nextInt(1, 4);
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, count, true);
        Iterator iterator = _doubleDotLessThan.iterator();
        while (iterator.hasNext()) {
            Integer cfr_ignored_0 = (Integer)iterator.next();
            int random = randGen.nextInt(0, ((Object[])Conversions.unwrapArray(whitespace, Object.class)).length);
            String _result = result;
            String _get = (String)whitespace.get(random);
            result = String.valueOf(_result) + _get;
        }
        return result;
    }
}

