/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.referenceregistry.listener;

import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;

public class RegistryResourceChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            this.processAffectedFiles(delta);
        }
    }

    private void processAffectedFiles(IResourceDelta delta) {
        IPath from = null;
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            IResource res = child.getResource();
            if (res instanceof IFile) {
                IFile file = (IFile)res;
                if (this.added(child)) {
                    ReferenceRegistry.getInstance().handleAdd(this.getUri(file.getFullPath()));
                }
                if (this.deleted(child)) {
                    ReferenceRegistry.getInstance().handleDelete(this.getUri(file.getFullPath()));
                }
                if (this.changed(child)) {
                    ReferenceRegistry.getInstance().handleChange(this.getUri(file.getFullPath()));
                }
                if (this.movedFrom(child)) {
                    from = child.getMovedFromPath();
                    ReferenceRegistry.getInstance().handleRename(this.getUri(from), this.getUri(file.getFullPath()));
                }
            }
            this.processAffectedFiles(child);
            ++n2;
        }
    }

    private boolean movedFrom(IResourceDelta child) {
        return child.getKind() == 1 && (child.getFlags() & 0x1000) != 0;
    }

    private boolean changed(IResourceDelta child) {
        return child.getKind() == 4 && (child.getFlags() & 0x100) != 0;
    }

    private boolean deleted(IResourceDelta child) {
        return child.getKind() == 2 && child.getFlags() == 0;
    }

    private boolean added(IResourceDelta child) {
        return child.getKind() == 1 && child.getFlags() == 0;
    }

    private URI getUri(IPath path) {
        URI uri = URI.createPlatformResourceURI((String)path.toPortableString(), (boolean)true);
        return uri;
    }
}

