/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.referenceregistry;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.referenceregistry.KeyRequest;
import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import de.jabc.cinco.meta.core.referenceregistry.Request;
import de.jabc.cinco.meta.core.referenceregistry.UriRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class WorkspaceCrawler
extends Job {
    private final ReferenceRegistry registry;
    private ExecutorService threadPool;
    private final ConcurrentHashMap.KeySetView<Thread, Boolean> minions = ConcurrentHashMap.newKeySet();
    private final AtomicLong loadTime = new AtomicLong(0L);
    private final AtomicLong readTime = new AtomicLong(0L);

    public WorkspaceCrawler(ReferenceRegistry registry) {
        super("Update references");
        this.registry = registry;
        this.debug("created");
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.debug("run");
        return this.workWithMinions(false);
    }

    protected IStatus workAndWait() {
        this.debug("work and wait");
        this.workWithMinions(true);
        this.registry.crawler = null;
        return Status.OK_STATUS;
    }

    protected IStatus workWithMinions(boolean keepBusy) {
        long debugTime = System.currentTimeMillis();
        int numProcessors = Runtime.getRuntime().availableProcessors();
        int _size = this.registry.uriQueue.size();
        String _plus = "work with minions, uriQueue.size: " + Integer.valueOf(_size);
        String _plus_1 = String.valueOf(_plus) + ", available processors: ";
        String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(numProcessors);
        this.debug(_plus_2);
        if (numProcessors > 1) {
            int _min = Math.min(this.registry.uriQueue.size(), numProcessors);
            int numMinions = _min - 1;
            this.debug("submit " + Integer.valueOf(numMinions) + " minions");
            this.threadPool = Executors.newFixedThreadPool(numProcessors);
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, numMinions, true);
            for (Integer i : _doubleDotLessThan) {
                this.submitNewMinion();
            }
        }
        this.debug("starting to work myself");
        this.workForRequest(null, keepBusy);
        long _currentTimeMillis = System.currentTimeMillis();
        long _minus = _currentTimeMillis - debugTime;
        String _plus_3 = "stop, return OK, runTime: " + Long.valueOf(_minus);
        String _plus_4 = String.valueOf(_plus_3) + " loadTime: ";
        long _get = this.loadTime.get();
        String _plus_5 = String.valueOf(_plus_4) + Long.valueOf(_get);
        String _plus_6 = String.valueOf(_plus_5) + " extractTime: ";
        long _get_1 = this.readTime.get();
        String _plus_7 = String.valueOf(_plus_6) + Long.valueOf(_get_1);
        this.debug(_plus_7);
        this.registry.crawler = null;
        return Status.OK_STATUS;
    }

    public void submitNewMinion() {
        Callable<Boolean> _function = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                WorkspaceCrawler.this.notifyStart();
                WorkspaceCrawler.this.work();
                WorkspaceCrawler.this.notifyDone();
                return true;
            }
        };
        this.threadPool.submit(_function);
    }

    public boolean notifyStart() {
        return this.minions.add(Thread.currentThread());
    }

    public boolean notifyDone() {
        return this.minions.remove(Thread.currentThread());
    }

    public boolean isWorkingMinion() {
        return this.minions.contains(Thread.currentThread());
    }

    public void work() {
        this.workForRequest(null, false);
    }

    public void workForRequest(Request<?, ?> request) {
        this.workForRequest(null, true);
    }

    public void workForRequest(Request<?, ?> request, boolean keepBusy) {
        try {
            URI _elvis = null;
            URI _poll = this.registry.uriQueue.poll();
            if (_poll != null) {
                _elvis = _poll;
            } else {
                URI _xifexpression = null;
                if (keepBusy) {
                    _xifexpression = this.pollProcessedURI();
                }
                _elvis = _xifexpression;
            }
            URI uri = _elvis;
            while (uri != null) {
                this.work(uri);
                URI _elvis_1 = null;
                URI _poll_1 = this.registry.uriQueue.poll();
                if (_poll_1 != null) {
                    _elvis_1 = _poll_1;
                } else {
                    URI _xifexpression_1 = null;
                    if (keepBusy) {
                        _xifexpression_1 = this.pollProcessedURI();
                    }
                    _elvis_1 = _xifexpression_1;
                }
                uri = _elvis_1;
                boolean _isProvided = false;
                if (request != null) {
                    _isProvided = request.isProvided;
                }
                if (!_isProvided) continue;
                return;
            }
            boolean _isEmpty = this.registry.inProcess.isEmpty();
            if (_isEmpty) {
                int _size = this.registry.key_on_obj.size();
                String _plus = "DONE keys: " + Integer.valueOf(_size);
                String _plus_1 = String.valueOf(_plus) + " URIs: ";
                int _size_1 = this.registry.resURI_on_keys.size();
                String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(_size_1);
                this.debug(_plus_2);
                this.declineRemainingRequests();
            } else {
                int _size_2 = this.registry.inProcess.size();
                String _plus_3 = "no work left for me, but still " + Integer.valueOf(_size_2);
                String _plus_4 = String.valueOf(_plus_3) + " URIs in process";
                this.debug(_plus_4);
                boolean _isWorkingMinion = this.isWorkingMinion();
                if (_isWorkingMinion) {
                    this.debug("i am minion");
                } else {
                    int _size_3 = this.minions.size();
                    String _plus_5 = "i am NOT minion; working minions: " + Integer.valueOf(_size_3);
                    this.debug(_plus_5);
                    boolean _isEmpty_1 = this.minions.isEmpty();
                    if (_isEmpty_1) {
                        boolean _not;
                        boolean _isShutdown = this.threadPool.isShutdown();
                        boolean bl = _not = !_isShutdown;
                        if (_not) {
                            this.debug("shutdown thread pool");
                            this.threadPool.shutdown();
                        }
                        this.debug("await termination");
                        this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                        this.debug("thread pool terminated");
                    }
                }
            }
            return;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public URI pollProcessedURI() {
        boolean _not_1;
        Set _keySet = this.registry.inProcess.keySet();
        for (URI uri : _keySet) {
            boolean _not;
            Set<Thread> _get = this.registry.inProcess.get(uri);
            boolean _contains = false;
            if (_get != null) {
                _contains = _get.contains(Thread.currentThread());
            }
            boolean bl = _not = !_contains;
            if (!_not) continue;
            return uri;
        }
        boolean _isEmpty = this.registry.inProcess.isEmpty();
        boolean bl = _not_1 = !_isEmpty;
        if (_not_1) {
            URI _head = (URI)IterableExtensions.head((Iterable)this.registry.inProcess.keySet());
            String _plus = "declined to work for the same URI twice: " + _head;
            this.debug(_plus);
        }
        return null;
    }

    protected void work(URI uri) {
        if (uri != null) {
            try {
                try {
                    Set<Thread> threads = this.registry.inProcess.get(uri);
                    if (threads == null) {
                        this.registry.inProcess.put(uri, CollectionLiterals.newHashSet());
                    }
                    this.registry.inProcess.get(uri).add(Thread.currentThread());
                    final Map<String, EObject> map = this.extractIds(uri);
                    Iterable _filterNull = IterableExtensions.filterNull(map.keySet());
                    for (String id : _filterNull) {
                        final EObject obj = map.get(id);
                        this.registry.register(id, uri, obj);
                        boolean _containsKey = this.registry.keyRequests.containsKey(id);
                        if (!_containsKey) continue;
                        Consumer<KeyRequest> _function = new Consumer<KeyRequest>(){

                            @Override
                            public void accept(KeyRequest it) {
                                it.provide(obj);
                            }
                        };
                        this.registry.keyRequests.remove(id).forEach(_function);
                    }
                    boolean _containsKey = this.registry.uriRequests.containsKey(uri);
                    if (_containsKey) {
                        Consumer<UriRequest> _function = new Consumer<UriRequest>(){

                            @Override
                            public void accept(UriRequest it) {
                                it.provide(map);
                            }
                        };
                        this.registry.uriRequests.remove(uri).forEach(_function);
                    }
                }
                catch (Throwable _t) {
                    if (!(_t instanceof Exception)) {
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                    this.registry.inProcess.remove(uri);
                }
            }
            finally {
                this.registry.inProcess.remove(uri);
            }
        }
    }

    protected void declineRemainingRequests() {
        Consumer<KeyRequest> _function = new Consumer<KeyRequest>(){

            @Override
            public void accept(KeyRequest it) {
                it.decline();
            }
        };
        IterableExtensions.filterNull((Iterable)Iterables.concat(this.registry.keyRequests.values())).forEach(_function);
        Consumer<UriRequest> _function_1 = new Consumer<UriRequest>(){

            @Override
            public void accept(UriRequest it) {
                it.decline();
            }
        };
        IterableExtensions.filterNull((Iterable)Iterables.concat(this.registry.uriRequests.values())).forEach(_function_1);
    }

    protected void collectFiles() {
        this.registry.uriQueue.clear();
        Functions.Function1<IFile, Long> _function = new Functions.Function1<IFile, Long>(){

            public Long apply(IFile it) {
                return WorkspaceCrawler.this.getFileSize(it);
            }
        };
        List _reverse = ListExtensions.reverse((List)IterableExtensions.sortBy(WorkspaceCrawler.getWorkspaceFiles(), (Functions.Function1)_function));
        for (IFile f : _reverse) {
            URI uri = URI.createPlatformResourceURI((String)f.getFullPath().toString(), (boolean)true);
            this.registry.uriQueue.add(uri);
        }
    }

    public static ArrayList<IFile> getWorkspaceFiles() {
        ArrayList files = CollectionLiterals.newArrayList();
        WorkspaceCrawler.collectFiles((IContainer)ResourcesPlugin.getWorkspace().getRoot(), files);
        return files;
    }

    public static void collectFiles(IContainer container, final List<IFile> fileList) {
        if (container instanceof IContainer && !ReferenceRegistry.isBlacklisted(container) && container.isAccessible()) {
            IResource[] members = null;
            try {
                members = container.members();
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            IResource[] _converted_members = members;
            if ((List)Conversions.doWrapArray((Object)_converted_members) != null) {
                Consumer<IResource> _function = new Consumer<IResource>(){

                    @Override
                    public void accept(IResource it) {
                        boolean _isWhitelisted;
                        boolean _matched = false;
                        if (it instanceof IFile && (_isWhitelisted = ReferenceRegistry.isWhitelisted((IFile)it))) {
                            _matched = true;
                            fileList.add((IFile)it);
                        }
                        if (!_matched && it instanceof IContainer) {
                            _matched = true;
                            WorkspaceCrawler.collectFiles((IContainer)it, fileList);
                        }
                    }
                };
                ((List)Conversions.doWrapArray((Object)_converted_members)).forEach(_function);
            }
        }
    }

    public long getFileSize(IFile file) {
        IPath _rawLocation = file.getRawLocation();
        File _file = null;
        if (_rawLocation != null) {
            _file = _rawLocation.toFile();
        }
        long _length = 0L;
        if (_file != null) {
            _length = _file.length();
        }
        return _length;
    }

    public Map<String, EObject> extractIds(final Resource res) {
        HashMap _newHashMap = CollectionLiterals.newHashMap();
        Procedures.Procedure1<HashMap<String, EObject>> _function = new Procedures.Procedure1<HashMap<String, EObject>>(){

            public void apply(HashMap<String, EObject> it) {
                if (res != null) {
                    WorkspaceCrawler.this.extractIds(res, it);
                }
            }
        };
        return (Map)ObjectExtensions.operator_doubleArrow((Object)_newHashMap, (Procedures.Procedure1)_function);
    }

    public Map<String, EObject> extractIds(final URI uri) {
        HashMap _newHashMap = CollectionLiterals.newHashMap();
        Procedures.Procedure1<HashMap<String, EObject>> _function = new Procedures.Procedure1<HashMap<String, EObject>>(){

            public void apply(HashMap<String, EObject> it) {
                long tLoad = System.currentTimeMillis();
                Resource res = WorkspaceCrawler.this.loadResource(uri);
                long _currentTimeMillis = System.currentTimeMillis();
                long _minus = _currentTimeMillis - tLoad;
                WorkspaceCrawler.this.loadTime.addAndGet(_minus);
                long tRead = System.currentTimeMillis();
                if (res != null) {
                    WorkspaceCrawler.this.extractIds(res, it);
                }
                long _currentTimeMillis_1 = System.currentTimeMillis();
                long _minus_1 = _currentTimeMillis_1 - tRead;
                WorkspaceCrawler.this.readTime.addAndGet(_minus_1);
            }
        };
        return (Map)ObjectExtensions.operator_doubleArrow((Object)_newHashMap, (Procedures.Procedure1)_function);
    }

    public void extractIds(Resource res, final Map<String, EObject> objectsById) {
        Consumer<EObject> _function = new Consumer<EObject>(){

            @Override
            public void accept(EObject it) {
                WorkspaceCrawler.this.extractIds_rec(it, objectsById);
            }
        };
        res.getContents().forEach((Consumer)_function);
    }

    public void extractIds_rec(EObject obj, final Map<String, EObject> objectsById) {
        if (obj instanceof EObject && !(obj instanceof Diagram)) {
            boolean _not;
            EObject eobj = obj;
            String id = this.registry.getID(eobj);
            boolean _isEmpty = false;
            if (id != null) {
                _isEmpty = id.isEmpty();
            }
            boolean bl = _not = !_isEmpty;
            if (_not) {
                objectsById.put(id, eobj);
            }
            Consumer<EObject> _function = new Consumer<EObject>(){

                @Override
                public void accept(EObject it) {
                    WorkspaceCrawler.this.extractIds_rec(it, objectsById);
                }
            };
            EcoreUtil.getAllContents((EObject)eobj, (boolean)true).forEachRemaining((Consumer)_function);
        }
    }

    public Resource loadResource(URI uri) {
        int maxAttempts = 5;
        IntegerRange _upTo = new IntegerRange(1, 5);
        for (Integer i : _upTo) {
            try {
                return new ResourceSetImpl().getResource(uri, true);
            }
            catch (Throwable _t) {
                if (_t instanceof Throwable) {
                    Throwable e = _t;
                    e.printStackTrace();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("[WorkspaceCrawler] Attempt ");
                    _builder.append((Object)i);
                    _builder.append(" of ");
                    _builder.append((Object)5);
                    _builder.append(" failed to load resource for URI ");
                    _builder.append((Object)uri);
                    this.debug(_builder.toString());
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return null;
    }

    public String debug(String message) {
        int _hashCode = ((Object)((Object)this)).hashCode();
        String _plus = "[WorkspaceCrawler-" + Integer.valueOf(_hashCode);
        String _plus_1 = String.valueOf(_plus) + " Thread-";
        int _hashCode_1 = Thread.currentThread().hashCode();
        String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(_hashCode_1);
        String _plus_3 = String.valueOf(_plus_2) + "] ";
        String _plus_4 = String.valueOf(_plus_3) + message;
        return (String)InputOutput.println((Object)_plus_4);
    }
}

