/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.referenceregistry;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.referenceregistry.KeyRequest;
import de.jabc.cinco.meta.core.referenceregistry.Request;
import de.jabc.cinco.meta.core.referenceregistry.UriRequest;
import de.jabc.cinco.meta.core.referenceregistry.WorkspaceCrawler;
import de.jabc.cinco.meta.core.referenceregistry.implementing.IFileExtensionSupplier;
import de.jabc.cinco.meta.core.referenceregistry.implementing.IIdentifierFunction;
import de.jabc.cinco.meta.core.referenceregistry.listener.RegistryResourceChangeListener;
import de.jabc.cinco.meta.runtime.CincoRuntimeBaseClass;
import de.jabc.cinco.meta.util.xapi.CodingExtension;
import graphmodel.GraphModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedTransferQueue;
import java.util.function.Consumer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ReferenceRegistry
extends CincoRuntimeBaseClass {
    private static final String EXTENSION_ID = "de.jabc.cinco.meta.core.referenceregistry";
    private static final Set<String> RESOURCE_BLACKLIST = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{".project", ".git", "_backup"}));
    private static final HashSet<String> KNOWN_EXTENSIONS = CollectionLiterals.newHashSet();
    private static final HashSet<IIdentifierFunction> KNOWN_ID_FUNCTIONS = CollectionLiterals.newHashSet();
    protected final LinkedTransferQueue<URI> uriQueue = new LinkedTransferQueue();
    protected final ConcurrentHashMap<URI, Set<Thread>> inProcess = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, List<KeyRequest>> keyRequests = new ConcurrentHashMap();
    protected final ConcurrentHashMap<URI, List<UriRequest>> uriRequests = new ConcurrentHashMap();
    protected WorkspaceCrawler crawler;
    protected final RegistryResourceChangeListener resourceListener = new RegistryResourceChangeListener();
    private boolean _initializedOnStartup = false;
    private boolean _initializingOnStartup = false;
    protected final ConcurrentHashMap<String, EObject> key_on_obj = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, String> key_on_resURI = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Set<String>> resURI_on_keys = new ConcurrentHashMap();
    private static ReferenceRegistry _instance;

    public static ReferenceRegistry getInstance() {
        ReferenceRegistry _referenceRegistry;
        ReferenceRegistry __instance;
        ReferenceRegistry _elvis = null;
        _elvis = _instance != null ? _instance : (__instance = (_instance = (_referenceRegistry = new ReferenceRegistry())));
        return _elvis;
    }

    private ReferenceRegistry() {
        Functions.Function1<IFileExtensionSupplier, List<String>> _function = new Functions.Function1<IFileExtensionSupplier, List<String>>(){

            public List<String> apply(IFileExtensionSupplier it) {
                return it.getKnownFileExtensions();
            }
        };
        Consumer<List<String>> _function_1 = new Consumer<List<String>>(){

            @Override
            public void accept(List<String> it) {
                KNOWN_EXTENSIONS.addAll(it);
            }
        };
        IterableExtensions.map((Iterable)this._workspaceExtension.getExtensions(EXTENSION_ID, IFileExtensionSupplier.class), (Functions.Function1)_function).forEach(_function_1);
        Consumer<IIdentifierFunction> _function_2 = new Consumer<IIdentifierFunction>(){

            @Override
            public void accept(IIdentifierFunction it) {
                CollectionExtensions.addAll(KNOWN_ID_FUNCTIONS, (Object[])new IIdentifierFunction[]{it});
            }
        };
        this._workspaceExtension.getExtensions(EXTENSION_ID, IIdentifierFunction.class).forEach(_function_2);
        this._workspaceExtension.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
    }

    public synchronized boolean isInitializedOnStartup() {
        return this._initializedOnStartup;
    }

    public synchronized boolean setInitializedOnStartup(boolean flag) {
        this._initializedOnStartup = flag;
        return this._initializedOnStartup;
    }

    public synchronized boolean isInitializingOnStartup() {
        return this._initializingOnStartup;
    }

    public synchronized boolean setInitializingOnStartup(boolean flag) {
        this._initializingOnStartup = flag;
        return this._initializingOnStartup;
    }

    public EObject getEObject(String key) {
        EObject _get_1;
        EObject _request;
        EObject _loadFromResource;
        EObject _elvis = null;
        EObject _elvis_1 = null;
        EObject _elvis_2 = null;
        EObject _get = this.key_on_obj.get(key);
        _elvis_2 = _get != null ? _get : (_loadFromResource = this.loadFromResource(key));
        _elvis_1 = _elvis_2 != null ? _elvis_2 : (_request = this.request(key));
        _elvis = _elvis_1 != null ? _elvis_1 : (_get_1 = this.key_on_obj.get(key));
        return _elvis;
    }

    public EObject loadFromResource(String key) {
        String uriStr = this.key_on_resURI.get(key);
        if (uriStr != null) {
            EObject obj = this.loadFromResource(URI.createPlatformResourceURI((String)uriStr, (boolean)true), key);
            if (obj != null) {
                this.key_on_obj.put(key, obj);
            }
            return obj;
        }
        return null;
    }

    public EObject loadFromResource(URI uri, String key) {
        int index;
        Resource res = this.loadResource(uri);
        if (res == null) {
            return null;
        }
        EObject obj = res.getEObject(key);
        if (obj == null && (index = key.lastIndexOf("/")) > -1) {
            String name = key.substring(index);
            obj = res.getEObject("/" + name);
        }
        return obj;
    }

    @Deprecated
    public GraphModel getGraphModelFromURI(URI uri) {
        Iterable<GraphModel> _lookup = this.lookup(uri, GraphModel.class);
        GraphModel _head = null;
        if (_lookup != null) {
            _head = (GraphModel)IterableExtensions.head(_lookup);
        }
        return _head;
    }

    public <T extends EObject> Set<T> lookup(Class<T> clazz) {
        Set _xblockexpression = null;
        this.workForRequest(null);
        _xblockexpression = IterableExtensions.toSet((Iterable)Iterables.filter(this.key_on_obj.values(), clazz));
        return _xblockexpression;
    }

    public <T extends EObject> Iterable<T> lookup(URI uri, Class<T> clazz) {
        boolean _not;
        Set result = null;
        Set<String> keys = this.resURI_on_keys.get(this.toPlatformString(uri));
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(keys);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            Functions.Function1<String, EObject> _function = new Functions.Function1<String, EObject>(){

                public EObject apply(String it) {
                    return ReferenceRegistry.this.key_on_obj.get(it);
                }
            };
            result = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)IterableExtensions.map(keys, (Functions.Function1)_function), clazz));
        }
        Set _elvis = null;
        if (result != null) {
            _elvis = result;
        } else {
            Map<String, EObject> _request = this.request(uri);
            Collection<EObject> _values = null;
            if (_request != null) {
                _values = _request.values();
            }
            Iterable _filter = null;
            if (_values != null) {
                _filter = Iterables.filter(_values, clazz);
            }
            Set _set = null;
            if (_filter != null) {
                _set = IterableExtensions.toSet((Iterable)_filter);
            }
            _elvis = _set;
        }
        return _elvis;
    }

    protected Resource loadResource(final URI uri) {
        Functions.Function1<CodingExtension.FunctionArgumentsNotSupported, Resource> _function = new Functions.Function1<CodingExtension.FunctionArgumentsNotSupported, Resource>(){

            public Resource apply(CodingExtension.FunctionArgumentsNotSupported it) {
                return new ResourceSetImpl().getResource(uri, true);
            }
        };
        Procedures.Procedure1<Exception> _function_1 = new Procedures.Procedure1<Exception>(){

            public void apply(Exception it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Failed to load resource for URI ");
                _builder.append((Object)uri);
                ReferenceRegistry.this._codingExtension.warn((Object)it, (CharSequence)_builder);
            }
        };
        return (Resource)this._codingExtension.onException((Functions.Function1)_function, (Procedures.Procedure1)_function_1);
    }

    @Deprecated
    public void addElement(EObject obj) {
        this.register(obj);
    }

    public EObject register(EObject obj) {
        EObject _xblockexpression = null;
        String id = this.getID(obj);
        EObject _xifexpression = null;
        if (id == null || id.isEmpty()) {
            this._workbenchExtension.showErrorDialog("Error adding Library Component", "The object " + obj + " has no ID feature or the ID is not set. " + "Cannot add it to the registry");
        } else {
            _xifexpression = this.register(id, obj);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public EObject register(String key, EObject obj) {
        Resource _eResource = obj.eResource();
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        return this.register(key, _uRI, obj);
    }

    public EObject register(String key, URI resUri, EObject obj) {
        String uri;
        EObject _xblockexpression = null;
        String _platformString = null;
        if (resUri != null) {
            _platformString = this.toPlatformString(resUri);
        }
        if ((uri = _platformString) != null) {
            this.key_on_resURI.put(key, uri);
            HashSet keys = this.resURI_on_keys.get(uri);
            if (keys == null) {
                keys = CollectionLiterals.newHashSet();
                this.resURI_on_keys.put(uri, keys);
            }
            this.resURI_on_keys.get(uri).add(key);
        }
        _xblockexpression = this.key_on_obj.put(key, obj);
        return _xblockexpression;
    }

    public EObject unregister(String key) {
        EObject _xifexpression = null;
        if (key != null) {
            EObject _xblockexpression = null;
            this.key_on_resURI.remove(key);
            _xifexpression = _xblockexpression = this.key_on_obj.remove(key);
        }
        return _xifexpression;
    }

    public Set<String> unregister(URI uri) {
        return this.resURI_on_keys.remove(this.toPlatformString(uri));
    }

    protected EObject request(final String key) {
        KeyRequest _keyRequest = new KeyRequest(key);
        Procedures.Procedure1<KeyRequest> _function = new Procedures.Procedure1<KeyRequest>(){

            public void apply(KeyRequest req) {
                boolean _not;
                boolean _containsKey = ReferenceRegistry.this.keyRequests.containsKey(key);
                boolean bl = _not = !_containsKey;
                if (_not) {
                    ReferenceRegistry.this.keyRequests.put(key, CollectionLiterals.newArrayList((Object[])new KeyRequest[]{req}));
                } else {
                    ReferenceRegistry.this.keyRequests.get(key).add(req);
                }
                ReferenceRegistry.this.workForRequest(req);
            }
        };
        KeyRequest request = (KeyRequest)ObjectExtensions.operator_doubleArrow((Object)_keyRequest, (Procedures.Procedure1)_function);
        return (EObject)request.result;
    }

    protected Map<String, EObject> request(final URI uri) {
        UriRequest _uriRequest = new UriRequest(uri);
        Procedures.Procedure1<UriRequest> _function = new Procedures.Procedure1<UriRequest>(){

            public void apply(UriRequest req) {
                boolean _not;
                boolean _containsKey = ReferenceRegistry.this.uriRequests.containsKey(uri);
                boolean bl = _not = !_containsKey;
                if (_not) {
                    ReferenceRegistry.this.uriRequests.put(uri, CollectionLiterals.newArrayList((Object[])new UriRequest[]{req}));
                } else {
                    ReferenceRegistry.this.uriRequests.get(uri).add(req);
                }
                ReferenceRegistry.this.workForRequest(req);
            }
        };
        UriRequest request = (UriRequest)ObjectExtensions.operator_doubleArrow((Object)_uriRequest, (Procedures.Procedure1)_function);
        return (Map)request.result;
    }

    public void initializeOnStartup() {
        WorkspaceCrawler _workspaceCrawler;
        long _currentTimeMillis = System.currentTimeMillis();
        String _plus = "[RefReg-" + Long.valueOf(_currentTimeMillis);
        String _plus_1 = String.valueOf(_plus) + "] Initializing on startup...";
        InputOutput.println((Object)_plus_1);
        this.setInitializingOnStartup(true);
        long debugTime = System.currentTimeMillis();
        this.crawler = _workspaceCrawler = new WorkspaceCrawler(this);
        long _currentTimeMillis_1 = System.currentTimeMillis();
        String _plus_2 = "[RefReg-" + Long.valueOf(_currentTimeMillis_1);
        String _plus_3 = String.valueOf(_plus_2) + "] Crawler: ";
        int _hashCode = 0;
        if (this.crawler != null) {
            _hashCode = ((Object)((Object)this.crawler)).hashCode();
        }
        String _plus_4 = String.valueOf(_plus_3) + Integer.valueOf(_hashCode);
        InputOutput.println((Object)_plus_4);
        Procedures.Procedure1<WorkspaceCrawler> _function = new Procedures.Procedure1<WorkspaceCrawler>(){

            public void apply(WorkspaceCrawler it) {
                it.collectFiles();
                it.workAndWait();
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)((Object)this.crawler), (Procedures.Procedure1)_function);
        long _currentTimeMillis_2 = System.currentTimeMillis();
        String _plus_5 = "[RefReg-" + Long.valueOf(_currentTimeMillis_2);
        String _plus_6 = String.valueOf(_plus_5) + "] Initialized. ";
        int _size = this.key_on_obj.size();
        String _plus_7 = String.valueOf(_plus_6) + Integer.valueOf(_size);
        String _plus_8 = String.valueOf(_plus_7) + " keys. ";
        int _size_1 = this.resURI_on_keys.size();
        String _plus_9 = String.valueOf(_plus_8) + Integer.valueOf(_size_1);
        String _plus_10 = String.valueOf(_plus_9) + " URIs. ";
        String _plus_11 = String.valueOf(_plus_10) + "This took ";
        long _currentTimeMillis_3 = System.currentTimeMillis();
        long _minus = _currentTimeMillis_3 - debugTime;
        String _plus_12 = String.valueOf(_plus_11) + Long.valueOf(_minus);
        String _plus_13 = String.valueOf(_plus_12) + "ms of your lifetime.";
        InputOutput.println((Object)_plus_13);
        this.setInitializedOnStartup(true);
        this.setInitializingOnStartup(false);
    }

    public String getID(EObject obj) {
        boolean _isNullOrEmpty;
        String id = EcoreUtil.getID((EObject)obj);
        if (StringExtensions.isNullOrEmpty((String)id) && obj instanceof EClass) {
            id = this.getEClassId((EClass)obj);
        }
        if (_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)id)) {
            for (IIdentifierFunction idFunc : KNOWN_ID_FUNCTIONS) {
                try {
                    boolean _not;
                    id = idFunc.getIdentifier(obj);
                    boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)id);
                    boolean bl = _not = !_isNullOrEmpty_1;
                    if (!_not) continue;
                    return id;
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        e.printStackTrace();
                        continue;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        return id;
    }

    public String getEClassId(EClass clazz) {
        String _nsURI = clazz.getEPackage().getNsURI();
        String _plus = String.valueOf(_nsURI) + "/";
        String _name = clazz.getName();
        return String.valueOf(_plus) + _name;
    }

    public String toPlatformString(URI uri) {
        String _xifexpression = null;
        boolean _isPlatformPlugin = uri.isPlatformPlugin();
        _xifexpression = _isPlatformPlugin ? uri.toString() : this.toPlatformResourceURI(uri).toPlatformString(true);
        return _xifexpression;
    }

    public URI toPlatformResourceURI(URI uri) {
        boolean _not;
        boolean _isPlatformResource = uri.isPlatformResource();
        boolean bl = _not = !_isPlatformResource;
        if (_not) {
            boolean _isRelative = uri.isRelative();
            if (_isRelative) {
                return URI.createPlatformResourceURI((String)uri.toString(), (boolean)true);
            }
            String _fileString = uri.toFileString();
            Path path = new Path(_fileString);
            IFile file = this._workspaceExtension.getWorkspaceRoot().getFileForLocation((IPath)path);
            return URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true);
        }
        return uri;
    }

    public static boolean isBlacklisted(IContainer con) {
        return RESOURCE_BLACKLIST.contains(con.getName());
    }

    public static boolean isWhitelisted(IFile file) {
        return KNOWN_EXTENSIONS.contains(file.getFileExtension()) || KNOWN_EXTENSIONS.contains(file.getName());
    }

    public void clearRegistry() {
        WorkspaceCrawler _doubleArrow;
        this.key_on_resURI.clear();
        this.resURI_on_keys.clear();
        this.key_on_obj.clear();
        WorkspaceCrawler _workspaceCrawler = new WorkspaceCrawler(this);
        Procedures.Procedure1<WorkspaceCrawler> _function = new Procedures.Procedure1<WorkspaceCrawler>(){

            public void apply(WorkspaceCrawler it) {
                it.collectFiles();
                it.schedule();
            }
        };
        this.crawler = _doubleArrow = (WorkspaceCrawler)((Object)ObjectExtensions.operator_doubleArrow((Object)((Object)_workspaceCrawler), (Procedures.Procedure1)_function));
    }

    public WorkspaceCrawler enqueue(URI uri) {
        WorkspaceCrawler _xifexpression = null;
        IFile _file = null;
        if (uri != null) {
            _file = this._workspaceExtension.getFile(uri);
        }
        boolean _isWhitelisted = false;
        if (_file != null) {
            _isWhitelisted = ReferenceRegistry.isWhitelisted(_file);
        }
        if (_isWhitelisted) {
            WorkspaceCrawler _xblockexpression = null;
            this.uriQueue.add(uri);
            _xifexpression = _xblockexpression = this.assertCrawler();
        }
        return _xifexpression;
    }

    protected synchronized WorkspaceCrawler assertCrawler() {
        WorkspaceCrawler _elvis = null;
        if (this.crawler != null) {
            _elvis = this.crawler;
        } else {
            boolean _not;
            WorkspaceCrawler _xifexpression = null;
            boolean _isEmpty = this.uriQueue.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                WorkspaceCrawler _doubleArrow;
                WorkspaceCrawler _workspaceCrawler = new WorkspaceCrawler(this);
                Procedures.Procedure1<WorkspaceCrawler> _function = new Procedures.Procedure1<WorkspaceCrawler>(){

                    public void apply(WorkspaceCrawler it) {
                        it.schedule();
                    }
                };
                _xifexpression = this.crawler = (_doubleArrow = (WorkspaceCrawler)((Object)ObjectExtensions.operator_doubleArrow((Object)((Object)_workspaceCrawler), (Procedures.Procedure1)_function)));
            }
            _elvis = _xifexpression;
        }
        return _elvis;
    }

    protected void workForRequest(Request<?, ?> request) {
        if (!this.isInitializedOnStartup() && !this.isInitializingOnStartup()) {
            this.initializeOnStartup();
            return;
        }
        WorkspaceCrawler _assertCrawler = this.assertCrawler();
        if (_assertCrawler != null) {
            _assertCrawler.workForRequest(request);
        }
    }

    public void handleAdd(URI uri) {
        this.handleChange(uri);
    }

    public void handleDelete(URI uri) {
        Set<String> keys = this.unregister(uri);
        if (keys != null) {
            Consumer<String> _function = new Consumer<String>(){

                @Override
                public void accept(String it) {
                    ReferenceRegistry.this.unregister(it);
                }
            };
            keys.forEach(_function);
        }
    }

    public void handleChange(URI uri) {
        Set<String> keys = this.unregister(uri);
        if (keys != null) {
            Consumer<String> _function = new Consumer<String>(){

                @Override
                public void accept(String it) {
                    ReferenceRegistry.this.unregister(it);
                }
            };
            keys.forEach(_function);
        }
        this.enqueue(uri);
    }

    public void handleRename(URI fromURI, URI toURI) {
        Set<String> keys = this.resURI_on_keys.remove(fromURI);
        if (keys != null) {
            Consumer<String> _function = new Consumer<String>(){

                @Override
                public void accept(String it) {
                    ReferenceRegistry.this.key_on_resURI.remove(it);
                }
            };
            keys.forEach(_function);
        }
        this.enqueue(toURI);
    }
}

