/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.search.editor.graphiti.wizard;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import info.scce.dime.search.editor.graphiti.SearchFactory;
import info.scce.dime.search.editor.graphiti.api.CSearch;
import info.scce.dime.search.editor.graphiti.wizard.SearchDiagramWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class SearchDiagramWizard
extends Wizard
implements INewWizard {
    private IWizardPage page;
    private IStructuredSelection ssel;

    public void addPages() {
        this.page = new SearchDiagramWizardPage("newSearch");
        this.addPage(this.page);
        super.addPages();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.ssel = selection;
    }

    public boolean performFinish() {
        if (this.page instanceof SearchDiagramWizardPage) {
            SearchDiagramWizardPage p = (SearchDiagramWizardPage)this.page;
            final String dir = p.getDirectory();
            final String fileName = p.getFileName();
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SearchDiagramWizard.this.createDiagram(dir, fileName);
                }
            };
            try {
                this.getContainer().run(false, false, operation);
            }
            catch (InterruptedException | InvocationTargetException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private void createDiagram(String dir, String fName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer containerResource = root.getContainerForLocation((IPath)new Path(dir));
        if (containerResource instanceof IContainer) {
            SearchFactory eFactory = (SearchFactory)EPackage.Registry.INSTANCE.getEFactory("http://dime.scce.info/search");
            CSearch _search = (CSearch)eFactory.createSearch(containerResource.getFullPath().toString(), fName);
            new WorkbenchExtension().openEditor((EObject)_search);
        }
    }

    public IStructuredSelection getSelection() {
        return this.ssel;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public boolean canFinish() {
        return this.page.isPageComplete();
    }
}

