/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.process.editor.graphiti.features.reconnect;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.api.CNode;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.errorhandling.ECincoError;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.Highlighter;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.ReconnectRegistry;
import graphmodel.internal.InternalEdge;
import graphmodel.internal.InternalNode;
import info.scce.dime.process.process.JavaNativeDirectDataFlow;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.DefaultReconnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class ReconnectFeatureJavaNativeDirectDataFlow
extends DefaultReconnectionFeature {
    private ECincoError error = ECincoError.OK;
    private InternalEdge internalEdge = null;
    private InternalNode internalNode = null;
    private boolean isReconnectSource = false;
    private boolean isReconnectTarget = false;

    public ReconnectFeatureJavaNativeDirectDataFlow(IFeatureProvider fp) {
        super(fp);
    }

    private boolean setContext(IReconnectionContext context) {
        Object boEdge = this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
        Object boNode = this.getBusinessObjectForPictogramElement(context.getTargetPictogramElement());
        if (boEdge instanceof InternalEdge && boNode instanceof InternalNode) {
            this.internalEdge = (InternalEdge)boEdge;
            this.internalNode = (InternalNode)boNode;
            if (ReconnectionContext.RECONNECT_SOURCE.equalsIgnoreCase(context.getReconnectType())) {
                this.isReconnectSource = true;
            } else if (ReconnectionContext.RECONNECT_TARGET.equalsIgnoreCase(context.getReconnectType())) {
                this.isReconnectTarget = true;
            }
            return true;
        }
        return false;
    }

    public void canceledReconnect(IReconnectionContext context) {
        ((Highlighter)Highlighter.INSTANCE.get()).onReconnectionCancel((String)ReconnectRegistry.INSTANCE.remove((Object)context.getConnection()));
        super.canceledReconnect(context);
    }

    public void preReconnect(IReconnectionContext context) {
        ((Highlighter)Highlighter.INSTANCE.get()).onReconnectionEnd((String)ReconnectRegistry.INSTANCE.remove((Object)context.getConnection()));
        this.setContext(context);
        super.preReconnect(context);
    }

    public boolean canReconnect(IReconnectionContext context, boolean apiCall) {
        if (apiCall) {
            if (!ReconnectRegistry.INSTANCE.containsKey((Object)context.getConnection())) {
                ReconnectRegistry.INSTANCE.put((Object)context.getConnection(), (Object)"");
                ReconnectRegistry.INSTANCE.put((Object)context.getConnection(), (Object)((Highlighter)Highlighter.INSTANCE.get()).onReconnectionStart((IReconnectionFeature)this, context));
            }
            Anchor newAnchor = this.getNewAnchor(context);
            Anchor oldAnchor = context.getOldAnchor();
            if (newAnchor == null) {
                return false;
            }
            if (newAnchor.equals(oldAnchor)) {
                return true;
            }
            if (!this.setContext(context)) {
                return false;
            }
            if (this.isReconnectTarget) {
                return this.internalNode.canEnd(JavaNativeDirectDataFlow.class);
            }
            if (this.isReconnectSource) {
                return this.internalNode.canStart(JavaNativeDirectDataFlow.class);
            }
            return false;
        }
        return false;
    }

    public boolean canReconnect(IReconnectionContext context) {
        return this.canReconnect(context, true);
    }

    public void postReconnect(IReconnectionContext context) {
        if (this.getNewAnchor(context).equals(context.getOldAnchor())) {
            return;
        }
        if (this.isReconnectSource) {
            this.internalEdge.set_sourceElement(this.internalNode);
        } else if (this.isReconnectTarget) {
            this.internalEdge.set_targetElement(this.internalNode);
        }
        UpdateContext uc = new UpdateContext((PictogramElement)context.getConnection());
        IUpdateFeature uf = this.getFeatureProvider().getUpdateFeature((IUpdateContext)uc);
        if (uf != null && uf.canUpdate((IUpdateContext)uc)) {
            uf.update((IUpdateContext)uc);
        }
    }

    protected Anchor getNewAnchor(IReconnectionContext context) {
        EObject innerBo;
        if (context.getNewAnchor() == null && (innerBo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(context.getTargetPictogramElement())) instanceof CNode) {
            return ((CNode)innerBo).getAnchor();
        }
        return context.getNewAnchor();
    }

    public ECincoError getError() {
        return this.error;
    }

    public void setError(ECincoError error) {
        this.error = error;
    }
}

