/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.gui.editor.graphiti.api;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.api.CGraphModel;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.provider.CincoFeatureProvider;
import graphmodel.ModelElement;
import info.scce.dime.gui.editor.graphiti.api.CDataContext;
import info.scce.dime.gui.editor.graphiti.api.CExtensionContext;
import info.scce.dime.gui.editor.graphiti.api.CListenerContext;
import info.scce.dime.gui.editor.graphiti.api.CTemplate;
import info.scce.dime.gui.editor.graphiti.features.create.CreateFeatureDataContext;
import info.scce.dime.gui.editor.graphiti.features.create.CreateFeatureExtensionContext;
import info.scce.dime.gui.editor.graphiti.features.create.CreateFeatureListenerContext;
import info.scce.dime.gui.editor.graphiti.features.create.CreateFeatureTemplate;
import info.scce.dime.gui.gui.DataContext;
import info.scce.dime.gui.gui.ExtensionContext;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.ListenerContext;
import info.scce.dime.gui.gui.Template;
import info.scce.dime.gui.gui.impl.GUIImpl;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorDummy;
import org.eclipse.graphiti.ui.services.GraphitiUi;

public class CGUI
extends GUIImpl
implements CGraphModel {
    private PictogramElement pe;
    private IFeatureProvider fp;

    public CGUI() {
        this.setId(EcoreUtil.generateUUID());
    }

    public Diagram getPictogramElement() {
        EObject bo;
        if (this.pe == null && this.eResource() != null && (bo = (EObject)this.eResource().getContents().get(0)) instanceof Diagram) {
            this.pe = (Diagram)bo;
        }
        return (Diagram)this.pe;
    }

    public void setPictogramElement(PictogramElement pe) {
        this.pe = pe;
    }

    public Template newTemplate(int x, int y) {
        return this.newTemplate(x, y, -1, -1);
    }

    public Template newTemplate(String id, int x, int y, int width, int height) {
        Template obj = this.newTemplate(x, y, width, height);
        obj.transact("SetId", () -> EcoreUtil.setID((EObject)obj, (String)id));
        return obj;
    }

    public Template newTemplate(int x, int y, int width, int height) {
        CreateContext cc = new CreateContext();
        cc.setLocation(10, 10);
        cc.setTargetContainer((ContainerShape)this.getPictogramElement());
        cc.setLocation(x, y);
        cc.setSize(width, height);
        IFeatureProvider fp = this.getFeatureProvider();
        CreateFeatureTemplate cf = new CreateFeatureTemplate(fp);
        if (fp instanceof CincoFeatureProvider) {
            Object[] retVal = ((CincoFeatureProvider)fp).executeFeature((IFeature)cf, (IContext)cc);
            if (retVal[0] == null) {
                return null;
            }
            CTemplate tmp = (CTemplate)((Object)retVal[0]);
            tmp.setPictogramElement((PictogramElement)((ContainerShape)retVal[1]));
            return tmp;
        }
        return null;
    }

    public DataContext newDataContext(int x, int y) {
        return this.newDataContext(x, y, -1, -1);
    }

    public DataContext newDataContext(String id, int x, int y, int width, int height) {
        DataContext obj = this.newDataContext(x, y, width, height);
        obj.transact("SetId", () -> EcoreUtil.setID((EObject)obj, (String)id));
        return obj;
    }

    public DataContext newDataContext(int x, int y, int width, int height) {
        CreateContext cc = new CreateContext();
        cc.setLocation(10, 10);
        cc.setTargetContainer((ContainerShape)this.getPictogramElement());
        cc.setLocation(x, y);
        cc.setSize(width, height);
        IFeatureProvider fp = this.getFeatureProvider();
        CreateFeatureDataContext cf = new CreateFeatureDataContext(fp);
        if (fp instanceof CincoFeatureProvider) {
            Object[] retVal = ((CincoFeatureProvider)fp).executeFeature((IFeature)cf, (IContext)cc);
            if (retVal[0] == null) {
                return null;
            }
            CDataContext tmp = (CDataContext)((Object)retVal[0]);
            tmp.setPictogramElement((PictogramElement)((ContainerShape)retVal[1]));
            return tmp;
        }
        return null;
    }

    public ListenerContext newListenerContext(int x, int y) {
        return this.newListenerContext(x, y, -1, -1);
    }

    public ListenerContext newListenerContext(String id, int x, int y, int width, int height) {
        ListenerContext obj = this.newListenerContext(x, y, width, height);
        obj.transact("SetId", () -> EcoreUtil.setID((EObject)obj, (String)id));
        return obj;
    }

    public ListenerContext newListenerContext(int x, int y, int width, int height) {
        CreateContext cc = new CreateContext();
        cc.setLocation(10, 10);
        cc.setTargetContainer((ContainerShape)this.getPictogramElement());
        cc.setLocation(x, y);
        cc.setSize(width, height);
        IFeatureProvider fp = this.getFeatureProvider();
        CreateFeatureListenerContext cf = new CreateFeatureListenerContext(fp);
        if (fp instanceof CincoFeatureProvider) {
            Object[] retVal = ((CincoFeatureProvider)fp).executeFeature((IFeature)cf, (IContext)cc);
            if (retVal[0] == null) {
                return null;
            }
            CListenerContext tmp = (CListenerContext)((Object)retVal[0]);
            tmp.setPictogramElement((PictogramElement)((ContainerShape)retVal[1]));
            return tmp;
        }
        return null;
    }

    public ExtensionContext newExtensionContext(int x, int y) {
        return this.newExtensionContext(x, y, -1, -1);
    }

    public ExtensionContext newExtensionContext(String id, int x, int y, int width, int height) {
        ExtensionContext obj = this.newExtensionContext(x, y, width, height);
        obj.transact("SetId", () -> EcoreUtil.setID((EObject)obj, (String)id));
        return obj;
    }

    public ExtensionContext newExtensionContext(int x, int y, int width, int height) {
        CreateContext cc = new CreateContext();
        cc.setLocation(10, 10);
        cc.setTargetContainer((ContainerShape)this.getPictogramElement());
        cc.setLocation(x, y);
        cc.setSize(width, height);
        IFeatureProvider fp = this.getFeatureProvider();
        CreateFeatureExtensionContext cf = new CreateFeatureExtensionContext(fp);
        if (fp instanceof CincoFeatureProvider) {
            Object[] retVal = ((CincoFeatureProvider)fp).executeFeature((IFeature)cf, (IContext)cc);
            if (retVal[0] == null) {
                return null;
            }
            CExtensionContext tmp = (CExtensionContext)((Object)retVal[0]);
            tmp.setPictogramElement((PictogramElement)((ContainerShape)retVal[1]));
            return tmp;
        }
        return null;
    }

    public GUI newGUI(String path, String fileName, boolean postCreateHook) {
        GUI graph = super.newGUI(path, fileName, postCreateHook);
        Diagram diagram = Graphiti.getPeCreateService().createDiagram("GUI", fileName, true);
        Resource res = graph.eResource();
        res.getContents().add(0, (Object)diagram);
        IFeatureProvider fp = GraphitiUi.getExtensionManager().createFeatureProvider(diagram);
        fp.link((PictogramElement)diagram, (Object)graph);
        graph.save();
        return graph;
    }

    public void update() {
        IFeatureProvider fp = this.getFeatureProvider();
        Diagram diagram = this.getDiagram();
        if (fp != null && diagram != null) {
            try {
                Diagram pe = this.getPictogramElement();
                if (pe != null) {
                    UpdateContext uc = new UpdateContext((PictogramElement)this.getPictogramElement());
                    IUpdateFeature uf = fp.getUpdateFeature((IUpdateContext)uc);
                    if (fp instanceof CincoFeatureProvider) {
                        ((CincoFeatureProvider)fp).executeFeature((IFeature)uf, (IContext)uc);
                    }
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public void delete() {
        throw new UnsupportedOperationException("Deleting a Graphmodel by api is not supported at the moment.");
    }

    public IFeatureProvider getFeatureProvider() {
        if (this.fp != null) {
            try {
                try {
                    IDiagramTypeProvider dtp;
                    Diagram diagram = this.getDiagram();
                    if (diagram != null && (dtp = this.fp.getDiagramTypeProvider()).getDiagram() == null) {
                        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
                        DiagramEditorDummy diagramEditor = new DiagramEditorDummy(dtp, editingDomain);
                        dtp.init(diagram, diagramEditor.getDiagramBehavior());
                    }
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {}
            return this.fp;
        }
        Diagram diagram = null;
        try {
            diagram = this.getDiagram();
        }
        catch (NullPointerException nullPointerException) {}
        if (diagram != null) {
            this.fp = GraphitiUi.getExtensionManager().createFeatureProvider(diagram);
        } else {
            IDiagramTypeProvider dtp = GraphitiUi.getExtensionManager().createDiagramTypeProvider("info.scce.dime.gui.editor.graphiti.GUIDiagramTypeProvider");
            this.fp = dtp.getFeatureProvider();
        }
        return this.fp;
    }

    public void setFeatureProvider(IFeatureProvider provider) {
        this.fp = provider;
    }

    public Diagram getDiagram() {
        Diagram curr = this.getPictogramElement();
        while (curr != null && curr.eContainer() != null) {
            curr = (PictogramElement)curr.eContainer();
        }
        if (curr instanceof Connection) {
            return ((Connection)curr).getParent();
        }
        return curr;
    }

    public PictogramElement fetchPictogramElement(ModelElement me) {
        Diagram diagram = this.getDiagram();
        if (diagram == null) {
            return null;
        }
        List pes = Graphiti.getLinkService().getPictogramElements(diagram, (EObject)me);
        if (pes != null && pes.size() > 0) {
            return (PictogramElement)pes.get(0);
        }
        return null;
    }
}

