/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.graphql.schema.editor.graphiti.wizard;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import info.scce.dime.graphql.schema.editor.graphiti.GraphQLFactory;
import info.scce.dime.graphql.schema.editor.graphiti.api.CGraphQL;
import info.scce.dime.graphql.schema.editor.graphiti.wizard.GraphQLDiagramWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class GraphQLDiagramWizard
extends Wizard
implements INewWizard {
    private IWizardPage page;
    private IStructuredSelection ssel;

    public void addPages() {
        this.page = new GraphQLDiagramWizardPage("newGraphQL");
        this.addPage(this.page);
        super.addPages();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.ssel = selection;
    }

    public boolean performFinish() {
        if (this.page instanceof GraphQLDiagramWizardPage) {
            GraphQLDiagramWizardPage p = (GraphQLDiagramWizardPage)this.page;
            final String dir = p.getDirectory();
            final String fileName = p.getFileName();
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    GraphQLDiagramWizard.this.createDiagram(dir, fileName);
                }
            };
            try {
                this.getContainer().run(false, false, operation);
            }
            catch (InterruptedException | InvocationTargetException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private void createDiagram(String dir, String fName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer containerResource = root.getContainerForLocation((IPath)new Path(dir));
        if (containerResource instanceof IContainer) {
            GraphQLFactory eFactory = (GraphQLFactory)EPackage.Registry.INSTANCE.getEFactory("http://dime.scce.info/graphql/schema");
            CGraphQL _graphQL = (CGraphQL)eFactory.createGraphQL(containerResource.getFullPath().toString(), fName);
            new WorkbenchExtension().openEditor((EObject)_graphQL);
        }
    }

    public IStructuredSelection getSelection() {
        return this.ssel;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public boolean canFinish() {
        return this.page.isPageComplete();
    }
}

