/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.graphql.schema.editor.graphiti.api;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.api.CGraphModel;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.provider.CincoFeatureProvider;
import graphmodel.ModelElement;
import info.scce.dime.graphql.schema.editor.graphiti.api.CForbiddenTypes;
import info.scce.dime.graphql.schema.editor.graphiti.api.CMutations;
import info.scce.dime.graphql.schema.editor.graphiti.api.CQueries;
import info.scce.dime.graphql.schema.editor.graphiti.api.CResolvers;
import info.scce.dime.graphql.schema.editor.graphiti.features.create.CreateFeatureForbiddenTypes;
import info.scce.dime.graphql.schema.editor.graphiti.features.create.CreateFeatureMutations;
import info.scce.dime.graphql.schema.editor.graphiti.features.create.CreateFeatureQueries;
import info.scce.dime.graphql.schema.editor.graphiti.features.create.CreateFeatureResolvers;
import info.scce.dime.graphql.schema.graphql.ForbiddenTypes;
import info.scce.dime.graphql.schema.graphql.GraphQL;
import info.scce.dime.graphql.schema.graphql.Mutations;
import info.scce.dime.graphql.schema.graphql.Queries;
import info.scce.dime.graphql.schema.graphql.Resolvers;
import info.scce.dime.graphql.schema.graphql.impl.GraphQLImpl;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorDummy;
import org.eclipse.graphiti.ui.services.GraphitiUi;

public class CGraphQL
extends GraphQLImpl
implements CGraphModel {
    private PictogramElement pe;
    private IFeatureProvider fp;

    public CGraphQL() {
        this.setId(EcoreUtil.generateUUID());
    }

    public Diagram getPictogramElement() {
        EObject bo;
        if (this.pe == null && this.eResource() != null && (bo = (EObject)this.eResource().getContents().get(0)) instanceof Diagram) {
            this.pe = (Diagram)bo;
        }
        return (Diagram)this.pe;
    }

    public void setPictogramElement(PictogramElement pe) {
        this.pe = pe;
    }

    public Queries newQueries(int x, int y) {
        return this.newQueries(x, y, -1, -1);
    }

    public Queries newQueries(String id, int x, int y, int width, int height) {
        Queries obj = this.newQueries(x, y, width, height);
        obj.transact("SetId", () -> EcoreUtil.setID((EObject)obj, (String)id));
        return obj;
    }

    public Queries newQueries(int x, int y, int width, int height) {
        CreateContext cc = new CreateContext();
        cc.setLocation(10, 10);
        cc.setTargetContainer((ContainerShape)this.getPictogramElement());
        cc.setLocation(x, y);
        cc.setSize(width, height);
        IFeatureProvider fp = this.getFeatureProvider();
        CreateFeatureQueries cf = new CreateFeatureQueries(fp);
        if (fp instanceof CincoFeatureProvider) {
            Object[] retVal = ((CincoFeatureProvider)fp).executeFeature((IFeature)cf, (IContext)cc);
            if (retVal[0] == null) {
                return null;
            }
            CQueries tmp = (CQueries)((Object)retVal[0]);
            tmp.setPictogramElement((PictogramElement)((ContainerShape)retVal[1]));
            return tmp;
        }
        return null;
    }

    public Mutations newMutations(int x, int y) {
        return this.newMutations(x, y, -1, -1);
    }

    public Mutations newMutations(String id, int x, int y, int width, int height) {
        Mutations obj = this.newMutations(x, y, width, height);
        obj.transact("SetId", () -> EcoreUtil.setID((EObject)obj, (String)id));
        return obj;
    }

    public Mutations newMutations(int x, int y, int width, int height) {
        CreateContext cc = new CreateContext();
        cc.setLocation(10, 10);
        cc.setTargetContainer((ContainerShape)this.getPictogramElement());
        cc.setLocation(x, y);
        cc.setSize(width, height);
        IFeatureProvider fp = this.getFeatureProvider();
        CreateFeatureMutations cf = new CreateFeatureMutations(fp);
        if (fp instanceof CincoFeatureProvider) {
            Object[] retVal = ((CincoFeatureProvider)fp).executeFeature((IFeature)cf, (IContext)cc);
            if (retVal[0] == null) {
                return null;
            }
            CMutations tmp = (CMutations)((Object)retVal[0]);
            tmp.setPictogramElement((PictogramElement)((ContainerShape)retVal[1]));
            return tmp;
        }
        return null;
    }

    public ForbiddenTypes newForbiddenTypes(int x, int y) {
        return this.newForbiddenTypes(x, y, -1, -1);
    }

    public ForbiddenTypes newForbiddenTypes(String id, int x, int y, int width, int height) {
        ForbiddenTypes obj = this.newForbiddenTypes(x, y, width, height);
        obj.transact("SetId", () -> EcoreUtil.setID((EObject)obj, (String)id));
        return obj;
    }

    public ForbiddenTypes newForbiddenTypes(int x, int y, int width, int height) {
        CreateContext cc = new CreateContext();
        cc.setLocation(10, 10);
        cc.setTargetContainer((ContainerShape)this.getPictogramElement());
        cc.setLocation(x, y);
        cc.setSize(width, height);
        IFeatureProvider fp = this.getFeatureProvider();
        CreateFeatureForbiddenTypes cf = new CreateFeatureForbiddenTypes(fp);
        if (fp instanceof CincoFeatureProvider) {
            Object[] retVal = ((CincoFeatureProvider)fp).executeFeature((IFeature)cf, (IContext)cc);
            if (retVal[0] == null) {
                return null;
            }
            CForbiddenTypes tmp = (CForbiddenTypes)((Object)retVal[0]);
            tmp.setPictogramElement((PictogramElement)((ContainerShape)retVal[1]));
            return tmp;
        }
        return null;
    }

    public Resolvers newResolvers(int x, int y) {
        return this.newResolvers(x, y, -1, -1);
    }

    public Resolvers newResolvers(String id, int x, int y, int width, int height) {
        Resolvers obj = this.newResolvers(x, y, width, height);
        obj.transact("SetId", () -> EcoreUtil.setID((EObject)obj, (String)id));
        return obj;
    }

    public Resolvers newResolvers(int x, int y, int width, int height) {
        CreateContext cc = new CreateContext();
        cc.setLocation(10, 10);
        cc.setTargetContainer((ContainerShape)this.getPictogramElement());
        cc.setLocation(x, y);
        cc.setSize(width, height);
        IFeatureProvider fp = this.getFeatureProvider();
        CreateFeatureResolvers cf = new CreateFeatureResolvers(fp);
        if (fp instanceof CincoFeatureProvider) {
            Object[] retVal = ((CincoFeatureProvider)fp).executeFeature((IFeature)cf, (IContext)cc);
            if (retVal[0] == null) {
                return null;
            }
            CResolvers tmp = (CResolvers)((Object)retVal[0]);
            tmp.setPictogramElement((PictogramElement)((ContainerShape)retVal[1]));
            return tmp;
        }
        return null;
    }

    public GraphQL newGraphQL(String path, String fileName, boolean postCreateHook) {
        GraphQL graph = super.newGraphQL(path, fileName, postCreateHook);
        Diagram diagram = Graphiti.getPeCreateService().createDiagram("GraphQL", fileName, true);
        Resource res = graph.eResource();
        res.getContents().add(0, (Object)diagram);
        IFeatureProvider fp = GraphitiUi.getExtensionManager().createFeatureProvider(diagram);
        fp.link((PictogramElement)diagram, (Object)graph);
        graph.save();
        return graph;
    }

    public void update() {
        IFeatureProvider fp = this.getFeatureProvider();
        Diagram diagram = this.getDiagram();
        if (fp != null && diagram != null) {
            try {
                Diagram pe = this.getPictogramElement();
                if (pe != null) {
                    UpdateContext uc = new UpdateContext((PictogramElement)this.getPictogramElement());
                    IUpdateFeature uf = fp.getUpdateFeature((IUpdateContext)uc);
                    if (fp instanceof CincoFeatureProvider) {
                        ((CincoFeatureProvider)fp).executeFeature((IFeature)uf, (IContext)uc);
                    }
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public void delete() {
        throw new UnsupportedOperationException("Deleting a Graphmodel by api is not supported at the moment.");
    }

    public IFeatureProvider getFeatureProvider() {
        if (this.fp != null) {
            try {
                try {
                    IDiagramTypeProvider dtp;
                    Diagram diagram = this.getDiagram();
                    if (diagram != null && (dtp = this.fp.getDiagramTypeProvider()).getDiagram() == null) {
                        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
                        DiagramEditorDummy diagramEditor = new DiagramEditorDummy(dtp, editingDomain);
                        dtp.init(diagram, diagramEditor.getDiagramBehavior());
                    }
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {}
            return this.fp;
        }
        Diagram diagram = null;
        try {
            diagram = this.getDiagram();
        }
        catch (NullPointerException nullPointerException) {}
        if (diagram != null) {
            this.fp = GraphitiUi.getExtensionManager().createFeatureProvider(diagram);
        } else {
            IDiagramTypeProvider dtp = GraphitiUi.getExtensionManager().createDiagramTypeProvider("info.scce.dime.graphql.schema.editor.graphiti.GraphQLDiagramTypeProvider");
            this.fp = dtp.getFeatureProvider();
        }
        return this.fp;
    }

    public void setFeatureProvider(IFeatureProvider provider) {
        this.fp = provider;
    }

    public Diagram getDiagram() {
        Diagram curr = this.getPictogramElement();
        while (curr != null && curr.eContainer() != null) {
            curr = (PictogramElement)curr.eContainer();
        }
        if (curr instanceof Connection) {
            return ((Connection)curr).getParent();
        }
        return curr;
    }

    public PictogramElement fetchPictogramElement(ModelElement me) {
        Diagram diagram = this.getDiagram();
        if (diagram == null) {
            return null;
        }
        List pes = Graphiti.getLinkService().getPictogramElements(diagram, (EObject)me);
        if (pes != null && pes.size() > 0) {
            return (PictogramElement)pes.get(0);
        }
        return null;
    }
}

