/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.graphql.schema.editor.graphiti;

import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import info.scce.dime.graphql.schema.editor.graphiti.GraphQLGraphitiUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.graphiti.ui.platform.AbstractImageProvider;
import org.eclipse.graphiti.ui.platform.IImageProvider;
import org.osgi.framework.Bundle;

public class GraphQLImageProvider
extends AbstractImageProvider
implements IImageProvider {
    private Hashtable<String, String> images;

    public GraphQLImageProvider() {
        GraphQLGraphitiUtils.getInstance().setImageProvider(this);
    }

    public void addImage(String id, String path) {
        if (this.images == null) {
            this.images = new Hashtable();
        }
        this.images.put(id, path);
    }

    public String getImageId(String path) {
        for (Map.Entry<String, String> e : this.images.entrySet()) {
            if (!e.getValue().equals(path)) continue;
            return e.getKey();
        }
        try {
            WorkspaceExtension workspaceExtension = new WorkspaceExtension();
            IWorkspaceRoot root = workspaceExtension.getWorkspaceRoot();
            List files = workspaceExtension.getFiles((IContainer)root, f -> f.getFullPath().toString().contains(path));
            if (files.size() == 1) {
                IFile f2 = (IFile)files.get(0);
                URL url = f2.getLocationURI().toURL();
                if (this.images.get(path) == null) {
                    this.addImage(path, url.toString());
                    this.addImageFilePath(path, url.toString());
                }
            } else {
                File f3 = new File(path);
                if (f3.exists()) {
                    this.addImage(path, f3.toURI().toURL().toString());
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return path;
    }

    protected void addAvailableImages() {
        if (this.images == null) {
            this.images = new Hashtable();
        }
        for (Map.Entry<String, String> e : this.images.entrySet()) {
            if (this.getImageFilePath(e.getKey()) != null) continue;
            this.addImageFilePath(e.getKey(), e.getValue());
        }
    }

    public void initImages() {
        Bundle b = Platform.getBundle((String)"info.scce.dime.editor.graphiti");
        URL url = null;
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/gui/ForbiddenFalse.png"), null);
        this.addImage("icons/gui/ForbiddenFalse.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/gql.png"), null);
        this.addImage("icons/gql.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/userType.png"), null);
        this.addImage("icons/userType.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/processSIB.png"), null);
        this.addImage("icons/processSIB.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/process/palette/inputPort.png"), null);
        this.addImage("icons/process/palette/inputPort.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/concreteType.png"), null);
        this.addImage("icons/concreteType.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/attribute.png"), null);
        this.addImage("icons/attribute.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/graphql/errorPort.png"), null);
        this.addImage("icons/graphql/errorPort.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/gui/ForbiddenTrue.png"), null);
        this.addImage("icons/gui/ForbiddenTrue.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/process/palette/outputPort.png"), null);
        this.addImage("icons/process/palette/outputPort.png", url.toString());
        b = Platform.getBundle((String)"de.jabc.cinco.meta.core.ge.style.generator.runtime");
        url = FileLocator.find((Bundle)b, (IPath)new Path("/icons/_Connection.png"), null);
        this.addImage("_Connection.png", url.toString());
        this.addAvailableImages();
    }
}

