/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.graphql.schema.editor.graphiti;

import graphmodel.Container;
import graphmodel.Edge;
import graphmodel.ModelElement;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.graphql.schema.editor.graphiti.GraphQLDiagramEditor;
import info.scce.dime.graphql.schema.editor.graphiti.GraphQLImageProvider;
import info.scce.dime.graphql.schema.factory.GraphQLFactory;
import info.scce.dime.graphql.schema.graphql.GraphQL;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.OptionalInt;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class GraphQLGraphitiUtils {
    public static final String KEY_FORMAT_STRING = "formatString";
    private GraphQLImageProvider ip;
    private IDiagramTypeProvider dtp;
    private static GraphQLGraphitiUtils instance;

    private GraphQLGraphitiUtils() {
    }

    public static GraphQLGraphitiUtils getInstance() {
        if (instance == null) {
            instance = new GraphQLGraphitiUtils();
        }
        return instance;
    }

    public static GraphQL addGraphQLToResource(Diagram d, IFeatureProvider fp) {
        GraphQL somegraph = null;
        for (Object o : d.eResource().getContents()) {
            if (!(o instanceof GraphQL)) continue;
            somegraph = (GraphQL)o;
            break;
        }
        if (somegraph == null) {
            somegraph = GraphQLFactory.eINSTANCE.createGraphQL();
            d.eResource().getContents().add((Object)somegraph);
            fp.link((PictogramElement)d, (Object)somegraph);
        }
        return somegraph;
    }

    public String loadGraphitiImage(String path, EObject bo) {
        try {
            File file = new File(path);
            Bundle b = Platform.getBundle((String)"info.scce.dime.graphql.schema");
            File bundleFile = FileLocator.getBundleFile((Bundle)b);
            if (!file.exists()) {
                String filePath = bo.eResource().getURI().toPlatformString(true);
                IFile resFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
                IProject p = resFile.getProject();
                IFile iFile = p.getFile(path);
                if (iFile.exists()) {
                    file = iFile.getLocation().toFile();
                } else {
                    throw new FileNotFoundException("No file with path: " + path + " found...");
                }
            }
            FileInputStream fis = new FileInputStream(file);
            File trgFile = bundleFile.toPath().resolve("icons/" + file.getName()).toFile();
            trgFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(trgFile);
            this.copy(fis, fos);
            String id = file.getName().contains(".") ? file.getName().split("\\.")[0] : file.getName();
            String relPath = "icons/" + file.getName();
            this.addImage(id, relPath);
            return id;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void addImage(String id, String path) {
        this.ip.addImage(id, path);
    }

    public String getImageId(String path) {
        return this.ip.getImageId(path);
    }

    public void setImageProvider(GraphQLImageProvider ip) {
        this.ip = ip;
    }

    public void loadImages() {
        this.ip.initImages();
    }

    public void setDTP(IDiagramTypeProvider dtp) {
        this.dtp = dtp;
    }

    public IDiagramTypeProvider getDTP() {
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (part instanceof GraphQLDiagramEditor) {
            return ((GraphQLDiagramEditor)part).getDiagramTypeProvider();
        }
        return this.dtp;
    }

    private void copy(FileInputStream fis, FileOutputStream fos) {
        int b = 0;
        try {
            while ((b = fis.read()) != -1) {
                fos.write(b);
            }
            fis.close();
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ModelElementContainer getCommonContainer(ModelElementContainer ce, Edge e) {
        Node source = e.getSourceElement();
        Node target = e.getTargetElement();
        if (EcoreUtil.isAncestor((EObject)ce, (EObject)source) && EcoreUtil.isAncestor((EObject)ce, (EObject)target)) {
            for (Container c : ce.getAllContainers()) {
                if (!EcoreUtil.isAncestor((EObject)c, (EObject)source) || !EcoreUtil.isAncestor((EObject)c, (EObject)target)) continue;
                return this.getCommonContainer((ModelElementContainer)c, e);
            }
        } else if (ce instanceof ModelElement) {
            return this.getCommonContainer(((ModelElement)ce).getContainer(), e);
        }
        return ce;
    }

    public int max(int[] values) {
        OptionalInt max = Arrays.stream(values).max();
        if (max.isPresent()) {
            return max.getAsInt();
        }
        return 0;
    }

    public int min(int[] values) {
        OptionalInt min = Arrays.stream(values).min();
        if (min.isPresent()) {
            return min.getAsInt();
        }
        return 0;
    }

    public int[] transform(int[] values, int deltaX, int deltaY) {
        if (values.length > 0) {
            int i = 0;
            while (i < values.length) {
                values[i] = values[i] + deltaX;
                values[i + 1] = values[i + 1] + deltaY;
                i += 2;
            }
        }
        return values;
    }
}

