/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.dad.editor.graphiti.wizard;

import info.scce.dime.dad.editor.graphiti.wizard.DADDiagramWizard;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DADDiagramWizardPage
extends WizardPage {
    public static String FILE_EXTENSION = "dad";
    private IContainer container;
    private Text directoryText;
    private Text fileNameText;
    private Button browseButton;
    private SelectionListener buttonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            DirectoryDialog dialog = new DirectoryDialog(DADDiagramWizardPage.this.getShell());
            dialog.setText("Select a directory");
            String rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            dialog.setFilterPath(rootLocation);
            String directory = dialog.open();
            if (directory != null) {
                DADDiagramWizardPage.this.setDirectory(directory);
            }
            DADDiagramWizardPage.this.dialogChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private KeyListener textKeyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            DADDiagramWizardPage.this.dialogChanged();
        }

        public void keyPressed(KeyEvent e) {
        }
    };

    public DADDiagramWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Create new DAD diagram");
        this.setMessage("Choose a directory and a file name for the new DAD diagram");
    }

    public String getDirectory() {
        return this.directoryText.getText();
    }

    private void setDirectory(String newValue) {
        this.directoryText.setText(newValue);
    }

    public String getFileName() {
        return this.fileNameText.getText();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        Label directoryLabel = new Label(composite, 0);
        directoryLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        directoryLabel.setText("Di&rectory: ");
        this.directoryText = new Text(composite, 2048);
        this.directoryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.directoryText.setEditable(false);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText("Brows&e...");
        this.browseButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        Label fileNameLabel = new Label(composite, 0);
        fileNameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        fileNameLabel.setText("Fi&le name: ");
        this.fileNameText = new Text(composite, 2048);
        this.fileNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fileNameText.setText("");
        Text extensionText = new Text(composite, 2048);
        extensionText.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        extensionText.setText("." + FILE_EXTENSION);
        extensionText.setEditable(false);
        this.directoryText.addKeyListener(this.textKeyListener);
        this.fileNameText.addKeyListener(this.textKeyListener);
        this.browseButton.addSelectionListener(this.buttonListener);
        IStructuredSelection selection = null;
        if (this.getWizard() instanceof DADDiagramWizard) {
            selection = ((DADDiagramWizard)this.getWizard()).getSelection();
        }
        if (selection != null && selection.getFirstElement() instanceof IContainer) {
            this.container = (IContainer)selection.getFirstElement();
            this.directoryText.setText(this.container.getLocation().toOSString());
        }
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    private void dialogChanged() {
        String directoryError = this.validateDirectory();
        if (directoryError != null) {
            this.updateStatus(directoryError);
            return;
        }
        String fileNameError = this.validateFileName();
        if (fileNameError != null) {
            this.updateStatus(fileNameError);
            return;
        }
        String fileExistsError = this.validateFileExists();
        if (fileExistsError != null) {
            this.updateStatus(fileExistsError);
            return;
        }
        this.updateStatus(null);
    }

    private String validateDirectory() {
        String directory = this.getDirectory();
        if (directory.isEmpty()) {
            return "Select existing directory";
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        boolean isProject = Arrays.stream(projects).anyMatch(project -> {
            IPath projectPath = project.getLocation();
            Path directoryPath = new Path(directory);
            return projectPath.isPrefixOf((IPath)directoryPath);
        });
        if (!isProject) {
            return "The directory must be inside a project form your workspace";
        }
        return null;
    }

    private String validateFileName() {
        String fileName = this.getFileName();
        if (fileName.isEmpty()) {
            return "Enter a file name";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String validateFileExists() {
        String fileName = String.valueOf(this.getFileName()) + "." + FILE_EXTENSION;
        try {
            if (this.container == null) {
                return null;
            }
            IResource[] iResourceArray = this.container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return null;
                }
                IResource res = iResourceArray[n2];
                if (res.getName().equals(fileName)) {
                    return "File already exists";
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void updateStatus(String errorMessage) {
        this.setErrorMessage(errorMessage);
        if (this.getContainer().getCurrentPage() != null) {
            this.getWizard().getContainer().updateMessage();
            this.getWizard().getContainer().updateButtons();
        }
        this.setPageComplete(errorMessage == null);
    }
}

