/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.dad.editor.graphiti;

import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import info.scce.dime.dad.editor.graphiti.DADGraphitiUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.graphiti.ui.platform.AbstractImageProvider;
import org.eclipse.graphiti.ui.platform.IImageProvider;
import org.osgi.framework.Bundle;

public class DADImageProvider
extends AbstractImageProvider
implements IImageProvider {
    private Hashtable<String, String> images;

    public DADImageProvider() {
        DADGraphitiUtils.getInstance().setImageProvider(this);
    }

    public void addImage(String id, String path) {
        if (this.images == null) {
            this.images = new Hashtable();
        }
        this.images.put(id, path);
    }

    public String getImageId(String path) {
        for (Map.Entry<String, String> e : this.images.entrySet()) {
            if (!e.getValue().equals(path)) continue;
            return e.getKey();
        }
        try {
            WorkspaceExtension workspaceExtension = new WorkspaceExtension();
            IWorkspaceRoot root = workspaceExtension.getWorkspaceRoot();
            List files = workspaceExtension.getFiles((IContainer)root, f -> f.getFullPath().toString().contains(path));
            if (files.size() == 1) {
                IFile f2 = (IFile)files.get(0);
                URL url = f2.getLocationURI().toURL();
                if (this.images.get(path) == null) {
                    this.addImage(path, url.toString());
                    this.addImageFilePath(path, url.toString());
                }
            } else {
                File f3 = new File(path);
                if (f3.exists()) {
                    this.addImage(path, f3.toURI().toURL().toString());
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return path;
    }

    protected void addAvailableImages() {
        if (this.images == null) {
            this.images = new Hashtable();
        }
        for (Map.Entry<String, String> e : this.images.entrySet()) {
            if (this.getImageFilePath(e.getKey()) != null) continue;
            this.addImageFilePath(e.getKey(), e.getValue());
        }
    }

    public void initImages() {
        Bundle b = Platform.getBundle((String)"info.scce.dime.editor.graphiti");
        URL url = null;
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/DataModel.png"), null);
        this.addImage("icons/DataModel.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/dime16.png"), null);
        this.addImage("icons/dime16.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/graphql/graphql.png"), null);
        this.addImage("icons/graphql/graphql.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/userType.png"), null);
        this.addImage("icons/userType.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/dime-green.png"), null);
        this.addImage("icons/dime-green.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/SearchModel.png"), null);
        this.addImage("icons/SearchModel.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/dime-grey.png"), null);
        this.addImage("icons/dime-grey.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/ProcessModel.png"), null);
        this.addImage("icons/ProcessModel.png", url.toString());
        url = FileLocator.find((Bundle)b, (IPath)new Path("icons/GUI.png"), null);
        this.addImage("icons/GUI.png", url.toString());
        b = Platform.getBundle((String)"de.jabc.cinco.meta.core.ge.style.generator.runtime");
        url = FileLocator.find((Bundle)b, (IPath)new Path("/icons/_Connection.png"), null);
        this.addImage("_Connection.png", url.toString());
        this.addAvailableImages();
    }
}

